/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    private static ClassLoader setContextClassLoaderInternal(ClassLoader classLoader) {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return result;
    }

    static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            return SecurityActions.setContextClassLoaderInternal(classLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return SecurityActions.setContextClassLoaderInternal(classLoader);
            }
        });
    }

    static void resetContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
}

