/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.extensions.wsrm.RMClientSequence;
import org.jboss.ws.extensions.wsrm.transport.RMChannelResponse;
import org.jboss.ws.extensions.wsrm.transport.RMMarshaller;
import org.jboss.ws.extensions.wsrm.transport.RMMessage;
import org.jboss.ws.extensions.wsrm.transport.RMTransportHelper;
import org.jboss.ws.extensions.wsrm.transport.RMUnMarshaller;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandler;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RMChannelTask
implements Callable<RMChannelResponse> {
    private static final Logger logger = Logger.getLogger(RMChannelTask.class);
    private static final String JBOSSWS_SUBSYSTEM = "jbossws-wsrm";
    private final RMMessage rmRequest;

    RMChannelTask(RMMessage rmRequest) {
        this.rmRequest = rmRequest;
    }

    @Override
    public RMChannelResponse call() {
        try {
            String targetAddress = (String)this.rmRequest.getMetadata().getContext("invocationContext").get("targetAddress");
            String version = (String)this.rmRequest.getMetadata().getContext("invocationContext").get("remotingVersion");
            if (version.startsWith("1.4")) {
                MarshalFactory.addMarshaller((String)"JBossWSMessage", (Marshaller)RMMarshaller.getInstance(), (UnMarshaller)RMUnMarshaller.getInstance());
            }
            InvokerLocator locator = new InvokerLocator(targetAddress);
            URI backPort = RMTransportHelper.getBackPortURI(this.rmRequest);
            String messageId = RMTransportHelper.getAddressingMessageId(this.rmRequest);
            logger.debug((Object)("[WS-RM] backport URI is: " + backPort));
            RMCallbackHandler callbackHandler = null;
            if (backPort != null) {
                callbackHandler = RMCallbackHandlerFactory.getCallbackHandler(backPort);
                RMClientSequence sequence = RMTransportHelper.getSequence(this.rmRequest);
                if (sequence != null) {
                    callbackHandler.addUnassignedMessageListener(sequence);
                }
            }
            boolean oneWay = RMTransportHelper.isOneWayOperation(this.rmRequest);
            Client client = new Client(locator, JBOSSWS_SUBSYSTEM, this.rmRequest.getMetadata().getContext("remotingConfigurationContext"));
            client.connect();
            client.setMarshaller(RMMarshaller.getInstance());
            if (!oneWay && null == backPort) {
                client.setUnMarshaller(RMUnMarshaller.getInstance());
            }
            Map<String, Object> remotingInvocationContext = this.rmRequest.getMetadata().getContext("remotingInvocationContext");
            MessageTrace.traceMessage("Outgoing RM Request Message", this.rmRequest.getPayload());
            RMMessage rmResponse = null;
            if (oneWay && null == backPort) {
                client.invokeOneway((Object)this.rmRequest.getPayload(), remotingInvocationContext, false);
            } else {
                Object retVal;
                block13: {
                    retVal = null;
                    try {
                        retVal = client.invoke((Object)this.rmRequest.getPayload(), remotingInvocationContext);
                    }
                    catch (CannotConnectException cce) {
                        if (cce.getCause() instanceof NullPointerException) break block13;
                        throw cce;
                    }
                }
                if (null != retVal && !(retVal instanceof RMMessage)) {
                    String msg = retVal.getClass().getName() + ": '" + retVal + "'";
                    logger.warn((Object)msg);
                    throw new IOException(msg);
                }
                rmResponse = (RMMessage)retVal;
            }
            client.disconnect();
            if (rmResponse != null && backPort == null) {
                MessageTrace.traceMessage("Incoming RM Response Message", rmResponse.getPayload());
            }
            if (backPort != null && null != messageId && !RMTransportHelper.isOneWayOperation(this.rmRequest)) {
                return new RMChannelResponse(callbackHandler, messageId);
            }
            return new RMChannelResponse(rmResponse);
        }
        catch (Throwable t) {
            return new RMChannelResponse(t);
        }
    }
}

