/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.loggingmonitor;

import java.util.HashMap;
import java.util.Map;

class RolloverPeriod {
    private static final Map periodFormatsMap = new HashMap();
    private String rolloverPeriod;
    private String rolloverFormat;

    public RolloverPeriod(String rolloverPeriod) {
        this.rolloverFormat = (String)periodFormatsMap.get(rolloverPeriod.toUpperCase());
        if (this.rolloverFormat == null) {
            throw new IllegalArgumentException("Unknown rollover period: " + rolloverPeriod);
        }
        this.rolloverPeriod = rolloverPeriod;
    }

    public String getRolloverFormat() {
        return this.rolloverFormat;
    }

    public String toString() {
        return this.rolloverPeriod;
    }

    static {
        periodFormatsMap.put("MONTH", "'.'yyyy-MM");
        periodFormatsMap.put("MONTHLY", "'.'yyyy-MM");
        periodFormatsMap.put("WEEK", "'.'yyyy-ww");
        periodFormatsMap.put("WEEKLY", "'.'yyyy-ww");
        periodFormatsMap.put("DAY", "'.'yyyy-MM-dd");
        periodFormatsMap.put("DAILY", "'.'yyyy-MM-dd");
        periodFormatsMap.put("HALFDAY", "'.'yyyy-MM-dd-a");
        periodFormatsMap.put("HALFDAILY", "'.'yyyy-MM-dd-a");
        periodFormatsMap.put("HOUR", "'.'yyyy-MM-dd-HH");
        periodFormatsMap.put("HOURLY", "'.'yyyy-MM-dd-HH");
        periodFormatsMap.put("MINUTE", "'.'yyyy-MM-dd-HH-mm");
    }
}

