/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.pointcut.ConstructorMatcher;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.WithinMatcher;
import org.jboss.aop.pointcut.ast.ASTCall;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;
import org.jboss.aop.pointcut.ast.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorCallMatcher
extends MatcherHelper {
    Advisor advisor;
    AccessibleObject within;
    Class<?> calledClass;
    Constructor<?> calledConstructor;

    public ConstructorCallMatcher(Advisor advisor, AccessibleObject within, Class<?> calledClass, Constructor<?> calledCon, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.within = within;
        this.calledClass = calledClass;
        this.calledConstructor = calledCon;
    }

    @Override
    public Object visit(ASTCall node, Object data) {
        try {
            if (!(node.getBehavior() instanceof ASTConstructor)) {
                return Boolean.FALSE;
            }
            ASTConstructor astCon = (ASTConstructor)node.getBehavior();
            Advisor calledAdvisor = AspectManager.instance().getTempClassAdvisorIfNotExist(this.calledClass);
            ConstructorMatcher constructorMatcher = new ConstructorMatcher(calledAdvisor, this.calledConstructor, null);
            return constructorMatcher.matches(astCon);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object visit(ASTHas node, Object data) {
        Node n = node.jjtGetChild(0);
        if (n instanceof ASTMethod) {
            return new Boolean(Util.has(this.calledClass, (ASTMethod)n, this.advisor));
        }
        return new Boolean(Util.has(this.calledClass, (ASTConstructor)n, this.advisor));
    }

    @Override
    public Object visit(ASTHasField node, Object data) {
        ASTField f = (ASTField)node.jjtGetChild(0);
        return new Boolean(Util.has(this.calledClass, f, this.advisor));
    }

    @Override
    public Object visit(ASTWithin node, Object data) {
        WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
        return node.jjtAccept(visitor, null);
    }

    @Override
    public Object visit(ASTWithincode node, Object data) {
        WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
        return node.jjtAccept(visitor, null);
    }

    @Override
    protected Boolean resolvePointcut(Pointcut p) {
        return new Boolean(p.matchesCall(this.advisor, this.within, this.calledClass, this.calledConstructor));
    }
}

