/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Dispatcher;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Scope(value=ScopeType.EVENT)
@BypassInterceptors
@Name(value="org.jboss.seam.core.events")
@Install(precedence=0)
public class Events {
    private static final LogProvider log = Logging.getLogProvider(Events.class);

    public void addListener(String type, String methodBindingExpression, Class ... argTypes) {
        Expressions.MethodExpression<Object> methodBinding = Expressions.instance().createMethodExpression(methodBindingExpression, Object.class, argTypes);
        Init.instance().addObserverMethodExpression(type, methodBinding);
    }

    public void raiseEvent(String type, Object ... parameters) {
        List<Init.ObserverMethod> observers;
        log.debug("Processing event:" + type);
        List<Init.ObserverMethodExpression> list = Init.instance().getObserverMethodExpressions(type);
        if (list != null) {
            for (Init.ObserverMethodExpression listener : list) {
                listener.getMethodBinding().invoke(parameters);
            }
        }
        if ((observers = Init.instance().getObserverMethods(type)) != null) {
            for (Init.ObserverMethod observer : observers) {
                String name = observer.getComponent().getName();
                Object listener = Component.getInstance(name, observer.isCreate(), false);
                if (observer.getComponent().hasUnwrapMethod()) {
                    listener = observer.getComponent().getScope().getContext().get(name);
                }
                if (listener == null) continue;
                observer.getComponent().callComponentMethod(listener, observer.getMethod(), parameters);
            }
        }
    }

    public void raiseAsynchronousEvent(String type, Object ... parameters) {
        this.getDispatcher().scheduleAsynchronousEvent(type, parameters);
    }

    public void raiseTimedEvent(String type, Schedule schedule, Object ... parameters) {
        this.getDispatcher().scheduleTimedEvent(type, schedule, parameters);
    }

    public void raiseTransactionSuccessEvent(String type, Object ... parameters) {
        this.getDispatcher().scheduleTransactionSuccessEvent(type, parameters);
    }

    public void raiseTransactionCompletionEvent(String type, Object ... parameters) {
        this.getDispatcher().scheduleTransactionCompletionEvent(type, parameters);
    }

    protected Dispatcher getDispatcher() {
        return AbstractDispatcher.instance();
    }

    public static boolean exists() {
        return Contexts.isEventContextActive() && Events.instance() != null;
    }

    public static Events instance() {
        return (Events)Component.getInstance(Events.class, ScopeType.EVENT);
    }
}

