/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.annotations.Namespace;
import org.jboss.seam.deployment.AbstractDeploymentHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDeploymentHandler
extends AbstractDeploymentHandler {
    public static final String NAME = "org.jboss.seam.deployment.NamespaceDeploymentHandler";
    private static final LogProvider log = Logging.getLogProvider(NamespaceDeploymentHandler.class);
    private Set<Package> packages = new HashSet<Package>();

    public Set<Package> getPackages() {
        return Collections.unmodifiableSet(this.packages);
    }

    @Override
    public void handle(String name, ClassLoader classLoader) {
        if (name.endsWith("/package-info.class")) {
            String packageName = NamespaceDeploymentHandler.filenameToPackageName(name);
            Package pkg = NamespaceDeploymentHandler.getPackage(packageName, classLoader);
            if (pkg == null) {
                log.warn("Cannot load package Dinfo for " + packageName);
            } else if (pkg.getAnnotation(Namespace.class) != null) {
                this.packages.add(pkg);
            }
        }
    }

    private static String filenameToPackageName(String filename) {
        return filename.substring(0, filename.lastIndexOf("/package-info.class")).replace('/', '.').replace('\\', '.');
    }

    private static Package getPackage(String name, ClassLoader classLoader) {
        try {
            Class<?> c = classLoader.loadClass(name + ".package-info");
            return c != null ? c.getPackage() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

