/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.HashSet;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public abstract class RecursionAwareCI
extends LocalObject
implements ClientRequestInterceptor {
    private final HashSet thread_stacks = new HashSet();
    private final HashSet ignore_operations = new HashSet();

    public RecursionAwareCI(boolean bl) {
        if (bl) {
            this.ignore_operations.add("_is_a");
            this.ignore_operations.add("_get_interface");
            this.ignore_operations.add("_non_existent");
            this.ignore_operations.add("_get_policy");
            this.ignore_operations.add("_get_domain_managers");
            this.ignore_operations.add("_set_policy_overrides");
            this.ignore_operations.add("_get_component");
        }
    }

    private boolean enterCall(String string) {
        if (this.ignore_operations.contains(string)) {
            return false;
        }
        Thread thread = Thread.currentThread();
        if (this.thread_stacks.contains(thread)) {
            return false;
        }
        this.thread_stacks.add(thread);
        return true;
    }

    private void exitCall() {
        this.thread_stacks.remove(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (this.enterCall(clientRequestInfo.operation())) {
            try {
                this.do_send_request(clientRequestInfo);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send_poll(ClientRequestInfo clientRequestInfo) {
        if (this.enterCall(clientRequestInfo.operation())) {
            try {
                this.do_send_poll(clientRequestInfo);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive_reply(ClientRequestInfo clientRequestInfo) {
        if (this.enterCall(clientRequestInfo.operation())) {
            try {
                this.do_receive_reply(clientRequestInfo);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (this.enterCall(clientRequestInfo.operation())) {
            try {
                this.do_receive_exception(clientRequestInfo);
            }
            finally {
                this.exitCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (this.enterCall(clientRequestInfo.operation())) {
            try {
                this.do_receive_other(clientRequestInfo);
            }
            finally {
                this.exitCall();
            }
        }
    }

    public abstract void do_send_request(ClientRequestInfo var1) throws ForwardRequest;

    public abstract void do_send_poll(ClientRequestInfo var1);

    public abstract void do_receive_reply(ClientRequestInfo var1);

    public abstract void do_receive_exception(ClientRequestInfo var1) throws ForwardRequest;

    public abstract void do_receive_other(ClientRequestInfo var1) throws ForwardRequest;
}

