/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtil {
    private static final Log LOG = LogFactory.getLog(StreamUtil.class);

    private StreamUtil() {
    }

    public static byte[] slurp(InputStream stream) throws RuntimeException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtil.copy(stream, out, true);
        return out.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws RuntimeException {
        return StreamUtil.copy(input, output, true);
    }

    public static long copy(InputStream input, OutputStream output, boolean closeStreams) throws RuntimeException {
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        try {
            input = new BufferedInputStream(input, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                numBytesCopied += (long)bytesRead;
                bytesRead = input.read(buffer);
            }
            output.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be copied", ioe);
        }
        finally {
            if (closeStreams) {
                try {
                    output.close();
                }
                catch (IOException ioe2) {
                    LOG.warn((Object)"Streams could not be closed", (Throwable)ioe2);
                }
                try {
                    input.close();
                }
                catch (IOException ioe2) {
                    LOG.warn((Object)"Streams could not be closed", (Throwable)ioe2);
                }
            }
        }
        return numBytesCopied;
    }

    public static long copy(InputStream input, OutputStream output, long startByte, long length) throws RuntimeException {
        if (length == 0L) {
            return 0L;
        }
        if (startByte < 0L) {
            throw new IllegalArgumentException("startByte=" + startByte);
        }
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        try {
            byte[] buffer = new byte[bufferSize];
            if (startByte > 0L) {
                input.skip(startByte);
            }
            int bytesRead = input.read(buffer, 0, length < 0L || length >= (long)bufferSize ? bufferSize : (int)length);
            while (bytesRead > 0) {
                output.write(buffer, 0, bytesRead);
                numBytesCopied += (long)bytesRead;
                bytesRead = input.read(buffer, 0, (length -= (long)bytesRead) < 0L || length >= (long)bufferSize ? bufferSize : (int)length);
            }
            output.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be copied", ioe);
        }
        return numBytesCopied;
    }

    public static byte[] serialize(Serializable object) throws RuntimeException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(byteStream);
            oos.writeObject(object);
            oos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to serialize object", ioe);
        }
        return byteStream.toByteArray();
    }

    public static Object deserialize(byte[] serializedData) throws RuntimeException {
        Object retObject;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serializedData);
        try {
            ObjectInputStream ois = new ObjectInputStream(byteStream);
            retObject = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize object", e);
        }
        return retObject;
    }
}

