/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.segments.Segment;
import org.apache.sanselan.util.Debug;

public class SOSSegment
extends Segment {
    public SOSSegment(int marker, int marker_length, InputStream is) throws ImageReadException, IOException {
        super(marker, marker_length);
        if (this.getDebug()) {
            System.out.println("SOSSegment marker_length: " + marker_length);
        }
        Debug.debug("SOS", marker_length);
        int number_of_components_in_scan = this.readByte("number_of_components_in_scan", is, "Not a Valid JPEG File");
        Debug.debug("number_of_components_in_scan", number_of_components_in_scan);
        for (int i = 0; i < number_of_components_in_scan; ++i) {
            byte scan_component_selector = this.readByte("scan_component_selector", is, "Not a Valid JPEG File");
            Debug.debug("scan_component_selector", (int)scan_component_selector);
            byte ac_dc_entrooy_coding_table_selector = this.readByte("ac_dc_entrooy_coding_table_selector", is, "Not a Valid JPEG File");
            Debug.debug("ac_dc_entrooy_coding_table_selector", (int)ac_dc_entrooy_coding_table_selector);
        }
        byte start_of_spectral_selection = this.readByte("start_of_spectral_selection", is, "Not a Valid JPEG File");
        Debug.debug("start_of_spectral_selection", (int)start_of_spectral_selection);
        byte end_of_spectral_selection = this.readByte("end_of_spectral_selection", is, "Not a Valid JPEG File");
        Debug.debug("end_of_spectral_selection", (int)end_of_spectral_selection);
        byte successive_approximation_bit_position = this.readByte("successive_approximation_bit_position", is, "Not a Valid JPEG File");
        Debug.debug("successive_approximation_bit_position", (int)successive_approximation_bit_position);
        if (this.getDebug()) {
            System.out.println("");
        }
    }

    public String getDescription() {
        return "SOS (" + this.getSegmentType() + ")";
    }
}

