/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.jsf;

import java.lang.annotation.Annotation;
import javax.faces.context.FacesContext;
import javax.inject.AnnotationLiteral;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.conversation.ConversationIdName;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

public class PhaseHelper {
    private static LogProvider log = Logging.getLogProvider(PhaseHelper.class);
    private static final String CONVERSATION_PROPAGATION_KEY = "webbeans_conversation_propagation";

    private static FacesContext context() {
        return FacesContext.getCurrentInstance();
    }

    public static boolean isPostback() {
        return PhaseHelper.context().getRenderKit().getResponseStateManager().isPostback(PhaseHelper.context());
    }

    public static void propagateConversation(String cid) {
        PhaseHelper.context().getViewRoot().getAttributes().put(CONVERSATION_PROPAGATION_KEY, cid);
        log.debug((Object)("Updated propagation component with cid " + cid));
    }

    public static String getConversationIdFromRequest() {
        String cidName = CurrentManager.rootManager().getInstanceByType(String.class, new Annotation[]{new AnnotationLiteral<ConversationIdName>(){}});
        String cid = (String)PhaseHelper.context().getExternalContext().getRequestParameterMap().get(cidName);
        log.trace((Object)("Got cid " + cid + " from request"));
        return cid;
    }

    public static String getConversationIdFromViewRoot() {
        String cid = (String)PhaseHelper.context().getViewRoot().getAttributes().get(CONVERSATION_PROPAGATION_KEY);
        log.trace((Object)("Got cid " + cid + " from propagation component"));
        return cid;
    }

    public static String getConversationId() {
        String cid = null;
        cid = PhaseHelper.isPostback() ? PhaseHelper.getConversationIdFromViewRoot() : PhaseHelper.getConversationIdFromRequest();
        log.debug((Object)("Resuming conversation " + cid));
        return cid;
    }

    public static HttpSession getHttpSession() {
        return (HttpSession)PhaseHelper.context().getExternalContext().getSession(true);
    }

    public static void stopConversationPropagation() {
        PhaseHelper.context().getViewRoot().getAttributes().remove(CONVERSATION_PROPAGATION_KEY);
    }
}

