/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.deployer.env;

import javax.inject.ExecutionException;
import javax.inject.manager.Manager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;

public class WebBeansJndiBinder {
    private String jndiName = null;

    public void startService(String jndiContextPath, String managerObjectFactoryClass) throws Exception {
        this.jndiName = jndiContextPath;
        Reference managerReference = new Reference(Manager.class.getName(), managerObjectFactoryClass, null);
        this.bind(jndiContextPath, managerReference);
    }

    public void stopService() throws Exception {
        InitialContext initialContext = new InitialContext();
        initialContext.unbind(this.jndiName);
    }

    protected void bind(String key, Object binding) throws Exception {
        InitialContext initialContext = new InitialContext();
        try {
            String[] parts = key.split("/");
            int length = parts.length;
            Context context = initialContext;
            for (int i = 0; i < length - 1; ++i) {
                Context nextContext;
                try {
                    nextContext = (Context)context.lookup(parts[i]);
                }
                catch (NamingException e) {
                    nextContext = context.createSubcontext(parts[i]);
                }
                context = nextContext;
            }
            context.bind(parts[length - 1], binding);
        }
        catch (NamingException e) {
            throw new ExecutionException("Cannot bind " + binding + " to " + key, (Throwable)e);
        }
    }
}

