/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SAAJFactoryLoader;
import javax.xml.soap.SAAJMetaFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Element;

public abstract class SOAPFactory {
    private static SOAPFactory soapFactory;

    public static SOAPFactory newInstance() throws SOAPException {
        if (soapFactory == null) {
            try {
                String propertyName = "javax.xml.soap.SOAPFactory";
                soapFactory = (SOAPFactory)SAAJFactoryLoader.loadFactory(propertyName, null);
            }
            catch (RuntimeException rte) {
                throw new SOAPException(rte);
            }
            if (soapFactory == null) {
                SAAJMetaFactory saajFactory = SAAJMetaFactory.getInstance();
                soapFactory = saajFactory.newSOAPFactory("SOAP 1.1 Protocol");
            }
            if (soapFactory == null) {
                throw new SOAPException("Failed to to determine the SOAPFactory implementation class");
            }
        }
        return soapFactory;
    }

    public static SOAPFactory newInstance(String protocol) throws SOAPException {
        SAAJMetaFactory saajFactory = SAAJMetaFactory.getInstance();
        SOAPFactory factory = saajFactory.newSOAPFactory(protocol);
        if (factory == null) {
            throw new SOAPException("Failed to to determine the SOAPFactory implementation class");
        }
        return factory;
    }

    public abstract Detail createDetail() throws SOAPException;

    public SOAPElement createElement(Element domElement) throws SOAPException {
        throw new IllegalStateException("Should be implemented by concrete implementation of this class");
    }

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public SOAPElement createElement(QName qname) throws SOAPException {
        throw new IllegalStateException("Should be implemented by concrete implementation of this class");
    }

    public abstract SOAPFault createFault(String var1, QName var2) throws SOAPException;

    public abstract SOAPFault createFault() throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;
}

