/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import org.jboss.messaging.core.impl.NullPersistenceManager;

class IDCounter {
    private NullPersistenceManager manager;
    private short counter;
    private long tmMark;
    private long peerIDBit;
    private static final long MASK_SERVER_PEER_ID = 255L;
    private static final long MASK_TIME = 0xFFFFFFFFFF0L;

    public IDCounter(NullPersistenceManager pManager) {
        this.manager = pManager;
        this.counter = 0;
        this.tmMark = this.manager.getTimeMark() & 0xFFFFFFFFFF0L;
        this.peerIDBit = ((long)this.manager.getPeerID() & 0xFFL) << 56;
        this.recalculate();
    }

    public synchronized long reserveAndGetNextId(int size) throws Exception {
        if (size > Short.MAX_VALUE) {
            throw new Exception("The block size exceeds 32767");
        }
        if (size > Short.MAX_VALUE - this.counter) {
            this.recalculate();
        }
        long nextID = this.assembleID();
        this.counter = (short)(this.counter + size);
        return nextID;
    }

    private long assembleID() {
        long id = this.peerIDBit;
        id += this.tmMark << 12;
        return id += (long)this.counter;
    }

    private void recalculate() {
        this.counter = 0;
        long newTm = System.currentTimeMillis() & 0xFFFFFFFFFF0L;
        while (newTm == this.tmMark) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            newTm = System.currentTimeMillis() & 0xFFFFFFFFFF0L;
        }
        this.tmMark = newTm;
    }
}

