/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.profileservice.spi.metadata.SubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicSubProfileMetaData;
import org.jboss.system.server.profileservice.repository.StaticProfileFactory;
import org.jboss.system.server.profileservice.repository.clustered.metadata.ClusteredProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.clustered.metadata.HotDeploymentClusteredProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.clustered.metadata.ImmutableClusteredProfileSourceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticClusteredProfileFactory
extends StaticProfileFactory {
    private static final String HASINGLETON_NAME = "deploy-hasingleton";
    private static final String FARM_NAME = "farm";
    private List<URI> hasingletonURIs;
    private List<URI> farmURIs;

    public List<URI> getHASingletonURIs() {
        return this.hasingletonURIs;
    }

    public void setHASingletonURIs(List<URI> hasingletonURIs) {
        this.hasingletonURIs = hasingletonURIs;
    }

    public List<URI> getFarmURIs() {
        return this.farmURIs;
    }

    public void setFarmURIs(List<URI> farmURIs) {
        this.farmURIs = farmURIs;
    }

    @Override
    protected String[] createApplicationProfiles(String[] applicationsSubProfiles) {
        String[] stringArray;
        String applicationProfileName = super.createApplicationProfile(applicationsSubProfiles);
        ProfileMetaData farm = null;
        if (this.getFarmURIs() != null) {
            ProfileKey farmKey = new ProfileKey(FARM_NAME);
            URI[] farmURIs = this.getFarmURIs().toArray(new URI[this.getFarmURIs().size()]);
            String[] farmSubProfiles = new String[]{applicationProfileName};
            farm = this.createClusteredProfileMetaData(FARM_NAME, true, farmURIs, farmSubProfiles);
            this.addProfile(farmKey, farm);
        }
        if (this.getHASingletonURIs() != null) {
            ProfileKey hasingletonKey = new ProfileKey(HASINGLETON_NAME);
            URI[] hasingletonURIs = this.getHASingletonURIs().toArray(new URI[this.getHASingletonURIs().size()]);
            String[] hasingletonSubProfiles = new String[]{};
            ProfileMetaData hasingletons = this.createProfileMetaData(HASINGLETON_NAME, true, hasingletonURIs, hasingletonSubProfiles);
            this.addProfile(hasingletonKey, hasingletons);
        }
        if (farm == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = applicationProfileName;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = FARM_NAME;
        }
        return stringArray;
    }

    private ProfileMetaData createClusteredProfileMetaData(String name, boolean hotDeployment, URI[] uris, String[] subProfiles) {
        BasicProfileMetaData metaData = new BasicProfileMetaData();
        metaData.setName(name);
        ProfileSourceMetaData source = this.createClusteredSource(uris, hotDeployment);
        metaData.setSource(source);
        ArrayList<SubProfileMetaData> profileList = new ArrayList<SubProfileMetaData>();
        for (String subProfile : subProfiles) {
            BasicSubProfileMetaData md = new BasicSubProfileMetaData();
            md.setName(subProfile);
            profileList.add(md);
        }
        metaData.setSubprofiles(profileList);
        return metaData;
    }

    protected ProfileSourceMetaData createClusteredSource(URI[] uris, boolean hotDeployment) {
        ClusteredProfileSourceMetaData source = null;
        source = hotDeployment ? new HotDeploymentClusteredProfileSourceMetaData() : new ImmutableClusteredProfileSourceMetaData();
        ArrayList<String> sources = new ArrayList<String>();
        for (URI uri : uris) {
            sources.add(uri.toString());
        }
        source.setSources(sources);
        return source;
    }
}

