/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.core.value.EditableBinaryValue;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.EditableValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BinaryValue
extends BaseValue
implements EditableBinaryValue {
    public static final int TYPE = 2;
    protected EditableValueData changedData = null;
    protected boolean changed = false;
    protected static Log log = ExoLogger.getLogger((String)"jcr.BinaryValue");

    public BinaryValue(String text) throws IOException {
        super(2, new TransientValueData(text));
    }

    public BinaryValue(InputStream stream, FileCleaner fileCleaner, File tempDirectory, int maxFufferSize) throws IOException {
        this(new TransientValueData(0, null, stream, null, fileCleaner, maxFufferSize, tempDirectory, true, false));
    }

    BinaryValue(TransientValueData data) throws IOException {
        super(2, data);
    }

    BinaryValue(ValueData data) {
        super(2, data);
    }

    public ValueData getInternalData() {
        if (this.changedData != null) {
            return this.changedData;
        }
        return super.getInternalData();
    }

    protected BaseValue.LocalSessionValueData getLocalData(boolean asStream) throws IOException {
        if (this.changed) {
            this.data = null;
            this.changed = false;
        }
        return super.getLocalData(asStream);
    }

    public String getReference() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getInternalString();
    }

    public void update(InputStream stream, long length, long position) throws IOException, RepositoryException {
        if (this.changedData == null) {
            this.changedData = this.createEditableCopy(this.getInternalData());
        }
        this.changedData.update(stream, length, position);
        this.changed = true;
    }

    public void setLength(long size) throws IOException, RepositoryException {
        if (this.changedData == null) {
            this.changedData = this.createEditableCopy(this.getInternalData());
        }
        this.changedData.setLength(size);
        this.changed = true;
    }

    private EditableValueData createEditableCopy(ValueData oldValue) throws RepositoryException, IllegalStateException, IOException {
        if (oldValue.isByteArray()) {
            byte[] oldBytes = oldValue.getAsByteArray();
            byte[] newBytes = new byte[oldBytes.length];
            System.arraycopy(oldBytes, 0, newBytes, 0, newBytes.length);
            try {
                return new EditableValueData(newBytes, oldValue.getOrderNumber(), null, -1, null);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            EditableValueData copy = new EditableValueData(oldValue.getAsStream(), oldValue.getOrderNumber(), null, -1, null);
            return copy;
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException("Create editable copy error. " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Create editable copy error. " + e, (Throwable)e);
        }
    }
}

