/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CyclicDependencyException
extends IllegalStateException {
    private final List<String> invocations = new ArrayList<String>();
    private String tailComponentName;
    private boolean cycleComplete;

    public void addInvocation(String componentName, Method method) {
        if (this.cycleComplete) {
            return;
        }
        if (this.invocations.isEmpty()) {
            this.tailComponentName = componentName;
        } else if (this.tailComponentName.equals(componentName)) {
            this.cycleComplete = true;
        }
        this.invocations.add(this.createInvocationLabel(componentName, method));
    }

    private String createInvocationLabel(String componentName, Method method) {
        String invocationLabel = componentName + "." + method.getName() + "(";
        int i = 1;
        for (Class<?> parameterType : method.getParameterTypes()) {
            invocationLabel = invocationLabel + parameterType.getSimpleName();
            if (i < method.getParameterTypes().length) {
                invocationLabel = invocationLabel + ", ";
            }
            ++i;
        }
        invocationLabel = invocationLabel + ")";
        return invocationLabel;
    }

    public String getMessage() {
        if (!this.cycleComplete) {
            return "Cyclic dependency found";
        }
        String message = "Injection into " + this.tailComponentName + " resulted in a dependency cycle, requiring the invocation of " + this.invocations.get(0) + ".  The complete cycle: ";
        for (int i = this.invocations.size() - 1; i >= 0; --i) {
            message = message + this.invocations.get(i);
            if (i == 0) continue;
            message = message + " -> ";
        }
        return message;
    }
}

