/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.seam.core.Expressions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParser {
    private List<Expressions.ValueExpression> parameterValueBindings = new ArrayList<Expressions.ValueExpression>();
    private StringBuilder ejbqlBuilder;

    public static String getParameterName(int loc) {
        return "el" + (loc + 1);
    }

    public String getEjbql() {
        return this.ejbqlBuilder.toString();
    }

    public List<Expressions.ValueExpression> getParameterValueBindings() {
        return this.parameterValueBindings;
    }

    public QueryParser(String ejbql) {
        this(ejbql, 0);
    }

    public QueryParser(String ejbql, int startingParameterNumber) {
        StringTokenizer tokens = new StringTokenizer(ejbql, "#}", true);
        this.ejbqlBuilder = new StringBuilder(ejbql.length());
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("#".equals(token)) {
                if (!tokens.hasMoreTokens()) {
                    throw new IllegalArgumentException("query fragment terminates in #");
                }
                String expressionToken = tokens.nextToken();
                if (!expressionToken.startsWith("{")) {
                    throw new IllegalArgumentException("missing { after # in query fragment");
                }
                if (!tokens.hasMoreTokens()) {
                    throw new IllegalArgumentException("missing } after expression in query fragment");
                }
                String expression = token + expressionToken + tokens.nextToken();
                this.ejbqlBuilder.append(':').append(QueryParser.getParameterName(startingParameterNumber + this.parameterValueBindings.size()));
                this.parameterValueBindings.add(Expressions.instance().createValueExpression(expression));
                continue;
            }
            this.ejbqlBuilder.append(token);
        }
    }
}

