/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.staticdirect;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.UINonPublishedForm;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.UIPublicationForm;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.UIPublishedForm;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.UIStaticDirectVersionList;
import org.exoplatform.services.ecm.publication.plugins.webui.VersionNode;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAndDirectPublicationPlugin
extends PublicationPlugin {
    public static final String ENROLLED = "enrolled".intern();
    public static final String NON_PUBLISHED = "non published".intern();
    public static final String PUBLISHED = "published".intern();
    public static final String DEFAULT_STATE = NON_PUBLISHED;
    public static final String PUBLICATION = "publication:publication".intern();
    public static final String LIFECYCLE_NAME = "publication:lifecycleName".intern();
    public static final String CURRENT_STATE = "publication:currentState".intern();
    public static final String HISTORY = "publication:history".intern();
    public static final String VISIBILITY = "publication:visibility".intern();
    public static final String VERSIONS_PUBLICATION_STATES = "publication:versionsPublicationStates".intern();
    public static final String PUBLIC = "public".intern();
    public static final String PRIVATE = "private".intern();
    public static final String MIXIN_TYPE = "publication:staticAndDirectPublication".intern();
    public static final String IMG_PATH = "resources/images/".intern();
    protected static Log log;
    private final String localeFile = "locale.portlet.publication.PublicationService";
    private static final int BUFFER_SIZE = 512;

    public StaticAndDirectPublicationPlugin() {
        log = ExoLogger.getLogger((String)"portal:StaticAndDirectPublicationPlugin");
    }

    @Override
    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        block26: {
            log.info((Object)("Change node state to " + newState));
            Session session = node.getSession();
            ManageableRepository managerepository = (ManageableRepository)session.getRepository();
            Session systemSession = managerepository.getSystemSession(session.getWorkspace().getName());
            node = (Node)systemSession.getItem(node.getPath());
            String userid = session.getUserID();
            try {
                if (newState.equals(ENROLLED)) {
                    log.info((Object)("Set node to " + PUBLISHED));
                    if (node.canAddMixin("mix:versionable")) {
                        node.addMixin("mix:versionable");
                    }
                    node.save();
                    Version version = node.checkin();
                    node.checkout();
                    String newStringValue = version.getUUID() + "," + PUBLISHED;
                    Value value2add = session.getValueFactory().createValue(newStringValue);
                    Value[] values = new Value[]{value2add};
                    node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                    node.setProperty(CURRENT_STATE, PUBLISHED);
                    String visibility = PUBLIC;
                    Value newValueVisibility = session.getValueFactory().createValue(visibility);
                    node.setProperty(VISIBILITY, newValueVisibility);
                    this.setVisibility(node, visibility);
                    log.info((Object)"Add log");
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                    String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                    String versionName = session.getNodeByUUID(version.getUUID()).getName();
                    String[] log = new String[]{date, PUBLISHED, userid, "PublicationService.StaticAndDirectPublicationPlugin.nodeCreated", versionName, visibility};
                    publicationService.addLog(node, log);
                    node.setProperty(CURRENT_STATE, PUBLISHED);
                    break block26;
                }
                if (newState.equals(PUBLISHED)) {
                    Value value2add;
                    int i;
                    String currentState = node.getProperty(CURRENT_STATE).getString();
                    if (currentState.equals(NON_PUBLISHED)) {
                        int i2;
                        log.info((Object)"Node is non published");
                        String nodeVersionUUID = context.get("nodeVersionUUID");
                        String visibility = context.get("visibility");
                        if (nodeVersionUUID == null || visibility == null) {
                            log.error((Object)"nodeVersionUUID or visibility is null");
                            throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : nodeVersionUUID or visibility is not present in context.");
                        }
                        log.info((Object)"nodeVersionUUID and visibility is not null");
                        Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
                        for (i2 = 0; i2 < values.length && !values[i2].getString().split(",")[0].equals(nodeVersionUUID); ++i2) {
                        }
                        if (i2 == values.length || values[i2].getString().split(",")[1].equals(NON_PUBLISHED)) {
                            log.info((Object)"Specified version not already published");
                            log.info((Object)"Set this version published");
                            String newStringValue = nodeVersionUUID + "," + PUBLISHED;
                            Value value2add2 = session.getValueFactory().createValue(newStringValue);
                            if (i2 == values.length) {
                                values = this.addValueToArray(values, value2add2);
                            } else {
                                values[i2] = value2add2;
                            }
                            node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                            log.info((Object)"Set the visibility");
                            Value newValueVisibility = session.getValueFactory().createValue(visibility);
                            node.setProperty(VISIBILITY, newValueVisibility);
                            log.info((Object)"Set permissions in function of visibility");
                            this.setVisibility(node, visibility);
                            node.setProperty(CURRENT_STATE, PUBLISHED);
                            log.info((Object)"Add log");
                            ExoContainer container = ExoContainerContext.getCurrentContainer();
                            PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                            String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                            String version = session.getNodeByUUID(nodeVersionUUID).getName();
                            String[] log = new String[]{date, newState, userid, "PublicationService.StaticAndDirectPublicationPlugin.nodePublished", version, visibility};
                            publicationService.addLog(node, log);
                            break block26;
                        }
                        throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : Node Version " + nodeVersionUUID + " is already published");
                    }
                    log.info((Object)"Node is already published, user want to published another version.");
                    String nodeVersionUUID = context.get("nodeVersionUUID");
                    String visibility = context.get("visibility");
                    if (nodeVersionUUID == null || visibility == null) {
                        log.error((Object)"nodeVersionUUID or visibility is null");
                        throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : nodeVersionUUID or visibility is not present in context.");
                    }
                    log.info((Object)"nodeVersionUUID and visibility is not null");
                    Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
                    for (i = 0; i < values.length && !values[i].getString().split(",")[1].equals(PUBLISHED); ++i) {
                    }
                    if (i == values.length) {
                        throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : currentState is published but no version is published");
                    }
                    String publishedVersionUUID = values[i].getString().split(",")[0];
                    log.info((Object)"Unpublished current published version");
                    String newStringValue = publishedVersionUUID + "," + NON_PUBLISHED;
                    values[i] = value2add = session.getValueFactory().createValue(newStringValue);
                    node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                    for (i = 0; i < values.length && !values[i].getString().split(",")[0].equals(nodeVersionUUID); ++i) {
                    }
                    if (i == values.length || values[i].getString().split(",")[1].equals(NON_PUBLISHED)) {
                        log.info((Object)"Specified version not already published");
                        log.info((Object)"Set this version published");
                        String newStringValue2 = nodeVersionUUID + "," + PUBLISHED;
                        Value value2add3 = session.getValueFactory().createValue(newStringValue2);
                        if (i == values.length) {
                            values = this.addValueToArray(values, value2add3);
                        } else {
                            values[i] = value2add3;
                        }
                        node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                        log.info((Object)"Set the visibility");
                        Value newValueVisibility = session.getValueFactory().createValue(visibility);
                        node.setProperty(VISIBILITY, newValueVisibility);
                        log.info((Object)"Set permissions in function of visibility");
                        this.setVisibility(node, visibility);
                        node.setProperty(CURRENT_STATE, PUBLISHED);
                        log.info((Object)"Add log");
                        ExoContainer container = ExoContainerContext.getCurrentContainer();
                        PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                        String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                        String version = session.getNodeByUUID(nodeVersionUUID).getName();
                        String[] log = new String[]{date, newState, userid, "PublicationService.StaticAndDirectPublicationPlugin.nodePublished", version, visibility};
                        publicationService.addLog(node, log);
                        break block26;
                    }
                    throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : Node Version " + nodeVersionUUID + " is already published");
                }
                if (newState.equals(NON_PUBLISHED)) {
                    int i;
                    String currentState = node.getProperty(CURRENT_STATE).getString();
                    if (currentState.equals(NON_PUBLISHED)) {
                        log.info((Object)"node already unpublished");
                        String oldVisibility = node.getProperty(VISIBILITY).getString();
                        String newVisibility = context.get("visibility");
                        String nodeVersionUUID = context.get("nodeVersionUUID");
                        if (!oldVisibility.equals(newVisibility)) {
                            Value newValueVisibility = session.getValueFactory().createValue(newVisibility);
                            node.setProperty(VISIBILITY, newValueVisibility);
                            this.setVisibility(node, newVisibility);
                            ExoContainer container = ExoContainerContext.getCurrentContainer();
                            PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                            String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                            String version = session.getNodeByUUID(nodeVersionUUID).getName();
                            String[] log = new String[]{date, newState, userid, "PublicationService.StaticAndDirectPublicationPlugin.changeVisibility", newVisibility};
                            publicationService.addLog(node, log);
                        }
                        break block26;
                    }
                    if (!currentState.equals(PUBLISHED)) break block26;
                    log.info((Object)"Node published, unpublish it");
                    Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
                    for (i = 0; i < values.length && !values[i].getString().split(",")[1].equals(PUBLISHED); ++i) {
                    }
                    if (i != values.length) {
                        Value value2add;
                        String publishedVersionUUID = values[i].getString().split(",")[0];
                        log.info((Object)"Unpublished current published version");
                        String newStringValue = publishedVersionUUID + "," + NON_PUBLISHED;
                        values[i] = value2add = session.getValueFactory().createValue(newStringValue);
                        node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                        node.setProperty(CURRENT_STATE, NON_PUBLISHED);
                        String newVisibility = context.get("visibility");
                        Value newValueVisibility = session.getValueFactory().createValue(newVisibility);
                        node.setProperty(VISIBILITY, newValueVisibility);
                        this.setVisibility(node, newVisibility);
                        log.info((Object)"Add log");
                        ExoContainer container = ExoContainerContext.getCurrentContainer();
                        PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                        String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                        String[] log = new String[]{date, newState, userid, "PublicationService.StaticAndDirectPublicationPlugin.nodeUnpublished", newVisibility};
                        publicationService.addLog(node, log);
                        break block26;
                    }
                    throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : currentState is published but no version is published");
                }
                throw new IncorrectStateUpdateLifecycleException("Incorrect current State");
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                systemSession.save();
                systemSession.logout();
            }
        }
    }

    @Override
    public String[] getPossibleStates() {
        String[] result = new String[]{ENROLLED, NON_PUBLISHED, PUBLISHED};
        return result;
    }

    @Override
    public byte[] getStateImage(Node node, Locale locale) throws IOException, FileNotFoundException, Exception {
        byte[] bytes = null;
        String fileName = "staticAndDirect";
        String currentState = node.getProperty(CURRENT_STATE).getString();
        fileName = currentState.equals(PUBLISHED) ? fileName + "Published" : fileName + "Unpublished";
        String fileNameLocalized = fileName + "_" + locale.getLanguage();
        String completeFileName = IMG_PATH + fileNameLocalized + ".gif";
        log.trace((Object)("loading file '" + this.name + "' from file system '" + completeFileName + "'"));
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        if (in == null) {
            completeFileName = IMG_PATH + fileName + ".gif";
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StaticAndDirectPublicationPlugin.transfer(in, out);
        bytes = out.toByteArray();
        return bytes;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }

    @Override
    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        UIForm form;
        UINonPublishedForm uiform = null;
        if (node.getProperty(CURRENT_STATE).getString().equals(ENROLLED) || node.getProperty(CURRENT_STATE).getString().equals(NON_PUBLISHED)) {
            form = (UINonPublishedForm)component.createUIComponent(UINonPublishedForm.class, null, null);
            form.setNode(node);
            uiform = form;
        } else if (node.getProperty(CURRENT_STATE).getString().equals(PUBLISHED)) {
            form = (UIPublishedForm)component.createUIComponent(UIPublishedForm.class, null, null);
            form.setNode(node);
            uiform = form;
        } else {
            throw new Exception("StaticAndDirectPublicationPlugin.getStateUI : Unknown state : " + node.getProperty(CURRENT_STATE).getString());
        }
        UIStaticDirectVersionList uiVersionTreeList = (UIStaticDirectVersionList)uiform.findFirstComponentOfType(UIStaticDirectVersionList.class);
        UIPublicationForm uiPublicationForm = (UIPublicationForm)uiform.findFirstComponentOfType(UIPublicationForm.class);
        uiVersionTreeList.initVersion(node);
        uiPublicationForm.initForm(node);
        return uiform;
    }

    @Override
    public String getUserInfo(Node node, Locale locale) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.portlet.publication.PublicationService", locale, ((Object)((Object)this)).getClass().getClassLoader());
        Session session = node.getSession();
        if (node.getProperty(CURRENT_STATE).getString().equals(ENROLLED) || node.getProperty(CURRENT_STATE).getString().equals(NON_PUBLISHED)) {
            return resourceBundle.getString("PublicationService.StaticAndDirectPublicationPlugin.nodeNotPublished");
        }
        if (node.getProperty(CURRENT_STATE).getString().equals(PUBLISHED)) {
            int i;
            Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
            for (i = 0; i < values.length && !values[i].getString().split(",")[1].equals(PUBLISHED); ++i) {
            }
            if (i == values.length) {
                throw new Exception("StaticAndDirectPublicationPlugin.getUserInfo : currentState=published, but state published not present in history");
            }
            String[] currentHistory = values[i].getString().split(",");
            String uuid = currentHistory[0];
            Node versionNode = session.getNodeByUUID(uuid);
            String name = versionNode.getName();
            Node labelNode = versionNode.getParent().getNode("jcr:versionLabels");
            PropertyIterator propertyIterator = labelNode.getProperties();
            String label = "";
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                if (!property.getValue().getString().equals(uuid)) continue;
                label = property.getName();
            }
            String visibility = node.getProperty(VISIBILITY).getValue().getString();
            String result = "";
            if (label.equals("")) {
                String[] valuesLocale = new String[]{name};
                result = result + publicationService.getLocalizedAndSubstituteLog(locale, "PublicationService.StaticAndDirectPublicationPlugin.versionPublishedWithoutLabel", valuesLocale);
            } else {
                String[] valuesLocale = new String[]{name, label};
                result = result + publicationService.getLocalizedAndSubstituteLog(locale, "PublicationService.StaticAndDirectPublicationPlugin.versionPublishedWithLabel", valuesLocale);
            }
            result = visibility.equals(PUBLIC) ? result + resourceBundle.getString("PublicationService.StaticAndDirectPublicationPlugin.visibilityPublic") : result + resourceBundle.getString("PublicationService.StaticAndDirectPublicationPlugin.visibilityPrivate");
            session.logout();
            return result;
        }
        session.logout();
        throw new Exception("StaticAndDirectPublicationPlugin.getUserInfo : Unknown state : " + node.getProperty(CURRENT_STATE).getString());
    }

    public void setVisibility(Node node, String visibility) throws Exception {
        ExtendedNode extNode = (ExtendedNode)node;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        if (visibility.equals(PUBLIC)) {
            String[] arrayPermission = new String[]{"read"};
            extNode.setPermission(SystemIdentity.ANY, arrayPermission);
        } else {
            extNode.removePermission(SystemIdentity.ANY);
        }
    }

    @Override
    public boolean canAddMixin(Node node) throws Exception {
        return node.canAddMixin(MIXIN_TYPE);
    }

    @Override
    public void addMixin(Node node) throws Exception {
        node.addMixin(MIXIN_TYPE);
        node.setProperty(VISIBILITY, PRIVATE);
        ArrayList publicationStates = new ArrayList();
        node.setProperty(VERSIONS_PUBLICATION_STATES, publicationStates.toArray(new Value[publicationStates.size()]));
    }

    public Value[] addValueToArray(Value[] array, Value value2add) {
        Value[] newarray = new Value[array.length + 1];
        for (int i = 0; i < array.length; ++i) {
            newarray[i] = array[i];
        }
        newarray[array.length] = value2add;
        return newarray;
    }

    @Override
    public String getLocalizedAndSubstituteMessage(Locale locale, String key, String[] values) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.portlet.publication.PublicationService", locale, cl);
        String result = resourceBundle.getString(key);
        return String.format(result, values);
    }

    @Override
    public Node getNodeView(Node currentNode, Map<String, Object> context) throws Exception {
        String visibility = currentNode.getProperty(VISIBILITY).getString();
        if (visibility.equals(PRIVATE) && !this.canRead(currentNode)) {
            return null;
        }
        VersionNode rootVersion = new VersionNode(currentNode.getVersionHistory().getRootVersion());
        return this.getVerionNodePublish(rootVersion.getChildren(), currentNode);
    }

    private boolean canRead(Node node) throws RepositoryException {
        return this.checkPermission(node, "read");
    }

    private boolean checkPermission(Node node, String permissionType) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(permissionType);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private Node getVerionNodePublish(List<VersionNode> list, Node currentNode) throws Exception {
        for (VersionNode version : list) {
            Node node;
            String state = this.getStateByVersion(version, currentNode);
            if (state.equals(PUBLISHED)) {
                return version.getVersion().getNode("jcr:frozenNode");
            }
            if (version.getChildren().size() <= 0 || (node = this.getVerionNodePublish(version.getChildren(), currentNode)) == null) continue;
            return node;
        }
        return null;
    }

    private String getStateByVersion(VersionNode versionNode, Node currentNode_) throws Exception {
        Value[] publicationStates;
        for (Value value : publicationStates = currentNode_.getProperty(VERSIONS_PUBLICATION_STATES).getValues()) {
            String[] arrPublicationState = value.getString().split(",");
            for (int i = 0; i < arrPublicationState.length; ++i) {
                if (!arrPublicationState[0].equals(versionNode.getVersion().getUUID())) continue;
                return arrPublicationState[1];
            }
        }
        return DEFAULT_STATE;
    }
}

