/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import javax.jcr.Node;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostCreateContentEventListener
extends Listener<CmsService, Node> {
    private static final Log log = ExoLogger.getLogger(PostCreateContentEventListener.class);
    private WCMPublicationService publicationService;
    private WCMConfigurationService configurationService;
    private WebContentSchemaHandler webContentSchemaHandler;

    public PostCreateContentEventListener(WCMPublicationService publicationService, WCMConfigurationService configurationService, WebSchemaConfigService schemaConfigService) {
        this.publicationService = publicationService;
        this.configurationService = configurationService;
        this.webContentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
    }

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        Node currentNode = (Node)event.getData();
        if (currentNode.canAddMixin("exo:rss-enable")) {
            currentNode.addMixin("exo:rss-enable");
            if (!currentNode.hasProperty("exo:title")) {
                currentNode.setProperty("exo:title", currentNode.getName());
            }
        }
        if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile") || currentNode.getParent().isNodeType("exo:actionStorage")) {
            return;
        }
        String siteName = Util.getPortalRequestContext().getPortalOwner();
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        if (log.isInfoEnabled()) {
            log.info((Object)(currentNode.getPath() + "::" + siteName + "::" + remoteUser));
        }
        if (remoteUser != null) {
            this.publicationService.updateLifecyleOnChangeContent(currentNode, siteName, remoteUser);
        }
    }
}

