/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.ExceptionMapper;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.InternalException;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestDispatcher;
import org.exoplatform.services.rest.impl.RequestFilterComponentPlugin;
import org.exoplatform.services.rest.impl.ResponseFilterComponentPlugin;
import org.exoplatform.services.rest.impl.UnhandledException;
import org.exoplatform.services.rest.impl.method.MethodInvokerFilterComponentPlugin;
import org.exoplatform.services.rest.impl.provider.EntityProviderComponentPlugin;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.picocontainer.Startable;

public final class RequestHandlerImpl
implements RequestHandler,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)RequestHandlerImpl.class.getName());
    private static final Map<String, String> properties = new HashMap<String, String>();
    private final RequestDispatcher dispatcher;

    public static final String getProperty(String name) {
        return properties.get(name);
    }

    public static final void setProperty(String name, String value) {
        if (value == null) {
            properties.remove(name);
        }
        properties.put(name, value);
    }

    public RequestHandlerImpl(RequestDispatcher dispatcher, InitParams params) {
        if (params != null) {
            Iterator i = params.getValueParamIterator();
            while (i.hasNext()) {
                ValueParam vp = (ValueParam)i.next();
                properties.put(vp.getName(), vp.getValue());
            }
        }
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(GenericContainerRequest request, GenericContainerResponse response) throws Exception {
        try {
            Object f;
            ApplicationContextImpl context = new ApplicationContextImpl(request, response, ProviderBinder.getInstance());
            context.getProperties().putAll(properties);
            ApplicationContextImpl.setCurrent(context);
            for (ObjectFactory<FilterDescriptor> factory : ProviderBinder.getInstance().getRequestFilters(context.getPath())) {
                f = (RequestFilter)factory.getInstance(context);
                f.doFilter(request);
            }
            try {
                String jaxrsHeader;
                this.dispatcher.dispatch(request, response);
                if (response.getHttpHeaders().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(response.getStatus())) != null) {
                    response.getHttpHeaders().putSingle((Object)"JAXRS-Body-Provided", (Object)jaxrsHeader);
                }
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    String jaxrsHeader;
                    Response errorResponse = ((WebApplicationException)e).getResponse();
                    ExceptionMapper<WebApplicationException> excmap = ProviderBinder.getInstance().getExceptionMapper(WebApplicationException.class);
                    int errorStatus = errorResponse.getStatus();
                    if (errorStatus < 500) {
                        if (LOG.isDebugEnabled() && e.getCause() != null) {
                            LOG.warn((Object)"WebApplication exception occurs.", e.getCause());
                        }
                    } else if (e.getCause() != null) {
                        LOG.warn((Object)"WebApplication exception occurs.", e.getCause());
                    }
                    if (errorResponse.getEntity() == null) {
                        if (excmap != null) {
                            errorResponse = excmap.toResponse((Throwable)e);
                        } else if (e.getMessage() != null) {
                            errorResponse = this.createErrorResponse(errorStatus, e.getMessage());
                        }
                    } else if (errorResponse.getMetadata().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(errorStatus)) != null) {
                        errorResponse.getMetadata().putSingle((Object)"JAXRS-Body-Provided", (Object)jaxrsHeader);
                    }
                    response.setResponse(errorResponse);
                }
                if (e instanceof InternalException) {
                    Throwable cause = e.getCause();
                    Class<?> causeClazz = cause.getClass();
                    ExceptionMapper<?> excmap = ProviderBinder.getInstance().getExceptionMapper(causeClazz);
                    while (causeClazz != null && excmap == null) {
                        excmap = ProviderBinder.getInstance().getExceptionMapper(causeClazz);
                        if (excmap != null) continue;
                        causeClazz = causeClazz.getSuperclass();
                    }
                    if (excmap != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Object)"Internal error occurs.", cause);
                        }
                        response.setResponse(excmap.toResponse(e.getCause()));
                    }
                    LOG.error((Object)"Internal error occurs.", cause);
                    throw new UnhandledException(e.getCause());
                }
                throw new UnhandledException(e);
            }
            for (ObjectFactory<FilterDescriptor> factory : ProviderBinder.getInstance().getResponseFilters(context.getPath())) {
                f = (ResponseFilter)factory.getInstance(context);
                f.doFilter(response);
            }
            response.writeResponse();
        }
        finally {
            ApplicationContextImpl.setCurrent(null);
        }
    }

    private Response createErrorResponse(int status, String message) {
        Response.ResponseBuilder responseBuilder = Response.status((int)status);
        responseBuilder.entity((Object)message).type("text/plain");
        String jaxrsHeader = this.getJaxrsHeader(status);
        if (jaxrsHeader != null) {
            responseBuilder.header("JAXRS-Body-Provided", (Object)jaxrsHeader);
        }
        return responseBuilder.build();
    }

    private String getJaxrsHeader(int status) {
        if (status >= 400) {
            return "Error-Message";
        }
        return null;
    }

    public void start() {
        this.init();
    }

    public void stop() {
    }

    public void init() {
        File tmpDir;
        String tmpDirName = properties.get("ws.rs.tmpdir");
        if (tmpDirName == null) {
            tmpDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "ws_jaxrs");
            properties.put("ws.rs.tmpdir", tmpDir.getPath());
        } else {
            tmpDir = new File(tmpDirName);
        }
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                File[] files;
                for (File file : files = tmpDir.listFiles()) {
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        });
    }

    public void addPlugin(ComponentPlugin plugin) {
        block5: {
            ProviderBinder providers;
            block7: {
                block6: {
                    block4: {
                        providers = ProviderBinder.getInstance();
                        if (!MethodInvokerFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block4;
                        for (Class<? extends MethodInvokerFilter> filter : ((MethodInvokerFilterComponentPlugin)plugin).getFilters()) {
                            providers.addMethodInvokerFilter(filter);
                        }
                        break block5;
                    }
                    if (!EntityProviderComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block6;
                    Set<Class<? extends EntityProvider>> eps = ((EntityProviderComponentPlugin)plugin).getEntityProviders();
                    for (Class<? extends EntityProvider> ep : eps) {
                        providers.addMessageBodyReader(ep);
                        providers.addMessageBodyWriter(ep);
                    }
                    break block5;
                }
                if (!RequestFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block7;
                Set<Class<? extends RequestFilter>> filters = ((RequestFilterComponentPlugin)plugin).getFilters();
                for (Class<? extends RequestFilter> filter : filters) {
                    providers.addRequestFilter(filter);
                }
                break block5;
            }
            if (!ResponseFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block5;
            Set<Class<? extends ResponseFilter>> filters = ((ResponseFilterComponentPlugin)plugin).getFilters();
            for (Class<? extends ResponseFilter> filter : filters) {
                providers.addResponseFilter(filter);
            }
        }
    }

    static class ErrorStreaming
    implements StreamingOutput {
        private final Exception e;

        ErrorStreaming(Exception e) {
            this.e = e;
        }

        public void write(OutputStream output) {
            PrintWriter pw = new PrintWriter(output);
            this.e.printStackTrace(pw);
            pw.flush();
        }
    }
}

