/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.server.Invocation;

public class ModelMBeanOperationInterceptor
extends AbstractInterceptor
implements ModelMBeanConstants {
    private boolean trace;

    public ModelMBeanOperationInterceptor() {
        super("ModelMBean Operation Interceptor");
        this.trace = this.log.isTraceEnabled();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Descriptor d = invocation.getDescriptor();
        Class clazz = invocation.getReturnTypeClass();
        String name = null;
        ObjectName objectName = null;
        if (this.trace) {
            if (d != null) {
                name = (String)d.getFieldValue("name");
            }
            objectName = invocation.getInvoker().getObjectName();
        }
        if (this.trace) {
            Object args = invocation.getArgs();
            if (args != null) {
                args = Arrays.asList(args);
            }
            this.log.trace((Object)("Invoking objectName=" + objectName + " oper=" + name + " args=" + args + " desc=" + d));
        }
        long limit = -1L;
        if (d != null && clazz != null) {
            String timeStamp;
            String timeLimit = (String)d.getFieldValue("currencyTimeLimit");
            if (timeLimit != null) {
                limit = Long.parseLong(timeLimit);
            }
            if (limit == 0L && (timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp")) != null) {
                Object value = d.getFieldValue("value");
                if (this.trace) {
                    this.log.trace((Object)("Always cache objectName=" + objectName + " oper=" + name + " value=" + value));
                }
                this.checkAssignable("Cached value in descriptor ", clazz, value);
                return value;
            }
            if (limit != -1L) {
                long expires;
                timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
                long lastUpdate = timeStamp == null ? 0L : Long.parseLong(timeStamp);
                long now = System.currentTimeMillis();
                if (now < (expires = lastUpdate * 1000L + limit * 1000L)) {
                    Object value = d.getFieldValue("value");
                    if (this.trace) {
                        this.log.trace((Object)("Using cache objectName=" + objectName + " oper=" + name + " value=" + value + " now=" + now + " expires=" + expires));
                    }
                    this.checkAssignable("Cached value in descriptor ", clazz, value);
                    return value;
                }
                if (this.trace) {
                    this.log.trace((Object)("Cache expired objectName=" + objectName + " oper=" + name + " now=" + now + " expires=" + expires));
                }
                d.removeField("value");
            } else {
                if (this.trace) {
                    this.log.trace((Object)("Removing any cached value objectName=" + objectName + " oper=" + name + " descriptor=" + d));
                }
                d.removeField("value");
            }
        }
        Object value = invocation.invoke();
        if (this.trace) {
            this.log.trace((Object)("Got result objectName=" + objectName + " oper=" + name + " value=" + value));
        }
        if (d != null && limit != -1L) {
            String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
            if (this.trace) {
                this.log.trace((Object)("Cache result objectName=" + objectName + " oper=" + name + " value=" + value + " timestamp=" + timestamp));
            }
            d.setField("value", value);
            d.setField("lastUpdatedTimeStamp", timestamp);
        }
        return value;
    }

    protected void checkAssignable(String context, Class clazz, Object value) throws InvalidAttributeValueException, ClassNotFoundException {
        if (value != null && !clazz.isAssignableFrom(value.getClass())) {
            throw new InvalidAttributeValueException(context + " has class " + value.getClass() + " loaded from " + value.getClass().getClassLoader() + " that is not assignable to attribute class " + clazz + " loaded from " + clazz.getClassLoader());
        }
    }
}

