/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers.managed;

import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.server.profileservice.persistence.PersistenceFactory;
import org.jboss.system.server.profileservice.persistence.component.AbstractComponentMapper;
import org.jboss.system.server.profileservice.persistence.xml.PersistedComponent;

public class ServiceDeploymentComponentMapper
extends AbstractComponentMapper {
    private static final Logger log = Logger.getLogger(ServiceDeploymentComponentMapper.class);

    public ServiceDeploymentComponentMapper(PersistenceFactory persistenceFactory) {
        super(persistenceFactory);
    }

    protected void setComponentName(PersistedComponent component, ManagedObject mo) {
        ServiceMetaData md = (ServiceMetaData)mo.getAttachment();
        String name = md.getObjectName().getCanonicalName();
        component.setName(name);
    }

    protected ManagedObject getComponent(Object attachment, PersistedComponent component, boolean create) {
        ServiceDeployment deployment = (ServiceDeployment)attachment;
        ServiceMetaData service = null;
        List<ServiceMetaData> services = deployment.getServices();
        if (services == null) {
            services = new ArrayList<ServiceMetaData>();
            deployment.setServices(services);
        }
        if (services != null && !services.isEmpty()) {
            for (ServiceMetaData metaData : services) {
                if (!metaData.getObjectName().getCanonicalName().equals(component.getOriginalName())) continue;
                service = metaData;
                break;
            }
        }
        if (service == null && create) {
            service = this.createEmptyServiceMetaData(component);
            deployment.getServices().add(service);
        }
        if (service == null) {
            throw new IllegalStateException("could not find service with name " + component.getOriginalName());
        }
        return this.getMOF().initManagedObject((Object)service, null);
    }

    protected void removeComponent(Object attachment, PersistedComponent component) {
        ServiceDeployment deployment = (ServiceDeployment)attachment;
        List<ServiceMetaData> deploymentServices = deployment.getServices();
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        if (deploymentServices != null && !deploymentServices.isEmpty()) {
            for (ServiceMetaData metaData : deploymentServices) {
                if (metaData.getObjectName().getCanonicalName().equals(component.getOriginalName())) continue;
                services.add(metaData);
            }
        }
        deployment.setServices(services);
    }

    protected ServiceMetaData createEmptyServiceMetaData(PersistedComponent component) {
        ServiceMetaData service = new ServiceMetaData();
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(component.getOriginalName());
            service.setObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("failed to create object name for component " + component, e);
        }
        log.debug((Object)("created service " + component.getOriginalName()));
        return service;
    }

    public String getType() {
        return ServiceDeployment.class.getName();
    }
}

