/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MkColCommand {
    private static Log log = ExoLogger.getLogger(MkColCommand.class);
    private final NullResourceLocksHolder nullResourceLocks;

    public MkColCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
    }

    public Response mkCol(Session session, String path, String nodeType, List<String> mixinTypes, List<String> tokens) {
        try {
            this.nullResourceLocks.checkLock(session, path, tokens);
            Node node = session.getRootNode().addNode(TextUtil.relativizePath(path), nodeType);
            if (mixinTypes != null) {
                this.addMixins(node, mixinTypes);
            }
            session.save();
        }
        catch (ItemExistsException exc) {
            return Response.status((int)405).entity((Object)exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (AccessDeniedException exc) {
            return Response.status((int)403).entity((Object)exc.getMessage()).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
        return Response.status((int)201).build();
    }

    private void addMixins(Node node, List<String> mixinTypes) {
        for (int i = 0; i < mixinTypes.size(); ++i) {
            String curMixinType = mixinTypes.get(i);
            try {
                node.addMixin(curMixinType);
                continue;
            }
            catch (Exception exc) {
                log.error((Object)("Can't add mixin [" + curMixinType + "]"), (Throwable)exc);
            }
        }
    }
}

