/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.config.RMMessageRetransmissionConfig;
import org.jboss.ws.extensions.wsrm.transport.RMChannelResponse;
import org.jboss.ws.extensions.wsrm.transport.RMChannelTask;
import org.jboss.ws.extensions.wsrm.transport.RMMessage;
import org.jboss.ws.extensions.wsrm.transport.RMTransportHelper;

public final class RMSender {
    private static final Logger logger = Logger.getLogger(RMSender.class);
    private static RMSender instance = new RMSender();
    private static final ThreadFactory rmThreadPool = new RMThreadPoolFactory();
    private static final int maxCountOfThreads = 5;
    private static final ExecutorService rmTasksQueue = Executors.newFixedThreadPool(5, rmThreadPool);

    private RMSender() {
    }

    public static final RMSender getInstance() {
        return instance;
    }

    public final RMMessage send(RMMessage request) throws Throwable {
        RMMessageRetransmissionConfig qos = RMTransportHelper.getSequence(request).getRMConfig().getMessageRetransmission();
        if (qos == null) {
            throw new RMException("User must specify message retransmission configuration in JAX-WS WS-RM config");
        }
        int countOfAttempts = qos.getCountOfAttempts();
        int inactivityTimeout = qos.getMessageTimeout();
        int retransmissionInterval = qos.getRetransmissionInterval();
        RMChannelResponse result = null;
        long startTime = 0L;
        long endTime = 0L;
        int attemptNumber = 1;
        for (int i = 0; i < countOfAttempts; ++i) {
            logger.debug((Object)("Sending RM request - attempt no. " + attemptNumber++));
            Future<RMChannelResponse> futureResult = rmTasksQueue.submit(new RMChannelTask(request));
            try {
                startTime = System.currentTimeMillis();
                result = futureResult.get(inactivityTimeout, TimeUnit.SECONDS);
                if (result == null) continue;
                Throwable t = result.getFault();
                if (t == null) {
                    Map<String, Object> remotingCtx;
                    endTime = System.currentTimeMillis();
                    if (result.getResponse() != null && (remotingCtx = result.getResponse().getMetadata().getContext("remotingInvocationContext")) != null && Integer.valueOf(500).equals(remotingCtx.get("ResponseCode"))) {
                        logger.debug((Object)("Response message received in " + (endTime - startTime) + " miliseconds, but contains internal server code, going to resend the request message"));
                        continue;
                    }
                    logger.debug((Object)("Response message received in " + (endTime - startTime) + " miliseconds"));
                    break;
                }
                logger.warn((Object)result.getFault().getClass().getName(), result.getFault());
                try {
                    Thread.sleep(retransmissionInterval * 1000);
                }
                catch (InterruptedException ie) {
                    logger.warn((Object)ie.getMessage(), (Throwable)ie);
                }
                continue;
            }
            catch (TimeoutException te) {
                endTime = System.currentTimeMillis();
                logger.warn((Object)("Timeout - response message not received in " + (endTime - startTime) + " miliseconds"));
                try {
                    Thread.sleep(retransmissionInterval * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    logger.warn((Object)ie.getMessage(), (Throwable)ie);
                }
            }
        }
        if (result == null) {
            throw new RMException("Unable to deliver message with addressing id: " + RMTransportHelper.getAddressingMessageId(request) + ". Count of attempts to deliver the message was: " + countOfAttempts);
        }
        Throwable fault = result.getFault();
        if (fault != null) {
            throw new RMException("Unable to deliver message with addressing id: " + RMTransportHelper.getAddressingMessageId(request) + ". Count of attempts to deliver the message was: " + countOfAttempts, fault);
        }
        return result.getResponse();
    }

    private static final class RMThreadPoolFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix = "rm-pool-worker-thread-";

        private RMThreadPoolFactory() {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "rm-pool-worker-thread-" + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (5 != t.getPriority()) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

