/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.proxy.ProxyFactory;
import org.jboss.aop.proxy.ProxyMixin;
import org.jboss.aop.proxy.SecurityActions;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalledInterfaceProxy
implements Serializable {
    static final long serialVersionUID = -7939451715003985857L;
    private Class<?>[] interfaces;
    private ProxyMixin[] mixins;
    private InstanceAdvisor advisor;
    private GUID guid;

    protected MarshalledInterfaceProxy() {
    }

    public MarshalledInterfaceProxy(GUID guid, Class<?>[] intfs, ProxyMixin[] mixins, InstanceAdvisor advisor) {
        this.guid = guid;
        this.advisor = advisor;
        this.interfaces = intfs;
        this.mixins = mixins;
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            ClassLoader cl = null;
            if (this.advisor.getInstance() != null) {
                cl = SecurityActions.getClassLoader(this.advisor.getInstance().getClass());
            }
            if (cl == null) {
                cl = SecurityActions.getContextClassLoader();
            }
            return ProxyFactory.createInterfaceProxy(this.guid, cl, this.interfaces, this.mixins, this.advisor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

