/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ToStringUtils;

public class PrefixQuery
extends Query {
    private Term prefix;

    public PrefixQuery(Term prefix) {
        this.prefix = prefix;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery(true);
        TermEnum enumerator = reader.terms(this.prefix);
        try {
            Term term;
            String prefixText = this.prefix.text();
            String prefixField = this.prefix.field();
            while ((term = enumerator.term()) != null && term.text().startsWith(prefixText) && term.field() == prefixField) {
                TermQuery tq = new TermQuery(term);
                tq.setBoost(this.getBoost());
                query.add(tq, BooleanClause.Occur.SHOULD);
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
        }
        return query;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.prefix.field().equals(field)) {
            buffer.append(this.prefix.field());
            buffer.append(":");
        }
        buffer.append(this.prefix.text());
        buffer.append('*');
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrefixQuery)) {
            return false;
        }
        PrefixQuery other = (PrefixQuery)o;
        return this.getBoost() == other.getBoost() && this.prefix.equals(other.prefix);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.prefix.hashCode() ^ 0x6634D93C;
    }
}

