/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe.variableinstance;

import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.jcr.JcrService;
import org.jbpm.svc.Services;

public class JcrNodeInstance
extends VariableInstance {
    private static final long serialVersionUID = 1L;
    String repository = null;
    String workspace = null;
    String path = null;
    private static Log log = LogFactory.getLog((Class)JcrNodeInstance.class);

    public boolean isStorable(Object value) {
        if (value == null) {
            return true;
        }
        return Node.class.isAssignableFrom(value.getClass());
    }

    protected Object getObject() {
        Item item;
        if (this.path == null) {
            return null;
        }
        JcrService jcrService = this.findService();
        if (jcrService == null) {
            throw new JbpmException("couldn't find jBPM service for JCR repository '" + this.repository + "', workspace '" + this.workspace + "'");
        }
        Session session = jcrService.getSession();
        try {
            item = session.getItem(this.path);
        }
        catch (Exception e) {
            throw new JbpmException("can't fetch JCR node '" + this.path + "' from repository '" + this.repository + "', workspace '" + this.workspace + "'", e);
        }
        return item;
    }

    private JcrService findService() {
        String serviceName = null;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        Services services = jbpmContext.getServices();
        if (services.hasService("jcr")) {
            serviceName = "jcr";
        } else {
            Iterator serviceNames = services.getServiceFactories().keySet().iterator();
            while (serviceNames.hasNext()) {
                String candidate = (String)serviceNames.next();
                if (!candidate.startsWith(this.workspace)) continue;
                if (candidate.length() == this.workspace.length()) {
                    if (serviceName != null) continue;
                    serviceName = candidate;
                    continue;
                }
                if (!candidate.endsWith(this.workspace)) continue;
                serviceName = candidate;
            }
        }
        if (serviceName == null) {
            throw new JbpmException("couldn't find service for JCR repository '" + this.repository + "', workspace '" + this.workspace + "'");
        }
        return (JcrService)services.getService(serviceName);
    }

    protected void setObject(Object value) {
        Node node = (Node)value;
        if (value == null) {
            this.repository = null;
            this.workspace = null;
            this.path = null;
        } else {
            try {
                Session session = node.getSession();
                Repository repo = session.getRepository();
                Workspace wspace = session.getWorkspace();
                this.repository = repo.getDescriptor("jcr.repository.name");
                this.workspace = wspace.getName();
                this.path = node.getPath();
                log.debug((Object)("stored jcr node repository(" + this.repository + "), workspace(" + this.workspace + ") and path(" + this.path + ")"));
            }
            catch (RepositoryException e) {
                throw new JbpmException("problem storing JCR node '" + node + "' in the process variable '" + this.name + "'", e);
            }
        }
    }
}

