/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Promise;

public class TUNNELDeadLockTest
extends TestCase {
    private JChannel channel;
    private Promise promise;
    private int receivedCnt;
    private int msgCount = 20000;
    private int payloadSize = 32;
    private int mainTimeout = 60000;
    private GossipRouter router = null;

    public TUNNELDeadLockTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.promise = new Promise();
        this.router = new GossipRouter();
        this.router.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.channel = null;
        this.promise.reset();
        this.promise = null;
        this.router.stop();
    }

    public void testStress() throws Exception {
        String props = "tunnel.xml";
        this.channel = new JChannel(props);
        this.channel.connect("agroup");
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        if (TUNNELDeadLockTest.this.channel == null) {
                            return;
                        }
                        Object o = TUNNELDeadLockTest.this.channel.receive(10000L);
                        if (!(o instanceof Message)) continue;
                        TUNNELDeadLockTest.this.receivedCnt++;
                        if (TUNNELDeadLockTest.this.receivedCnt % 2000 == 0) {
                            System.out.println("-- received " + TUNNELDeadLockTest.this.receivedCnt);
                        }
                        if (TUNNELDeadLockTest.this.receivedCnt == TUNNELDeadLockTest.this.msgCount) break;
                    }
                    TUNNELDeadLockTest.this.promise.setResult(new Object());
                    return;
                }
                catch (TimeoutException e) {
                    System.err.println("Timeout receiving from the channel. " + TUNNELDeadLockTest.this.receivedCnt + " msgs received so far.");
                }
                catch (Exception e) {
                    System.err.println("Error receiving data");
                    e.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                try {
                    for (int i = 0; i < TUNNELDeadLockTest.this.msgCount; ++i) {
                        TUNNELDeadLockTest.this.channel.send(null, null, (Serializable)new byte[TUNNELDeadLockTest.this.payloadSize]);
                        if (i % 2000 != 0) continue;
                        System.out.println("-- sent " + i);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error sending data over ...");
                    e.printStackTrace();
                }
            }
        }).start();
        Object result = this.promise.getResult(this.mainTimeout);
        if (result == null) {
            String msg = "The channel has failed to send/receive " + this.msgCount + " messages " + "possibly because of the channel deadlock or too short " + "timeout (currently " + this.mainTimeout + " ms). " + this.receivedCnt + " messages received so far.";
            TUNNELDeadLockTest.fail((String)msg);
        }
        this.channel.close();
    }

    public static Test suite() {
        return new TestSuite(TUNNELDeadLockTest.class);
    }
}

