/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.JCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.organization.User;

public class UserByQueryJCRUserListAccess
extends JCRUserListAccess {
    private org.exoplatform.services.organization.Query query;

    public UserByQueryJCRUserListAccess(JCROrganizationServiceImpl service, org.exoplatform.services.organization.Query query) {
        super(service);
        this.query = query;
    }

    protected int getSize(Session session) throws Exception {
        try {
            int result = 0;
            String where = "jcr:path LIKE '%'";
            if (this.query.getEmail() != null) {
                where = where + " AND " + "exo:email LIKE '" + this.query.getEmail().replace('*', '%') + "'";
            }
            if (this.query.getFirstName() != null) {
                where = where + " AND " + "exo:firstName LIKE '" + this.query.getFirstName().replace('*', '%') + "'";
            }
            if (this.query.getLastName() != null) {
                where = where + " AND " + "exo:lastName LIKE '" + this.query.getLastName().replace('*', '%') + "'";
            }
            UserHandlerImpl uHandler = new UserHandlerImpl(this.service);
            String statement = "select * from exo:user " + (where.length() == 0 ? "" : "where " + where);
            Query uQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult uRes = uQuery.execute();
            NodeIterator results = uRes.getNodes();
            while (results.hasNext()) {
                Node uNode = results.nextNode();
                if (this.query.getUserName() != null && !this.isNameLike(uNode.getName(), this.query.getUserName())) continue;
                Date lastLoginTime = uHandler.readDateProperty(uNode, "exo:lastLoginTime");
                if (this.query.getFromLoginDate() != null && (lastLoginTime == null || this.query.getFromLoginDate().getTime() > lastLoginTime.getTime()) || this.query.getToLoginDate() != null && (lastLoginTime == null || this.query.getToLoginDate().getTime() < lastLoginTime.getTime())) continue;
                ++result;
            }
            return result;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not get list size", e);
        }
    }

    protected User[] load(Session session, int index, int length) throws Exception {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        try {
            User[] users = new User[length];
            String where = "jcr:path LIKE '%'";
            if (this.query.getEmail() != null) {
                where = where + " AND " + "exo:email LIKE '" + this.query.getEmail().replace('*', '%') + "'";
            }
            if (this.query.getFirstName() != null) {
                where = where + " AND " + "exo:firstName LIKE '" + this.query.getFirstName().replace('*', '%') + "'";
            }
            if (this.query.getLastName() != null) {
                where = where + " AND " + "exo:lastName LIKE '" + this.query.getLastName().replace('*', '%') + "'";
            }
            UserHandlerImpl uHandler = new UserHandlerImpl(this.service);
            String statement = "select * from exo:user " + (where.length() == 0 ? "" : "where " + where);
            Query uQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult uRes = uQuery.execute();
            NodeIterator results = uRes.getNodes();
            int p = 0;
            int counter = 0;
            while (counter < length) {
                if (!results.hasNext()) {
                    throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
                }
                Node uNode = results.nextNode();
                if (this.query.getUserName() != null && !this.isNameLike(uNode.getName(), this.query.getUserName())) continue;
                Date lastLoginTime = uHandler.readDateProperty(uNode, "exo:lastLoginTime");
                if (this.query.getFromLoginDate() != null && (lastLoginTime == null || this.query.getFromLoginDate().getTime() > lastLoginTime.getTime()) || this.query.getToLoginDate() != null && (lastLoginTime == null || this.query.getToLoginDate().getTime() < lastLoginTime.getTime()) || p++ < index) continue;
                users[counter++] = uHandler.readObjectFromNode(uNode);
            }
            return users;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not load users", e);
        }
    }

    private boolean isNameLike(String userName, String queryName) {
        boolean startWith = false;
        boolean endWith = false;
        if (queryName.startsWith("*")) {
            startWith = true;
            queryName = queryName.substring(1);
        }
        if (queryName.endsWith("*")) {
            endWith = true;
            queryName = queryName.substring(0, queryName.length() - 1);
        }
        if (startWith && endWith) {
            return userName.indexOf(queryName) != -1;
        }
        if (startWith) {
            return userName.startsWith(queryName);
        }
        if (endWith) {
            return userName.endsWith(queryName);
        }
        return userName.equals(queryName);
    }
}

