/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.commons.xml.ResourceEntityResolver;
import org.exoplatform.commons.xml.ValidationReporter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLValidator {
    private final String[] schemas;
    private final ResourceEntityResolver resolver;
    private final Logger log = LoggerFactory.getLogger(XMLValidator.class);

    public XMLValidator(Class clazz, String systemId, String resourcePath) {
        this.schemas = new String[]{systemId};
        this.resolver = new ResourceEntityResolver(clazz, systemId, resourcePath);
    }

    public String getSystemId() {
        return this.schemas[0];
    }

    public Document validate(DocumentSource source) throws NullPointerException, IOException {
        if (source == null) {
            throw new NullPointerException();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.schemas);
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ValidationReporter reporter = new ValidationReporter(this.log, source.getIdentifier());
            builder.setErrorHandler(reporter);
            builder.setEntityResolver(this.resolver);
            return builder.parse(source.getStream());
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)"Got a parser configuration exception when doing XSD validation");
            return null;
        }
        catch (SAXException e) {
            this.log.error((Object)"Got a sax exception when doing XSD validation");
            return null;
        }
    }
}

