/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.util.StringNumberParser;

public class SearchIndexConfigurationHelper {
    private final SearchIndex searchIndex;

    public SearchIndexConfigurationHelper(SearchIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    public void init(QueryHandlerEntry queryHandlerEntry) throws IOException, RepositoryConfigurationException {
        for (SimpleParameterEntry parameter : queryHandlerEntry.getParameters()) {
            this.setParam(parameter.getName(), parameter.getValue());
        }
    }

    private void setParam(String name, String value) {
        if ("auto-repair".equals(name)) {
            this.searchIndex.setAutoRepair(Boolean.parseBoolean(value));
        } else if ("buffer-size".equals(name)) {
            this.searchIndex.setBufferSize(StringNumberParser.parseInt(value));
        } else if ("cache-size".equals(name)) {
            this.searchIndex.setCacheSize(StringNumberParser.parseInt(value));
        } else if ("consistency-check-enabled".equals(name)) {
            this.searchIndex.setEnableConsistencyCheck(Boolean.parseBoolean(value));
        } else if ("document-order".equals(name)) {
            this.searchIndex.setRespectDocumentOrder(Boolean.parseBoolean(value));
        } else if ("excerptprovider-class".equals(name)) {
            this.searchIndex.setExcerptProviderClass(value);
        } else if ("extractor-backlog".equals(name)) {
            this.searchIndex.setExtractorBackLogSize(StringNumberParser.parseInt(value));
        } else if ("extractor-pool-size".equals(name)) {
            this.searchIndex.setExtractorPoolSize(StringNumberParser.parseInt(value));
        } else if ("extractor-timeout".equals(name)) {
            this.searchIndex.setExtractorTimeout(StringNumberParser.parseLong(value));
        } else if ("force-consistencycheck".equals(name)) {
            this.searchIndex.setForceConsistencyCheck(Boolean.parseBoolean(value));
        } else if ("errorlog-size".equals(name)) {
            this.searchIndex.setErrorLogfileSize(StringNumberParser.parseInt(value));
        } else if ("indexing-configuration-path".equals(name)) {
            this.searchIndex.setIndexingConfiguration(value);
        } else if ("indexing-configuration-class".equals(name)) {
            this.searchIndex.setIndexingConfigurationClass(value);
        } else if ("max-field-length".equals(name)) {
            this.searchIndex.setMaxFieldLength(StringNumberParser.parseInt(value));
        } else if ("max-merge-docs".equals(name)) {
            this.searchIndex.setMaxMergeDocs(StringNumberParser.parseInt(value));
        } else if ("merge-factor".equals(name)) {
            this.searchIndex.setMergeFactor(StringNumberParser.parseInt(value));
        } else if ("min-merge-docs".equals(name)) {
            this.searchIndex.setMinMergeDocs(StringNumberParser.parseInt(value));
        } else if ("query-class".equals(name)) {
            this.searchIndex.setQueryClass(value);
        } else if ("result-fetch-size".equals(name)) {
            this.searchIndex.setResultFetchSize(StringNumberParser.parseInt(value));
        } else if ("spellchecker-class".equals(name)) {
            this.searchIndex.setSpellCheckerClass(value);
        } else if ("support-highlighting".equals(name)) {
            this.searchIndex.setSupportHighlighting(Boolean.parseBoolean(value));
        } else if ("synonymprovider-class".equals(name)) {
            this.searchIndex.setSynonymProviderClass(value);
        } else if ("synonymprovider-config-path".equals(name)) {
            this.searchIndex.setSynonymProviderConfigPath(value);
        } else if ("use-compoundfile".equals(name)) {
            this.searchIndex.setUseCompoundFile(Boolean.parseBoolean(value));
        } else if ("volatile-idle-time".equals(name)) {
            this.searchIndex.setVolatileIdleTime(StringNumberParser.parseInt(value));
        } else if ("max-volatile-size".equals(name)) {
            this.searchIndex.setMaxVolatileIndexSize(StringNumberParser.parseInt(value));
        } else if ("max-volatile-time".equals(name)) {
            this.searchIndex.setMaxVolatileTime(StringNumberParser.parseInt(value));
        } else if ("analyzer".equals(name)) {
            this.searchIndex.setAnalyzer(value);
        }
    }
}

