/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class})})
public class UIPreferencesForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_ENABLESTRUCTURE = "enableStructure".intern();
    public static final String FIELD_SHOWSIDEBAR = "showSideBar".intern();
    public static final String FIELD_SHOWNONDOCUMENT = "showNonDocument".intern();
    public static final String FIELD_SHOWREFDOCUMENTS = "showRefDocuments".intern();
    public static final String FIELD_SHOW_HIDDEN_NODE = "showHiddenNode".intern();
    public static final String FIELD_SHOW_ITEMS_BY_USER = "showItemsByUserInTimeline".intern();
    public static final String FIELD_ENABLE_DRAG_AND_DROP = "enableDragAndDrop".intern();
    public static final String FIELD_SHORTBY = "sortBy".intern();
    public static final String FIELD_ORDERBY = "order".intern();
    public static final String FIELD_PROPERTY = "property".intern();
    public static final String NODES_PER_PAGE = "nodesPerPage".intern();
    public static final String FIELD_QUERY_TYPE = "queryType".intern();

    public UIPreferencesForm() throws Exception {
        String XPathQuery;
        String SQLQuery;
        String descendingOrder;
        String ascendingOrder;
        String sortByModifiedDate;
        String sortByCreatedDate;
        String sortByNodeType;
        String sortByNodeName;
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            sortByNodeName = res.getString("UIPreferencesForm.label.Alphabetic");
            sortByNodeType = res.getString("UIPreferencesForm.label.Type");
            sortByCreatedDate = res.getString("UIPreferencesForm.label.CreatedDate");
            sortByModifiedDate = res.getString("UIPreferencesForm.label.ModifiedDate");
            ascendingOrder = res.getString("UIPreferencesForm.label.Ascending");
            descendingOrder = res.getString("UIPreferencesForm.label.Descending");
            SQLQuery = res.getString("UIPreferencesForm.label.SQL");
            XPathQuery = res.getString("UIPreferencesForm.label.XPATH");
        }
        catch (Exception e) {
            sortByNodeName = "Alphabetic";
            sortByNodeType = "Type";
            sortByCreatedDate = "CreatedDate";
            sortByModifiedDate = "ModifiedDate";
            ascendingOrder = "Ascending";
            descendingOrder = "Descending";
            SQLQuery = "SQL";
            XPathQuery = "XPATH";
        }
        ArrayList<SelectItemOption> sortOptions = new ArrayList<SelectItemOption>();
        sortOptions.add(new SelectItemOption(sortByNodeName, (Object)"Alphabetic"));
        sortOptions.add(new SelectItemOption(sortByNodeType, (Object)"Type"));
        sortOptions.add(new SelectItemOption(sortByCreatedDate, (Object)"CreatedDate"));
        sortOptions.add(new SelectItemOption(sortByModifiedDate, (Object)"ModifiedDate"));
        ArrayList<SelectItemOption> orderOption = new ArrayList<SelectItemOption>();
        orderOption.add(new SelectItemOption(ascendingOrder, (Object)"Ascending"));
        orderOption.add(new SelectItemOption(descendingOrder, (Object)"Descending"));
        ArrayList<SelectItemOption> nodesPerPagesOptions = new ArrayList<SelectItemOption>();
        nodesPerPagesOptions.add(new SelectItemOption("5", (Object)"5"));
        nodesPerPagesOptions.add(new SelectItemOption("10", (Object)"10"));
        nodesPerPagesOptions.add(new SelectItemOption("15", (Object)"15"));
        nodesPerPagesOptions.add(new SelectItemOption("20", (Object)"20"));
        nodesPerPagesOptions.add(new SelectItemOption("30", (Object)"30"));
        nodesPerPagesOptions.add(new SelectItemOption("40", (Object)"40"));
        nodesPerPagesOptions.add(new SelectItemOption("50", (Object)"50"));
        ArrayList<SelectItemOption> queryOption = new ArrayList<SelectItemOption>();
        queryOption.add(new SelectItemOption(SQLQuery, (Object)"SQL"));
        queryOption.add(new SelectItemOption(XPathQuery, (Object)"XPATH"));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ENABLESTRUCTURE, FIELD_ENABLESTRUCTURE, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOWSIDEBAR, FIELD_SHOWSIDEBAR, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOWNONDOCUMENT, FIELD_SHOWNONDOCUMENT, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOWREFDOCUMENTS, FIELD_SHOWREFDOCUMENTS, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOW_HIDDEN_NODE, FIELD_SHOW_HIDDEN_NODE, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOW_ITEMS_BY_USER, FIELD_SHOW_ITEMS_BY_USER, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ENABLE_DRAG_AND_DROP, FIELD_ENABLE_DRAG_AND_DROP, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_QUERY_TYPE, FIELD_QUERY_TYPE, queryOption));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_SHORTBY, FIELD_SHORTBY, sortOptions));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_ORDERBY, FIELD_ORDERBY, orderOption));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NODES_PER_PAGE, NODES_PER_PAGE, nodesPerPagesOptions));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void update(Preference pref) {
        this.getUIFormCheckBoxInput(FIELD_ENABLESTRUCTURE).setChecked(pref.isJcrEnable());
        this.getUIFormCheckBoxInput(FIELD_SHOWSIDEBAR).setChecked(pref.isShowSideBar());
        this.getUIFormCheckBoxInput(FIELD_SHOWNONDOCUMENT).setChecked(pref.isShowNonDocumentType());
        this.getUIFormCheckBoxInput(FIELD_SHOWREFDOCUMENTS).setChecked(pref.isShowPreferenceDocuments());
        this.getUIFormCheckBoxInput(FIELD_SHOW_HIDDEN_NODE).setChecked(pref.isShowHiddenNode());
        this.getUIFormCheckBoxInput(FIELD_SHOW_ITEMS_BY_USER).setChecked(pref.isShowItemsByUser());
        this.getUIFormCheckBoxInput(FIELD_ENABLE_DRAG_AND_DROP).setChecked(pref.isEnableDragAndDrop());
        this.getUIFormSelectBox(FIELD_SHORTBY).setValue(pref.getSortType());
        this.getUIFormSelectBox(FIELD_ORDERBY).setValue(pref.getOrder());
        this.getUIFormSelectBox(NODES_PER_PAGE).setValue(Integer.toString(pref.getNodesPerPage()));
        this.getUIFormSelectBox(FIELD_QUERY_TYPE).setValue(pref.getQueryType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPreferencesForm> {
        public void execute(Event<UIPreferencesForm> event) throws Exception {
            UIPreferencesForm uiForm = (UIPreferencesForm)((Object)event.getSource());
            UIJCRExplorerPortlet explorerPorltet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            ((UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class)).cancelPopupAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPreferencesForm> {
        public void execute(Event<UIPreferencesForm> event) throws Exception {
            UIPreferencesForm uiForm = (UIPreferencesForm)((Object)event.getSource());
            UIJCRExplorerPortlet explorerPorltet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            Preference pref = uiExplorer.getPreference();
            pref.setJcrEnable(uiForm.getUIFormCheckBoxInput(FIELD_ENABLESTRUCTURE).isChecked());
            pref.setShowSideBar(uiForm.getUIFormCheckBoxInput(FIELD_SHOWSIDEBAR).isChecked());
            pref.setShowNonDocumentType(uiForm.getUIFormCheckBoxInput(FIELD_SHOWNONDOCUMENT).isChecked());
            pref.setShowPreferenceDocuments(uiForm.getUIFormCheckBoxInput(FIELD_SHOWREFDOCUMENTS).isChecked());
            pref.setShowHiddenNode(uiForm.getUIFormCheckBoxInput(FIELD_SHOW_HIDDEN_NODE).isChecked());
            pref.setShowItemsByUser(uiForm.getUIFormCheckBoxInput(FIELD_SHOW_ITEMS_BY_USER).isChecked());
            pref.setEnableDragAndDrop(uiForm.getUIFormCheckBoxInput(FIELD_ENABLE_DRAG_AND_DROP).isChecked());
            pref.setSortType((String)uiForm.getUIFormSelectBox(FIELD_SHORTBY).getValue());
            pref.setQueryType((String)uiForm.getUIFormSelectBox(FIELD_QUERY_TYPE).getValue());
            pref.setOrder((String)uiForm.getUIFormSelectBox(FIELD_ORDERBY).getValue());
            pref.setNodesPerPage(Integer.parseInt((String)uiForm.getUIFormSelectBox(NODES_PER_PAGE).getValue()));
            uiExplorer.refreshExplorer();
            explorerPorltet.setRenderedChild(UIJCRExplorer.class);
        }
    }
}

