/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageManager;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadContainer;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadContent;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadManager;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadManager;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormMultiValueInputSet.class, id="UploadMultipleInputset", events={@EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE)})})
public class UISingleUploadForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.upload.UISingleUploadForm");
    public static final String FIELD_NAME = "name";
    public static final String FIELD_UPLOAD = "upload";
    public static final String JCRCONTENT = "jcr:content";
    public static final String FIELD_TAXONOMY = "fieldTaxonomy";
    public static final String FIELD_LISTTAXONOMY = "fieldListTaxonomy";
    public static final String POPUP_TAXONOMY = "UIPopupTaxonomy";
    private boolean isMultiLanguage_;
    private String language_;
    private boolean isDefault_;
    private List<String> listTaxonomy = new ArrayList<String>();
    private List<String> listTaxonomyName = new ArrayList<String>();

    public UISingleUploadForm() throws Exception {
        this.setMultiPart(true);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String limitPref = portletPref.getValue("uploadFileSizeLimitMB", "");
        UIFormUploadInput uiInput = null;
        if (limitPref != null) {
            try {
                uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD, Integer.parseInt(limitPref.trim()));
            }
            catch (NumberFormatException e) {
                uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD);
            }
        } else {
            uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD);
        }
        uiInput.setAutoUpload(true);
        this.addUIFormInput((UIFormInput)uiInput);
    }

    public List<String> getListTaxonomy() {
        return this.listTaxonomy;
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomy(List<String> listTaxonomyNew) {
        this.listTaxonomy = listTaxonomyNew;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public String getPathTaxonomy() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String repository = uiExplorer.getRepositoryName();
        DMSConfiguration dmsConfig = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfig.getConfig(repository);
        String workspaceName = dmsRepoConfig.getSystemWorkspace();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        Session session = uiExplorer.getSessionByWorkspace(workspaceName);
        return ((Node)session.getItem(nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath"))).getPath();
    }

    public void initFieldInput() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String categoryMandatoryWhenFileUpload = portletPref.getValue("categoryMandatoryWhenFileUpload", "").trim();
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, "UploadMultipleInputset", null);
        uiFormMultiValue.setId(FIELD_LISTTAXONOMY);
        uiFormMultiValue.setName(FIELD_LISTTAXONOMY);
        uiFormMultiValue.setType(UIFormStringInput.class);
        uiFormMultiValue.setEditable(false);
        if (categoryMandatoryWhenFileUpload.equalsIgnoreCase("true")) {
            uiFormMultiValue.addValidator(MandatoryValidator.class, new Object[0]);
        }
        uiFormMultiValue.setValue(this.listTaxonomyName);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void setIsMultiLanguage(boolean isMultiLanguage, String language) {
        this.isMultiLanguage_ = isMultiLanguage;
        this.language_ = language;
    }

    public void resetComponent() {
        this.removeChildById(FIELD_UPLOAD);
        this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD));
    }

    public boolean isMultiLanguage() {
        return this.isMultiLanguage_;
    }

    public void setIsDefaultLanguage(boolean isDefault) {
        this.isDefault_ = isDefault;
    }

    private String getLanguageSelected() {
        return this.language_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String valueTaxonomy = String.valueOf(value).trim();
        if (!this.listTaxonomy.contains(valueTaxonomy)) {
            this.listTaxonomy.add(valueTaxonomy);
            this.listTaxonomyName.add(valueTaxonomy);
        }
        this.updateAdvanceTaxonomy();
        UIUploadManager uiUploadManager = (UIUploadManager)this.getParent();
        uiUploadManager.removeChildById(POPUP_TAXONOMY);
    }

    private void updateAdvanceTaxonomy() throws Exception {
        UIFormMultiValueInputSet uiFormMultiValueInputSet = (UIFormMultiValueInputSet)this.getChild(UIFormMultiValueInputSet.class);
        uiFormMultiValueInputSet.setValue(this.listTaxonomyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            UISingleUploadForm uiUploadForm = (UISingleUploadForm)uiSet.getParent();
            UIApplication uiApp = (UIApplication)uiUploadForm.getAncestorOfType(UIApplication.class);
            try {
                UIFormUploadInput uiFormUploadInput = (UIFormUploadInput)uiUploadForm.getChildById(UISingleUploadForm.FIELD_UPLOAD);
                UploadResource uploadResource = uiFormUploadInput.getUploadResource();
                if (uploadResource == null) {
                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.upload-not-null", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                UISingleUploadManager uiUploadManager = (UISingleUploadManager)uiUploadForm.getParent();
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiUploadForm.getAncestorOfType(UIJCRExplorer.class);
                NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiUploadForm.getApplicationComponent(NodeHierarchyCreator.class);
                String repository = uiExplorer.getRepositoryName();
                DMSConfiguration dmsConfig = (DMSConfiguration)uiUploadForm.getApplicationComponent(DMSConfiguration.class);
                DMSRepositoryConfiguration dmsRepoConfig = dmsConfig.getConfig(repository);
                String workspaceName = dmsRepoConfig.getSystemWorkspace();
                UIPopupWindow uiPopupWindow = uiUploadManager.initPopupTaxonomy(UISingleUploadForm.POPUP_TAXONOMY);
                UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiUploadManager.createUIComponent(UIOneTaxonomySelector.class, null, null);
                uiPopupWindow.setUIComponent((UIComponent)uiOneTaxonomySelector);
                uiOneTaxonomySelector.setIsDisable(workspaceName, false);
                String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
                Session session = ((UIJCRExplorer)uiUploadForm.getAncestorOfType(UIJCRExplorer.class)).getSessionByWorkspace(workspaceName);
                Node rootTree = (Node)session.getItem(rootTreePath);
                NodeIterator childrenIterator = rootTree.getNodes();
                if (childrenIterator.hasNext()) {
                    Node childNode = childrenIterator.nextNode();
                    rootTreePath = childNode.getPath();
                }
                uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, rootTreePath);
                uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                uiOneTaxonomySelector.init(uiExplorer.getSystemProvider());
                String param = "returnField=fieldTaxonomy";
                uiOneTaxonomySelector.setSourceComponent((UIComponent)uiUploadForm, new String[]{param});
                uiPopupWindow.setRendered(true);
                uiPopupWindow.setShow(true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadManager);
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("Taxonomy.msg.AccessDeniedException", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("Taxonomy.msg.AccessDeniedException", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            UIComponent uiComponent = uiSet.getParent();
            if (uiComponent instanceof UISingleUploadForm) {
                UISingleUploadForm uiUploadForm = (UISingleUploadForm)uiComponent;
                String id = event.getRequestContext().getRequestParameter("objectId");
                UIFormStringInput uiFormStringInput = (UIFormStringInput)uiSet.getChildById(id);
                String value = ((String)uiFormStringInput.getValue()).trim();
                if (uiUploadForm.getlistTaxonomyName().contains(value)) {
                    int indexRemove = uiUploadForm.getlistTaxonomyName().indexOf(value);
                    uiUploadForm.getlistTaxonomyName().remove(indexRemove);
                    uiUploadForm.getListTaxonomy().remove(indexRemove);
                }
                uiSet.removeChildById(id);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadForm);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISingleUploadForm> {
        public void execute(Event<UISingleUploadForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UISingleUploadForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISingleUploadForm> {
        public void execute(Event<UISingleUploadForm> event) throws Exception {
            PortletRequestContext pcontext;
            PortletPreferences portletPref;
            String categoryMandatoryWhenFileUpload;
            String lockToken;
            UISingleUploadForm uiForm = (UISingleUploadForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            String repository = uiExplorer.getRepositoryName();
            UIFormUploadInput input = (UIFormUploadInput)uiForm.getUIInput(UISingleUploadForm.FIELD_UPLOAD);
            CmsService cmsService = (CmsService)uiForm.getApplicationComponent(CmsService.class);
            TaxonomyService taxonomyService = (TaxonomyService)uiForm.getApplicationComponent(TaxonomyService.class);
            if (input.getUploadResource() == null) {
                uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiExplorer.getCurrentNode().isLocked() && (lockToken = LockUtil.getLockToken((Node)uiExplorer.getCurrentNode())) != null) {
                uiExplorer.getSession().addLockToken(lockToken);
            }
            if ((categoryMandatoryWhenFileUpload = (portletPref = (pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences()).getValue("categoryMandatoryWhenFileUpload", "").trim()).equalsIgnoreCase("true") && uiForm.getListTaxonomy().size() == 0 && !uiExplorer.getCurrentNode().hasNode(UISingleUploadForm.JCRCONTENT)) {
                uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.taxonomyPath-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String fileName = input.getUploadResource().getFileName();
            MultiLanguageService multiLangService = (MultiLanguageService)uiForm.getApplicationComponent(MultiLanguageService.class);
            if (fileName == null || fileName.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-error", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            BufferedInputStream inputStream = new BufferedInputStream(input.getUploadDataAsStream());
            String name = (String)uiForm.getUIStringInput(UISingleUploadForm.FIELD_NAME).getValue();
            name = name == null ? fileName : name.trim();
            name = Text.escapeIllegalJcrChars((String)name);
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)uiForm.getChild(UIFormMultiValueInputSet.class);
            ArrayList<String> listTaxonomyNew = new ArrayList<String>();
            ArrayList<String> listTaxonomyNameNew = new ArrayList<String>();
            if (uiSet != null) {
                List listChildren = uiSet.getChildren();
                for (UIComponent component : listChildren) {
                    UIFormStringInput uiStringInput = (UIFormStringInput)component;
                    if (uiStringInput.getValue() == null) continue;
                    String value = ((String)uiStringInput.getValue()).trim();
                    listTaxonomyNameNew.add(value);
                }
                uiForm.setListTaxonomy(listTaxonomyNew);
                uiForm.setListTaxonomyName(listTaxonomyNameNew);
                uiSet.setValue(uiForm.getListTaxonomy());
            }
            String taxonomyTree = null;
            String taxonomyPath = null;
            for (String categoryPath : listTaxonomyNameNew) {
                try {
                    if (categoryPath.startsWith("/")) {
                        categoryPath = categoryPath.substring(1);
                    }
                    taxonomyTree = categoryPath.substring(0, categoryPath.indexOf("/"));
                    taxonomyPath = categoryPath.substring(categoryPath.indexOf("/") + 1);
                    taxonomyService.getTaxonomyTree(repository, taxonomyTree).hasNode(taxonomyPath);
                }
                catch (ItemNotFoundException e) {
                    uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                catch (RepositoryException re) {
                    uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                    uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
            String mimeType = mimeTypeSolver.getMimeType(fileName);
            Node selectedNode = uiExplorer.getCurrentNode();
            boolean isExist = selectedNode.hasNode(name);
            String newNodeUUID = null;
            try {
                String pers = "add_node,set_property";
                selectedNode.getSession().checkPermission(selectedNode.getPath(), pers);
                if (uiForm.isMultiLanguage()) {
                    ValueFactoryImpl valueFactory = (ValueFactoryImpl)uiExplorer.getSession().getValueFactory();
                    Value contentValue = valueFactory.createValue((InputStream)inputStream);
                    multiLangService.addFileLanguage(selectedNode, name, contentValue, mimeType, uiForm.getLanguageSelected(), uiExplorer.getRepositoryName(), uiForm.isDefault_);
                    uiExplorer.setIsHidePopup(true);
                    UIMultiLanguageManager uiManager = (UIMultiLanguageManager)uiForm.getAncestorOfType(UIMultiLanguageManager.class);
                    UIMultiLanguageForm uiMultiForm = (UIMultiLanguageForm)uiManager.getChild(UIMultiLanguageForm.class);
                    uiMultiForm.doSelect(uiExplorer.getCurrentNode());
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
                } else if (!isExist) {
                    HashMap<String, JcrInputProperty> inputProperties = new HashMap<String, JcrInputProperty>();
                    JcrInputProperty nodeInput = new JcrInputProperty();
                    nodeInput.setJcrPath("/node");
                    nodeInput.setValue((Object)name);
                    nodeInput.setMixintype("mix:i18n,mix:votable,mix:commentable");
                    nodeInput.setType(1);
                    inputProperties.put("/node", nodeInput);
                    JcrInputProperty jcrContent = new JcrInputProperty();
                    jcrContent.setJcrPath("/node/jcr:content");
                    jcrContent.setValue((Object)"");
                    jcrContent.setMixintype("dc:elementSet");
                    jcrContent.setNodetype("nt:resource");
                    jcrContent.setType(1);
                    inputProperties.put("/node/jcr:content", jcrContent);
                    JcrInputProperty jcrData = new JcrInputProperty();
                    jcrData.setJcrPath("/node/jcr:content/jcr:data");
                    jcrData.setValue((Object)inputStream);
                    inputProperties.put("/node/jcr:content/jcr:data", jcrData);
                    JcrInputProperty jcrMimeType = new JcrInputProperty();
                    jcrMimeType.setJcrPath("/node/jcr:content/jcr:mimeType");
                    jcrMimeType.setValue((Object)mimeType);
                    inputProperties.put("/node/jcr:content/jcr:mimeType", jcrMimeType);
                    JcrInputProperty jcrLastModified = new JcrInputProperty();
                    jcrLastModified.setJcrPath("/node/jcr:content/jcr:lastModified");
                    jcrLastModified.setValue((Object)new GregorianCalendar());
                    inputProperties.put("/node/jcr:content/jcr:lastModified", jcrLastModified);
                    JcrInputProperty jcrEncoding = new JcrInputProperty();
                    jcrEncoding.setJcrPath("/node/jcr:content/jcr:encoding");
                    jcrEncoding.setValue((Object)"UTF-8");
                    inputProperties.put("/node/jcr:content/jcr:encoding", jcrEncoding);
                    newNodeUUID = cmsService.storeNodeByUUID("nt:file", selectedNode, inputProperties, true, repository);
                    selectedNode.save();
                    selectedNode.getSession().save();
                    if (listTaxonomyNameNew.size() > 0) {
                        Node newNode = null;
                        try {
                            newNode = selectedNode.getSession().getNodeByUUID(newNodeUUID);
                        }
                        catch (ItemNotFoundException e) {
                            newNode = Utils.findNodeByUUID((String)repository, (String)newNodeUUID);
                        }
                        if (newNode != null) {
                            for (String categoryPath : listTaxonomyNameNew) {
                                try {
                                    if (categoryPath.startsWith("/")) {
                                        categoryPath = categoryPath.substring(1);
                                    }
                                    taxonomyTree = categoryPath.substring(0, categoryPath.indexOf("/"));
                                    taxonomyPath = categoryPath.substring(categoryPath.indexOf("/") + 1);
                                    taxonomyService.addCategory(newNode, taxonomyTree, taxonomyPath);
                                }
                                catch (ItemExistsException e) {
                                    uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.ItemExistsException", null, 1));
                                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                                    return;
                                }
                                catch (RepositoryException e) {
                                    LOG.error((Object)"Unexpected error", (Throwable)e);
                                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                                    return;
                                }
                            }
                        }
                    }
                } else {
                    Node node = selectedNode.getNode(name);
                    if (!node.getPrimaryNodeType().isNodeType("nt:file")) {
                        Object[] args = new Object[]{name};
                        uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.name-is-exist", args, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    Node contentNode = node.getNode(UISingleUploadForm.JCRCONTENT);
                    if (node.isNodeType("mix:versionable")) {
                        if (!node.isCheckedOut()) {
                            node.checkout();
                        }
                        contentNode.setProperty("jcr:data", (InputStream)inputStream);
                        contentNode.setProperty("jcr:mimeType", mimeType);
                        contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                        node.save();
                        node.checkin();
                        node.checkout();
                    } else {
                        contentNode.setProperty("jcr:data", (InputStream)inputStream);
                    }
                    if (node.isNodeType("exo:datetime")) {
                        node.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
                    }
                    node.save();
                    for (String categoryPath : listTaxonomyNameNew) {
                        if (categoryPath.startsWith("/")) {
                            categoryPath = categoryPath.substring(1);
                        }
                        taxonomyTree = categoryPath.substring(0, categoryPath.indexOf("/"));
                        taxonomyPath = categoryPath.substring(categoryPath.indexOf("/") + 1);
                        taxonomyService.addCategory(node, taxonomyTree, taxonomyPath);
                    }
                }
                uiExplorer.getSession().save();
                UISingleUploadManager uiManager = (UISingleUploadManager)uiForm.getParent();
                UISingleUploadContainer uiUploadContainer = (UISingleUploadContainer)uiManager.getChild(UISingleUploadContainer.class);
                UploadService uploadService = (UploadService)uiForm.getApplicationComponent(UploadService.class);
                UIFormUploadInput uiChild = (UIFormUploadInput)uiForm.getChild(UIFormUploadInput.class);
                if (uiForm.isMultiLanguage_) {
                    uiUploadContainer.setUploadedNode(selectedNode);
                } else {
                    Node newNode = null;
                    if (!isExist) {
                        try {
                            newNode = selectedNode.getSession().getNodeByUUID(newNodeUUID);
                        }
                        catch (ItemNotFoundException e) {
                            newNode = Utils.findNodeByUUID((String)repository, newNodeUUID);
                        }
                    } else {
                        newNode = selectedNode.getNode(name);
                    }
                    if (newNode != null) {
                        uiUploadContainer.setUploadedNode(newNode);
                    }
                }
                UISingleUploadContent uiUploadContent = (UISingleUploadContent)uiManager.findFirstComponentOfType(UISingleUploadContent.class);
                double size = uploadService.getUploadResource(input.getUploadId()).getEstimatedSize();
                String fileSize = Utils.calculateFileSize((double)size);
                String[] arrValues = new String[]{Text.unescapeIllegalJcrChars((String)fileName), Text.unescapeIllegalJcrChars((String)name), fileSize, mimeType};
                uiUploadContent.setUploadValues(arrValues);
                ((InputStream)inputStream).close();
                uploadService.removeUpload(uiChild.getUploadId());
                uiManager.setRenderedChild(UISingleUploadContainer.class);
                uiExplorer.setIsHidePopup(true);
                uiExplorer.updateAjax(event);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            }
            catch (ConstraintViolationException con) {
                Object[] args = new Object[]{name};
                throw new MessageException(new ApplicationMessage("UIUploadForm.msg.contraint-violation", args, 1));
            }
            catch (LockException lock) {
                throw new MessageException(new ApplicationMessage("UIUploadForm.msg.lock-exception", null, 1));
            }
            catch (AccessDeniedException ade) {
                throw new MessageException(new ApplicationMessage("UIActionBar.msg.access-add-denied", null, 1));
            }
            catch (AccessControlException ace) {
                throw new MessageException(new ApplicationMessage("UIActionBar.msg.access-add-denied", null, 1));
            }
            catch (Exception e) {
                LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }
}

