/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.filters.ASCII85Decode;
import org.icepdf.core.pobjects.filters.ASCIIHexDecode;
import org.icepdf.core.pobjects.filters.CCITTFax;
import org.icepdf.core.pobjects.filters.FlateDecode;
import org.icepdf.core.pobjects.filters.LZWDecode;
import org.icepdf.core.pobjects.filters.RunLengthDecode;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.tag.Tagger;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.ImageCache;
import org.icepdf.core.util.Library;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.JBIG2Exception;

public class Stream
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Stream.class.toString());
    private SeekableInputConstrainedWrapper streamInput;
    private ImageCache image = null;
    private final Object imageLock = new Object();
    private boolean isCCITTFaxDecodeWithoutEncodedByteAlign = false;
    private int CCITTFaxDecodeColumnWidthMismatch = 0;
    private Reference pObjectReference = null;
    private boolean inlineImage;
    private static boolean scaleImages = Defs.sysPropertyBoolean("org.icepdf.core.scaleImages", true);
    private static final int[] GRAY_1_BIT_INDEX_TO_RGB_REVERSED = new int[]{-1, -16777216};
    private static final int[] GRAY_1_BIT_INDEX_TO_RGB = new int[]{-16777216, -1};
    private static final int[] GRAY_2_BIT_INDEX_TO_RGB = new int[]{-16777216, -11184811, -5592406, -1};
    private static final int[] GRAY_4_BIT_INDEX_TO_RGB = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
    private static final int JPEG_ENC_UNKNOWN_PROBABLY_YCbCr = 0;
    private static final int JPEG_ENC_RGB = 1;
    private static final int JPEG_ENC_CMYK = 2;
    private static final int JPEG_ENC_YCbCr = 3;
    private static final int JPEG_ENC_YCCK = 4;
    private static final int JPEG_ENC_GRAY = 5;
    private static String[] JPEG_ENC_NAMES = new String[]{"JPEG_ENC_UNKNOWN_PROBABLY_YCbCr", "JPEG_ENC_RGB", "JPEG_ENC_CMYK", "JPEG_ENC_YCbCr", "JPEG_ENC_YCCK", "JPEG_ENC_GRAY"};

    public Stream(Library l, Hashtable h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h);
        this.streamInput = streamInputWrapper;
    }

    public void setPObjectReference(Reference reference) {
        this.pObjectReference = reference;
    }

    public Reference getPObjectReference() {
        return this.pObjectReference;
    }

    public void setInlineImage(boolean inlineImage) {
        this.inlineImage = inlineImage;
    }

    public boolean isInlineImage() {
        return this.inlineImage;
    }

    boolean isImageSubtype() {
        Object subtype = this.library.getObject(this.entries, "Subtype");
        return subtype != null && subtype.equals("Image");
    }

    private boolean checkMemory(int memoryNeeded) {
        return this.library.memoryManager.checkMemory(memoryNeeded);
    }

    public InputStream getInputStreamForDecodedStreamBytes() {
        Vector filterNames;
        if (this.streamInput == null || this.streamInput.getLength() < 1L) {
            return null;
        }
        long streamLength = this.streamInput.getLength();
        int memoryNeeded = (int)streamLength;
        this.checkMemory(memoryNeeded);
        this.streamInput.prepareForCurrentUse();
        InputStream input = this.streamInput;
        int bufferSize = Math.min(Math.max((int)streamLength, 64), 16384);
        input = new BufferedInputStream(input, bufferSize);
        if (this.library.securityManager != null) {
            input = this.library.getSecurityManager().getEncryptionInputStream(this.getPObjectReference(), this.library.getSecurityManager().getDecryptionKey(), input, true);
        }
        if ((filterNames = this.getFilterNames()) == null) {
            return input;
        }
        for (int i = 0; i < filterNames.size(); ++i) {
            String filterName = filterNames.elementAt(i).toString();
            if (filterName.equals("FlateDecode") || filterName.equals("/Fl") || filterName.equals("Fl")) {
                input = new FlateDecode(this.library, this.entries, input);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("LZWDecode") || filterName.equals("/LZW") || filterName.equals("LZW")) {
                input = new LZWDecode(new BitStream(input), this.library, this.entries);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("ASCII85Decode") || filterName.equals("/A85") || filterName.equals("A85")) {
                input = new ASCII85Decode(input);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("ASCIIHexDecode") || filterName.equals("/AHx") || filterName.equals("AHx")) {
                input = new ASCIIHexDecode(input);
                memoryNeeded /= 2;
                continue;
            }
            if (filterName.equals("RunLengthDecode") || filterName.equals("/RL") || filterName.equals("RL")) {
                input = new RunLengthDecode(input);
                memoryNeeded *= 2;
                continue;
            }
            if (filterName.equals("CCITTFaxDecode") || filterName.equals("/CCF") || filterName.equals("CCF") || filterName.equals("DCTDecode") || filterName.equals("/DCT") || filterName.equals("DCT") || filterName.equals("JBIG2Decode")) continue;
            if (filterName.equals("JPXDecode")) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "UNSUPPORTED:" + filterName + " " + this.entries);
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.FINE, "Problem closing stream for unsupported JPXDecode");
                    }
                }
                return null;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("UNSUPPORTED:" + filterName + " " + this.entries);
        }
        this.checkMemory(memoryNeeded);
        return input;
    }

    private byte[] getDecodedStreamBytes() {
        InputStream input = this.getInputStreamForDecodedStreamBytes();
        if (input == null) {
            return null;
        }
        try {
            int read;
            int outLength = Math.max(1024, (int)this.streamInput.getLength());
            ConservativeSizingByteArrayOutputStream out = new ConservativeSizingByteArrayOutputStream(outLength, this.library.memoryManager);
            byte[] buffer = new byte[outLength > 1024 ? 4096 : 1024];
            while ((read = input.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.flush();
            out.close();
            input.close();
            byte[] ret = out.toByteArray();
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem decoding stream bytes: ", e);
            return null;
        }
    }

    private Object[] getDecodedStreamBytesAndSize(int presize) {
        InputStream input = this.getInputStreamForDecodedStreamBytes();
        if (input == null) {
            return null;
        }
        try {
            int read;
            int outLength = presize > 0 ? presize : Math.max(1024, (int)this.streamInput.getLength());
            ConservativeSizingByteArrayOutputStream out = new ConservativeSizingByteArrayOutputStream(outLength, this.library.memoryManager);
            byte[] buffer = new byte[outLength > 1024 ? 4096 : 1024];
            while ((read = input.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.flush();
            out.close();
            input.close();
            int size = out.size();
            boolean trimmed = out.trim();
            byte[] data = out.relinquishByteArray();
            Object[] ret = new Object[]{data, size};
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem decoding stream bytes: ", e);
            return null;
        }
    }

    private void copyDecodedStreamBytesIntoRGB(int[] pixels) {
        byte[] rgb = new byte[3];
        try {
            InputStream input = this.getInputStreamForDecodedStreamBytes();
            for (int pixelIndex = 0; pixelIndex < pixels.length; ++pixelIndex) {
                int argb = -16777216;
                if (input != null) {
                    int haveRead;
                    int currRead;
                    int toRead = 3;
                    for (haveRead = 0; haveRead < 3 && (currRead = input.read(rgb, haveRead, 3 - haveRead)) >= 0; haveRead += currRead) {
                    }
                    if (haveRead >= 1) {
                        argb |= rgb[0] << 16 & 0xFF0000;
                    }
                    if (haveRead >= 2) {
                        argb |= rgb[1] << 8 & 0xFF00;
                    }
                    if (haveRead >= 3) {
                        argb |= rgb[2] & 0xFF;
                    }
                }
                pixels[pixelIndex] = argb;
            }
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem copying decoding stream bytes: ", e);
        }
    }

    private boolean shouldUseCCITTFaxDecode() {
        return this.containsFilter(new String[]{"CCITTFaxDecode", "/CCF", "CCF"});
    }

    private boolean shouldUseDCTDecode() {
        return this.containsFilter(new String[]{"DCTDecode", "/DCT", "DCT"});
    }

    private boolean shouldUseJBIG2Decode() {
        return this.containsFilter(new String[]{"JBIG2Decode"});
    }

    private boolean containsFilter(String[] searchFilterNames) {
        Vector filterNames = this.getFilterNames();
        if (filterNames == null) {
            return false;
        }
        for (int i = 0; i < filterNames.size(); ++i) {
            String filterName = filterNames.elementAt(i).toString();
            for (String search : searchFilterNames) {
                if (!search.equals(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    private Vector getFilterNames() {
        Vector filterNames = null;
        Object o = this.library.getObject(this.entries, "Filter");
        if (o instanceof Name) {
            filterNames = new Vector(1);
            filterNames.addElement(o);
        } else if (o instanceof Vector) {
            filterNames = (Vector)o;
        }
        return filterNames;
    }

    private Vector getNormalisedFilterNames() {
        Vector filterNames = this.getFilterNames();
        if (filterNames == null) {
            return null;
        }
        for (int i = 0; i < filterNames.size(); ++i) {
            String filterName = filterNames.elementAt(i).toString();
            if (filterName.equals("FlateDecode") || filterName.equals("/Fl") || filterName.equals("Fl")) {
                filterName = "FlateDecode";
            } else if (filterName.equals("LZWDecode") || filterName.equals("/LZW") || filterName.equals("LZW")) {
                filterName = "LZWDecode";
            } else if (filterName.equals("ASCII85Decode") || filterName.equals("/A85") || filterName.equals("A85")) {
                filterName = "ASCII85Decode";
            } else if (filterName.equals("ASCIIHexDecode") || filterName.equals("/AHx") || filterName.equals("AHx")) {
                filterName = "ASCIIHexDecode";
            } else if (filterName.equals("RunLengthDecode") || filterName.equals("/RL") || filterName.equals("RL")) {
                filterName = "RunLengthDecode";
            } else if (filterName.equals("CCITTFaxDecode") || filterName.equals("/CCF") || filterName.equals("CCF")) {
                filterName = "CCITTFaxDecode";
            } else if (filterName.equals("DCTDecode") || filterName.equals("/DCT") || filterName.equals("DCT")) {
                filterName = "DCTDecode";
            }
            filterNames.set(i, filterName);
        }
        return filterNames;
    }

    private byte[] decodeCCITTFaxDecodeOrDCTDecodeOrJBIG2DecodeImage(int width, int height, PColorSpace colourSpace, int bitspercomponent, Color fill, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        byte[] data = null;
        if (this.shouldUseCCITTFaxDecode()) {
            boolean worked;
            if (Tagger.tagging) {
                Tagger.tagImage("CCITTFaxDecode");
            }
            if (!(worked = this.nonDecodeCCITTMakeImage(fill))) {
                data = this.ccittfaxDecode(this.getInputStreamForDecodedStreamBytes());
            }
        } else if (this.shouldUseDCTDecode()) {
            if (Tagger.tagging) {
                Tagger.tagImage("DCTDecode");
            }
            this.dctDecode(width, height, colourSpace, bitspercomponent, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
        } else if (this.shouldUseJBIG2Decode()) {
            if (Tagger.tagging) {
                Tagger.tagImage("JBIG2Decode");
            }
            this.jbig2Decode(width, height);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean cache) {
        if (this.streamInput != null && !cache) {
            try {
                this.streamInput.dispose();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Error disposing stream.", e);
            }
            this.streamInput = null;
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image != null) {
                this.image.dispose(cache, this.streamInput != null);
                if (!cache || !this.image.isCachedSomehow()) {
                    this.image = null;
                    this.isCCITTFaxDecodeWithoutEncodedByteAlign = false;
                    this.CCITTFaxDecodeColumnWidthMismatch = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dctDecode(int width, int height, PColorSpace colourSpace, int bitspercomponent, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        BufferedImage tmpImage;
        InputStream input = this.getInputStreamForDecodedStreamBytes();
        int MAX_BYTES_TO_READ_FOR_ENCODING = 2048;
        BufferedInputStream bufferedInput = new BufferedInputStream(input, 2048);
        bufferedInput.mark(2048);
        int jpegEncoding = 0;
        try {
            byte[] data = new byte[2048];
            int dataRead = bufferedInput.read(data);
            bufferedInput.reset();
            if (dataRead > 0) {
                jpegEncoding = Stream.getJPEGEncoding(data, dataRead);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Problem determining JPEG type: ", ioe);
        }
        if (Tagger.tagging) {
            Tagger.tagImage("DCTDecode_JpegEncoding=" + JPEG_ENC_NAMES[jpegEncoding]);
        }
        if ((tmpImage = null) == null) {
            try {
                WritableRaster wr;
                Raster r;
                JPEGImageDecoder imageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInput);
                int bizarreFudge = 65536 + (int)this.streamInput.getLength();
                this.checkMemory(width * height * 8 + bizarreFudge);
                if (jpegEncoding == 1 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    Stream.alterRasterRGB2PColorSpace(wr, colourSpace);
                    tmpImage = Stream.makeRGBBufferedImage(wr);
                } else if (jpegEncoding == 2 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    Stream.alterRasterCMYK2BGRA(wr, smaskImage, maskImage);
                    tmpImage = Stream.makeRGBABufferedImage(wr);
                } else if (jpegEncoding == 3 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    Stream.alterRasterYCbCr2RGB(wr);
                    tmpImage = Stream.makeRGBBufferedImage(wr);
                } else if (jpegEncoding == 4 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    Stream.alterRasterYCCK2BGRA(wr, smaskImage, maskImage);
                    tmpImage = Stream.makeRGBABufferedImage(wr);
                } else if (jpegEncoding == 5 && bitspercomponent == 8) {
                    r = imageDecoder.decodeAsRaster();
                    WritableRaster writableRaster = wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    if (!(colourSpace instanceof DeviceGray)) {
                        if (Tagger.tagging) {
                            Tagger.tagImage("DCTDecode_JpegSubEncoding=Y");
                        }
                        Stream.alterRasterY2Gray(wr);
                    }
                    tmpImage = Stream.makeGrayBufferedImage(wr);
                } else {
                    r = imageDecoder.decodeAsRaster();
                    WritableRaster writableRaster = wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                    if (imageDecoder.getJPEGDecodeParam().getEncodedColorID() == 7) {
                        if (Tagger.tagging) {
                            Tagger.tagImage("DCTDecode_JpegSubEncoding=YCbCrA");
                        }
                        Stream.alterRasterYCbCrA2RGBA_new(wr, smaskImage, maskImage);
                        tmpImage = Stream.makeRGBABufferedImage(wr);
                    } else {
                        if (Tagger.tagging) {
                            Tagger.tagImage("DCTDecode_JpegSubEncoding=YCbCr");
                        }
                        Stream.alterRasterYCbCr2RGB(wr);
                        tmpImage = Stream.makeRGBBufferedImage(wr);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via JPEGImageDecoder: ", e);
            }
            if (tmpImage != null && Tagger.tagging) {
                Tagger.tagImage("HandledBy=DCTDecode_SunJPEGImageDecoder");
            }
        }
        try {
            bufferedInput.close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error closing image stream.", e);
        }
        if (tmpImage == null) {
            try {
                Class<?> roClass;
                Method roGetAsBufferedImage;
                Object javax_media_jai_RenderedOp_op = null;
                try {
                    input = this.getInputStreamForDecodedStreamBytes();
                    Class<?> ssClass = Class.forName("com.sun.media.jai.codec.SeekableStream");
                    Method ssWrapInputStream = ssClass.getMethod("wrapInputStream", InputStream.class, Boolean.TYPE);
                    Object com_sun_media_jai_codec_SeekableStream_s = ssWrapInputStream.invoke(null, input, Boolean.TRUE);
                    ParameterBlock pb = new ParameterBlock();
                    pb.add(com_sun_media_jai_codec_SeekableStream_s);
                    Class<?> jaiClass = Class.forName("javax.media.jai.JAI");
                    Method jaiCreate = jaiClass.getMethod("create", String.class, ParameterBlock.class);
                    javax_media_jai_RenderedOp_op = jaiCreate.invoke(null, "jpeg", pb);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!(javax_media_jai_RenderedOp_op == null || jpegEncoding == 2 && bitspercomponent == 8 || jpegEncoding == 4 && bitspercomponent == 8 || (tmpImage = (BufferedImage)(roGetAsBufferedImage = (roClass = Class.forName("javax.media.jai.RenderedOp")).getMethod("getAsBufferedImage", new Class[0])).invoke(javax_media_jai_RenderedOp_op, new Object[0])) == null || !Tagger.tagging)) {
                    Tagger.tagImage("HandledBy=DCTDecode_JAI");
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via JAI: ", e);
            }
            try {
                input.close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Problem closing image stream. ", e);
            }
        }
        if (tmpImage == null) {
            try {
                Image img;
                byte[] data = this.getDecodedStreamBytes();
                if (data != null && (img = Toolkit.getDefaultToolkit().createImage(data)) != null) {
                    tmpImage = this.makeRGBABufferedImageFromImage(img);
                    if (Tagger.tagging) {
                        Tagger.tagImage("HandledBy=DCTDecode_ToolkitCreateImage");
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via Toolkit: ", e);
            }
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image == null) {
                this.image = new ImageCache(this.library);
            }
            this.image.setImage(tmpImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jbig2Decode(int width, int height) {
        BufferedImage tmpImage = null;
        try {
            Stream globalsStream;
            byte[] globals;
            this.checkMemory(110592);
            JBIG2Decoder decoder = new JBIG2Decoder();
            Hashtable decodeparms = this.library.getDictionary(this.entries, "DecodeParms");
            if (decodeparms != null && (globals = (globalsStream = (Stream)this.library.getObject(decodeparms, "JBIG2Globals")).getDecodedStreamBytes()) != null && globals.length > 0) {
                decoder.setGlobalData(globals);
                globals = null;
            }
            byte[] data = this.getDecodedStreamBytes();
            this.checkMemory((width + 8) * height * 22 / 10);
            decoder.decodeJBIG2(data);
            data = null;
            decoder.cleanupPostDecode();
            this.checkMemory((width + 8) * height / 8);
            tmpImage = decoder.getPageAsBufferedImage(0);
            decoder = null;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem loading JBIG2 image: ", e);
        }
        catch (JBIG2Exception e) {
            logger.log(Level.FINE, "Problem loading JBIG2 image: ", e);
        }
        if (tmpImage != null) {
            Object object = this.imageLock;
            synchronized (object) {
                if (this.image == null) {
                    this.image = new ImageCache(this.library);
                }
                this.image.setImage(tmpImage);
            }
        }
    }

    private static void alterRasterCMYK2BGRA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int[] values = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, values);
                int cValue = values[0];
                int mValue = values[1];
                int yValue = values[2];
                int kValue = values[3];
                int maxOrig = Math.max(cValue, Math.max(mValue, yValue));
                kValue = (255 - maxOrig) * kValue / 255;
                cValue += kValue;
                mValue += kValue;
                yValue += kValue;
                cValue = Math.max(0, Math.min(255, cValue));
                mValue = Math.max(0, Math.min(255, mValue));
                yValue = Math.max(0, Math.min(255, yValue));
                int rValue = 255 - cValue;
                int gValue = 255 - mValue;
                int bValue = 255 - yValue;
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                }
                values[0] = bValue;
                values[1] = gValue;
                values[2] = rValue;
                values[3] = alpha;
                wr.setPixel(x, y, values);
            }
        }
    }

    private static void alterRasterYCbCr2RGB(WritableRaster wr) {
        int[] values = new int[3];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                wr.getPixel(x, y, values);
                int Y = values[0];
                int Cb = values[1];
                int Cr = values[2];
                int Cr_128 = Cr - 128;
                int Cb_128 = Cb - 128;
                int rVal = Y + 1370705 * Cr_128 / 1000000;
                int gVal = Y - 337633 * Cb_128 / 1000000 - 698001 * Cr_128 / 1000000;
                int bVal = Y + 1732446 * Cb_128 / 1000000;
                byte by = (byte)(rVal < 0 ? 0 : (byte)(rByte = (byte)(rVal > 255 ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0 ? 0 : (byte)(gByte = (byte)(gVal > 255 ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0 ? 0 : (byte)(bVal > 255 ? -1 : (byte)bVal));
                values[0] = rByte;
                values[1] = gByte;
                values[2] = bByte;
                wr.setPixel(x, y, values);
            }
        }
    }

    private static void alterRasterYCCK2BGRA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int[] origValues = new int[4];
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                wr.getPixel(x, y, origValues);
                int Y = origValues[0];
                int Cb = origValues[1];
                int Cr = origValues[2];
                int K = origValues[3];
                int Cr_128 = Cr - 128;
                int Cb_128 = Cb - 128;
                int rVal = (Y -= K) + 1370705 * Cr_128 / 1000000;
                int gVal = Y - 337633 * Cb_128 / 1000000 - 698001 * Cr_128 / 1000000;
                int bVal = Y + 1732446 * Cb_128 / 1000000;
                byte by = (byte)(rVal < 0 ? 0 : (byte)(rByte = (byte)(rVal > 255 ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0 ? 0 : (byte)(gByte = (byte)(gVal > 255 ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0 ? 0 : (byte)(bVal > 255 ? -1 : (byte)bVal));
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                }
                rgbaValues[0] = bByte;
                rgbaValues[1] = gByte;
                rgbaValues[2] = rByte;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
    }

    private static void alterRasterYCbCrA2RGBA_new(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int[] origValues = new int[4];
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gByte;
                int rByte;
                wr.getPixel(x, y, origValues);
                int Y = origValues[0];
                int Cb = origValues[1];
                int Cr = origValues[2];
                int K = origValues[3];
                Y = K - Y;
                int Cr_128 = Cr - 128;
                int Cb_128 = Cb - 128;
                int rVal = Y + 1370705 * Cr_128 / 1000000;
                int gVal = Y - 337633 * Cb_128 / 1000000 - 698001 * Cr_128 / 1000000;
                int bVal = Y + 1732446 * Cb_128 / 1000000;
                byte by = (byte)(rVal < 0 ? 0 : (byte)(rByte = (byte)(rVal > 255 ? -1 : (byte)rVal)));
                byte by2 = (byte)(gVal < 0 ? 0 : (byte)(gByte = (byte)(gVal > 255 ? -1 : (byte)gVal)));
                int bByte = (byte)(bVal < 0 ? 0 : (byte)(bVal > 255 ? -1 : (byte)bVal));
                int alpha = K;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                }
                rgbaValues[0] = rByte;
                rgbaValues[1] = gByte;
                rgbaValues[2] = bByte;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
    }

    private static void alterBufferedImage(BufferedImage bi, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        if (smaskRaster == null && maskRaster == null && (maskMinRGB == null || maskMaxRGB == null)) {
            return;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                boolean gotARBG = false;
                int argb = 0;
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                } else {
                    gotARBG = true;
                    argb = bi.getRGB(x, y);
                    int red = argb >> 16 & 0xFF;
                    int green = argb >> 8 & 0xFF;
                    int blue = argb & 0xFF;
                    if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                        alpha = 0;
                    }
                }
                if (alpha == 255) continue;
                if (!gotARBG) {
                    argb = bi.getRGB(x, y);
                }
                argb &= 0xFFFFFF;
                bi.setRGB(x, y, argb |= alpha << 24 & 0xFF000000);
            }
        }
    }

    private static void alterRasterRGBA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        if (smaskRaster == null && maskRaster == null && (maskMinRGB == null || maskMaxRGB == null)) {
            return;
        }
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, rgbaValues);
                int red = rgbaValues[0];
                int green = rgbaValues[1];
                int blue = rgbaValues[2];
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskRaster.getSample(x, y, 0) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                } else if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                    alpha = 0;
                }
                if (alpha == 255) continue;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
    }

    private static void alterRasterRGB2PColorSpace(WritableRaster wr, PColorSpace colorSpace) {
        if (colorSpace instanceof DeviceRGB) {
            return;
        }
        float[] values = new float[3];
        int[] rgbValues = new int[3];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, rgbValues);
                PColorSpace.reverseInPlace(rgbValues);
                colorSpace.normaliseComponentsToFloats(rgbValues, values, 255.0f);
                Color c = colorSpace.getColor(values);
                rgbValues[0] = c.getRed();
                rgbValues[1] = c.getGreen();
                rgbValues[2] = c.getBlue();
                wr.setPixel(x, y, rgbValues);
            }
        }
    }

    private static void alterRasterY2Gray(WritableRaster wr) {
        int[] values = new int[1];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, values);
                int Y = values[0];
                int yByte = (byte)(Y < 0 ? 0 : (byte)(Y > 255 ? -1 : (byte)Y));
                values[0] = 255 - yByte;
                wr.setPixel(x, y, values);
            }
        }
    }

    private static int getJPEGEncoding(byte[] data, int dataLength) {
        int jpegEncoding = 0;
        boolean foundAPP14 = false;
        int compsTypeFromAPP14 = 0;
        boolean foundSOF = false;
        int numCompsFromSOF = 0;
        boolean foundSOS = false;
        int numCompsFromSOS = 0;
        int index = 0;
        while (!(index >= dataLength || data[index] != -1 || foundAPP14 && foundSOF)) {
            byte segmentType = data[index + 1];
            index += 2;
            if (segmentType == -40) continue;
            int length = (data[index] << 8 & 0xFF00) + (data[index + 1] & 0xFF);
            if (segmentType == -18) {
                if (length >= 14) {
                    foundAPP14 = true;
                    compsTypeFromAPP14 = data[index + 13];
                }
            } else if (segmentType == -64) {
                foundSOF = true;
                numCompsFromSOF = data[index + 7] & 0xFF;
            } else if (segmentType == -38) {
                foundSOS = true;
                numCompsFromSOS = data[index + 2] & 0xFF;
            }
            index += length;
        }
        if (foundAPP14 && foundSOF) {
            if (compsTypeFromAPP14 == 0) {
                if (numCompsFromSOF == 1) {
                    jpegEncoding = 5;
                }
                if (numCompsFromSOF == 3) {
                    jpegEncoding = 1;
                } else if (numCompsFromSOF == 4) {
                    jpegEncoding = 2;
                }
            } else if (compsTypeFromAPP14 == 1) {
                jpegEncoding = 3;
            } else if (compsTypeFromAPP14 == 2) {
                jpegEncoding = 4;
            }
        } else if (foundSOS && numCompsFromSOS == 1) {
            jpegEncoding = 5;
        }
        return jpegEncoding;
    }

    private static BufferedImage makeRGBABufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[4];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, true, false, 1, wr.getTransferType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    private static BufferedImage makeRGBBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[3];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    private static BufferedImage makeGrayBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[1];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    private BufferedImage makeRGBABufferedImageFromImage(Image img) {
        BufferedImage ret = null;
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int count = 0;
        while (width < 0 || height < 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            width = img.getWidth(null);
            height = img.getHeight(null);
            if (++count <= 20) continue;
        }
        if (width >= 0 && height >= 0) {
            this.checkMemory(width * height * 4);
            ret = new BufferedImage(width, height, 2);
            Graphics g = ret.getGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
            img.flush();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nonDecodeCCITTMakeImage(Color fill) {
        BufferedImage tmpImage = CCITTFax.attemptDeriveBufferedImageFromBytes(this, this.library, this.entries, fill);
        if (tmpImage != null) {
            Object object = this.imageLock;
            synchronized (object) {
                if (this.image == null) {
                    this.image = new ImageCache(this.library);
                }
                this.image.setImage(tmpImage);
            }
            return true;
        }
        return false;
    }

    private byte[] ccittfaxDecode(InputStream in) {
        Hashtable decodeparms = this.library.getDictionary(this.entries, "DecodeParms");
        float k = this.library.getFloat(decodeparms, "K");
        boolean blackIs1 = this.getBlackIs1(this.library, decodeparms);
        boolean encodedByteAlign = false;
        Object encodedByteAlignObject = this.library.getObject(decodeparms, "EncodedByteAlign");
        if (encodedByteAlignObject instanceof Boolean) {
            encodedByteAlign = (Boolean)encodedByteAlignObject;
        }
        int columns = this.library.getInt(decodeparms, "Columns");
        int width = this.library.getInt(this.entries, "Width");
        int height = this.library.getInt(this.entries, "Height");
        int memoryNeeded = width * height / 8;
        this.checkMemory(memoryNeeded);
        ByteArrayOutputStream out = new ByteArrayOutputStream(memoryNeeded);
        if (k < 0.0f) {
            CCITTFax.Group4Decode(in, out, columns, blackIs1);
            if (Tagger.tagging) {
                Tagger.tagImage("HandledBy=CCITTFaxDecode_InternalGroup4");
                Tagger.tagImage("CCITTFaxDecode_DecodeParms_BlackIs1=" + this.getBlackIs1OrNull(this.library, decodeparms));
                Tagger.tagImage("CCITTFaxDecode_DecodeParms_K=" + k);
                Tagger.tagImage("CCITTFaxDecode_DecodeParms_EncodedByteAlign=" + encodedByteAlignObject);
            }
        }
        try {
            out.close();
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!encodedByteAlign) {
            this.isCCITTFaxDecodeWithoutEncodedByteAlign = true;
        }
        if (columns > width) {
            this.CCITTFaxDecodeColumnWidthMismatch = columns - width;
        }
        return out.toByteArray();
    }

    public byte[] getBytes() {
        byte[] data = this.getDecodedStreamBytes();
        if (data == null) {
            data = new byte[]{};
        }
        return data;
    }

    public BufferedImage getImage(Color fill, Resources resources, boolean allowScaling) {
        BufferedImage img;
        if (Tagger.tagging) {
            Tagger.beginImage(this.pObjectReference, this.inlineImage);
        }
        if (Tagger.tagging) {
            Tagger.tagImage("Filter=" + this.getNormalisedFilterNames());
        }
        PColorSpace colourSpace = null;
        Object o = this.library.getObject(this.entries, "ColorSpace");
        if (resources != null) {
            colourSpace = resources.getColorSpace(o);
        }
        if (colourSpace == null) {
            colourSpace = new DeviceGray(this.library, null);
            if (Tagger.tagging) {
                Tagger.tagImage("ColorSpace_Implicit_DeviceGray");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("ColorSpace=" + colourSpace.getDescription());
        }
        boolean imageMask = this.isImageMask();
        if (Tagger.tagging) {
            Tagger.tagImage("ImageMask=" + imageMask);
        }
        if (imageMask) {
            allowScaling = false;
        }
        int bitspercomponent = this.library.getInt(this.entries, "BitsPerComponent");
        if (imageMask && bitspercomponent == 0) {
            bitspercomponent = 1;
            if (Tagger.tagging) {
                Tagger.tagImage("BitsPerComponent_Implicit_1");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("BitsPerComponent=" + bitspercomponent);
        }
        int width = this.library.getInt(this.entries, "Width");
        int height = this.library.getInt(this.entries, "Height");
        int colorSpaceCompCount = colourSpace.getNumComponents();
        Vector<Float> decode = (Vector<Float>)this.library.getObject(this.entries, "Decode");
        if (decode == null) {
            decode = new Vector<Float>(2);
            decode.addElement(new Float(0.0f));
            decode.addElement(new Float(1.0f));
            if (Tagger.tagging) {
                Tagger.tagImage("Decode_Implicit_01");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("Decode=" + decode);
        }
        BufferedImage smaskImage = null;
        BufferedImage maskImage = null;
        int[] maskMinRGB = null;
        int[] maskMaxRGB = null;
        int maskMinIndex = -1;
        int maskMaxIndex = -1;
        Object smaskObj = this.library.getObject(this.entries, "SMask");
        Object maskObj = this.library.getObject(this.entries, "Mask");
        if (smaskObj instanceof Stream) {
            Stream smaskStream;
            if (Tagger.tagging) {
                Tagger.tagImage("SMaskStream");
            }
            if ((smaskStream = (Stream)smaskObj).isImageSubtype()) {
                smaskImage = smaskStream.getImage(fill, resources, false);
            }
        }
        if (smaskImage != null) {
            if (Tagger.tagging) {
                Tagger.tagImage("SMaskImage");
            }
            allowScaling = false;
        }
        if (maskObj != null && smaskImage == null) {
            if (maskObj instanceof Stream) {
                Stream maskStream;
                if (Tagger.tagging) {
                    Tagger.tagImage("MaskStream");
                }
                if ((maskStream = (Stream)maskObj).isImageSubtype() && (maskImage = maskStream.getImage(fill, resources, false)) != null && Tagger.tagging) {
                    Tagger.tagImage("MaskImage");
                }
            } else if (maskObj instanceof Vector) {
                if (Tagger.tagging) {
                    Tagger.tagImage("MaskVector");
                }
                Vector maskVector = (Vector)maskObj;
                int[] maskMinOrigCompsInt = new int[colorSpaceCompCount];
                int[] maskMaxOrigCompsInt = new int[colorSpaceCompCount];
                for (int i = 0; i < colorSpaceCompCount; ++i) {
                    if (i * 2 < maskVector.size()) {
                        maskMinOrigCompsInt[i] = ((Number)maskVector.get(i * 2)).intValue();
                    }
                    if (i * 2 + 1 >= maskVector.size()) continue;
                    maskMaxOrigCompsInt[i] = ((Number)maskVector.get(i * 2 + 1)).intValue();
                }
                if (colourSpace instanceof Indexed) {
                    Indexed icolourSpace = (Indexed)colourSpace;
                    Color[] colors = icolourSpace.accessColorTable();
                    if (colors != null && maskMinOrigCompsInt.length >= 1 && maskMaxOrigCompsInt.length >= 1) {
                        maskMinIndex = maskMinOrigCompsInt[0];
                        maskMaxIndex = maskMaxOrigCompsInt[0];
                        if (maskMinIndex >= 0 && maskMinIndex < colors.length && maskMaxIndex >= 0 && maskMaxIndex < colors.length) {
                            Color minColor = colors[maskMinOrigCompsInt[0]];
                            Color maxColor = colors[maskMaxOrigCompsInt[0]];
                            maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                            maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                        }
                    }
                } else {
                    PColorSpace.reverseInPlace(maskMinOrigCompsInt);
                    PColorSpace.reverseInPlace(maskMaxOrigCompsInt);
                    float[] maskMinOrigComps = new float[colorSpaceCompCount];
                    float[] maskMaxOrigComps = new float[colorSpaceCompCount];
                    colourSpace.normaliseComponentsToFloats(maskMinOrigCompsInt, maskMinOrigComps, (1 << bitspercomponent) - 1);
                    colourSpace.normaliseComponentsToFloats(maskMaxOrigCompsInt, maskMaxOrigComps, (1 << bitspercomponent) - 1);
                    Color minColor = colourSpace.getColor(maskMinOrigComps);
                    Color maxColor = colourSpace.getColor(maskMaxOrigComps);
                    PColorSpace.reverseInPlace(maskMinOrigComps);
                    PColorSpace.reverseInPlace(maskMaxOrigComps);
                    maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                    maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                }
            }
        }
        if ((img = this.getImage(colourSpace, fill, width, height, colorSpaceCompCount, bitspercomponent, imageMask, decode, smaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex)) != null) {
            img = this.putIntoImageCache(img, width, height, allowScaling);
        }
        if (Tagger.tagging) {
            Tagger.endImage(this.pObjectReference);
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(PColorSpace colourSpace, Color fill, int width, int height, int colorSpaceCompCount, int bitspercomponent, boolean imageMask, Vector decode, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex) {
        BufferedImage img;
        byte[] baCCITTFaxData = null;
        if (this.image == null) {
            baCCITTFaxData = this.decodeCCITTFaxDecodeOrDCTDecodeOrJBIG2DecodeImage(width, height, colourSpace, bitspercomponent, fill, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
        }
        if (this.image != null) {
            this.checkMemory(width * height * Math.max(colorSpaceCompCount, 4));
            img = null;
            Object object = this.imageLock;
            synchronized (object) {
                if (this.image != null) {
                    img = this.image.readImage();
                }
            }
            if (img != null) {
                return img;
            }
        }
        if (baCCITTFaxData == null) {
            try {
                img = this.makeImageWithRasterFromBytes(colourSpace, fill, width, height, colorSpaceCompCount, bitspercomponent, imageMask, decode, smaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex);
                if (img != null) {
                    return img;
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error building image raster.", e);
            }
        }
        BufferedImage im = this.parseImage(width, height, colourSpace, imageMask, fill, bitspercomponent, decode, baCCITTFaxData, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
        return im;
    }

    private BufferedImage makeImageWithRasterFromBytes(PColorSpace colourSpace, Color fill, int width, int height, int colorSpaceCompCount, int bitspercomponent, boolean imageMask, Vector decode, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex) {
        BufferedImage img = null;
        if (colourSpace instanceof DeviceGray) {
            if (imageMask && bitspercomponent == 1) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_1_ImageMask");
                }
                Object[] dataAndSize = this.getDecodedStreamBytesAndSize(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
                byte[] data = (byte[])dataAndSize[0];
                int data_length = (Integer)dataAndSize[1];
                DataBufferByte db = new DataBufferByte(data, data_length);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                boolean defaultDecode = 0.0f == ((Number)decode.elementAt(0)).floatValue();
                int a = 0xFFFFFF;
                int[] cmap = new int[]{defaultDecode ? fill.getRGB() : a, defaultDecode ? a : fill.getRGB()};
                int transparentIndex = defaultDecode ? 1 : 0;
                IndexColorModel icm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, true, transparentIndex, db.getDataType());
                img = new BufferedImage(icm, wr, false, null);
            } else if (bitspercomponent == 1 || bitspercomponent == 2 || bitspercomponent == 4) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_124");
                }
                Object[] dataAndSize = this.getDecodedStreamBytesAndSize(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
                byte[] data = (byte[])dataAndSize[0];
                int data_length = (Integer)dataAndSize[1];
                DataBufferByte db = new DataBufferByte(data, data_length);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                int[] cmap = null;
                if (bitspercomponent == 1) {
                    boolean defaultDecode = 0.0f == ((Number)decode.elementAt(0)).floatValue();
                    cmap = defaultDecode ? GRAY_1_BIT_INDEX_TO_RGB : GRAY_1_BIT_INDEX_TO_RGB_REVERSED;
                } else if (bitspercomponent == 2) {
                    cmap = GRAY_2_BIT_INDEX_TO_RGB;
                } else if (bitspercomponent == 4) {
                    cmap = GRAY_4_BIT_INDEX_TO_RGB;
                }
                IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            } else if (bitspercomponent == 8) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceGray_8");
                }
                Object[] dataAndSize = this.getDecodedStreamBytesAndSize(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
                byte[] data = (byte[])dataAndSize[0];
                int data_length = (Integer)dataAndSize[1];
                DataBufferByte db = new DataBufferByte(data, data_length);
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                ColorSpace cs = ColorSpace.getInstance(1003);
                ComponentColorModel cm = new ComponentColorModel(cs, new int[]{bitspercomponent}, false, false, 1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            }
        } else if (colourSpace instanceof DeviceRGB) {
            if (bitspercomponent == 8) {
                boolean usingAlpha;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_DeviceRGB_8");
                }
                this.checkMemory(width * height * 4);
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_DeviceRGB_8_alpha=" + usingAlpha);
                }
                int type = usingAlpha ? 2 : 1;
                img = new BufferedImage(width, height, type);
                int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                this.copyDecodedStreamBytesIntoRGB(data);
                if (usingAlpha) {
                    Stream.alterBufferedImage(img, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                }
            }
        } else if (!(colourSpace instanceof DeviceCMYK) && colourSpace instanceof Indexed) {
            if (bitspercomponent == 1 || bitspercomponent == 2 || bitspercomponent == 4) {
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_Indexed_124");
                }
                Object[] dataAndSize = this.getDecodedStreamBytesAndSize(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
                byte[] data = (byte[])dataAndSize[0];
                int data_length = (Integer)dataAndSize[1];
                DataBufferByte db = new DataBufferByte(data, data_length);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitspercomponent, new Point(0, 0));
                colourSpace.init();
                Color[] colors = ((Indexed)colourSpace).accessColorTable();
                int[] cmap = new int[colors == null ? 0 : colors.length];
                for (int i = 0; i < cmap.length; ++i) {
                    cmap[i] = colors[i].getRGB();
                }
                int cmapMaxLength = 1 << bitspercomponent;
                if (cmap.length > cmapMaxLength) {
                    int[] cmapTruncated = new int[cmapMaxLength];
                    System.arraycopy(cmap, 0, cmapTruncated, 0, cmapMaxLength);
                    cmap = cmapTruncated;
                }
                IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            } else if (bitspercomponent == 8) {
                boolean usingAlpha;
                int i;
                if (Tagger.tagging) {
                    Tagger.tagImage("HandledBy=RasterFromBytes_Indexed_8");
                }
                Object[] dataAndSize = this.getDecodedStreamBytesAndSize(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
                byte[] data = (byte[])dataAndSize[0];
                int data_length = (Integer)dataAndSize[1];
                colourSpace.init();
                Color[] colors = ((Indexed)colourSpace).accessColorTable();
                int colorsLength = colors == null ? 0 : colors.length;
                int[] cmap = new int[256];
                for (i = 0; i < colorsLength; ++i) {
                    cmap[i] = colors[i].getRGB();
                }
                for (i = colorsLength; i < cmap.length; ++i) {
                    cmap[i] = -16777216;
                }
                boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
                boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                if (Tagger.tagging) {
                    Tagger.tagImage("RasterFromBytes_Indexed_8_alpha=" + (usingIndexedAlpha ? "indexed" : (usingAlpha ? "alpha" : "false")));
                }
                if (usingIndexedAlpha) {
                    for (int i2 = maskMinIndex; i2 <= maskMaxIndex; ++i2) {
                        cmap[i2] = 0;
                    }
                    DataBufferByte db = new DataBufferByte(data, data_length);
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, true, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                } else if (usingAlpha) {
                    this.checkMemory(width * height * 4);
                    int[] rgbaData = new int[width * height];
                    int end = data_length;
                    for (int index = 0; index < end; ++index) {
                        int cmapIndex = data[index] & 0xFF;
                        rgbaData[index] = cmap[cmapIndex];
                    }
                    DataBufferInt db = new DataBufferInt(rgbaData, rgbaData.length);
                    int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
                    WritableRaster wr = Raster.createPackedRaster(db, width, height, width, masks, new Point(0, 0));
                    Stream.alterRasterRGBA(wr, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
                    ColorSpace cs = ColorSpace.getInstance(1000);
                    DirectColorModel cm = new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, false, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                } else {
                    DataBufferByte db = new DataBufferByte(data, data_length);
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), width, height, 1, width, new int[]{0});
                    WritableRaster wr = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    IndexColorModel cm = new IndexColorModel(bitspercomponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                    img = new BufferedImage(cm, wr, false, null);
                }
            }
        }
        return img;
    }

    private BufferedImage parseImage(int width, int height, PColorSpace colorSpace, boolean imageMask, Color fill, int bitsPerColour, Vector decode, byte[] baCCITTFaxData, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        if (Tagger.tagging) {
            Tagger.tagImage("HandledBy=ParseImage");
        }
        int[] imageBits = new int[width];
        int fillRGB = fill.getRGB();
        int colorSpaceCompCount = colorSpace.getNumComponents();
        boolean isDeviceRGB = colorSpace instanceof DeviceRGB;
        boolean isDeviceGray = colorSpace instanceof DeviceGray;
        int maxColourValue = (1 << bitsPerColour) - 1;
        int[] f = new int[colorSpaceCompCount];
        float[] ff = new float[colorSpaceCompCount];
        int imageMaskValue = ((Number)decode.elementAt(0)).intValue();
        float[] decodeArray = null;
        if (decode != null) {
            decodeArray = new float[decode.size()];
            for (int i = 0; i < decodeArray.length; ++i) {
                decodeArray[i] = ((Number)decode.elementAt(i)).floatValue();
            }
        }
        int memoryNeeded = width * height * 4;
        this.checkMemory(memoryNeeded);
        BufferedImage bim = new BufferedImage(width, height, 2);
        int bitsPerRow = width * colorSpaceCompCount * bitsPerColour;
        int extraBitsPerRow = bitsPerRow & 7;
        if (this.CCITTFaxDecodeColumnWidthMismatch > 0) {
            if (Tagger.tagging) {
                Tagger.tagImage("ParseImage_CCITTFaxDecodeColumnWidthMismatch=" + this.CCITTFaxDecodeColumnWidthMismatch);
            }
            int bitsGivenPerRow = (width + this.CCITTFaxDecodeColumnWidthMismatch) * colorSpaceCompCount * bitsPerColour;
            int bitsRelevant = bitsPerRow;
            extraBitsPerRow = bitsGivenPerRow - bitsRelevant;
        }
        BitStream in = null;
        if (baCCITTFaxData != null) {
            in = new BitStream(new ByteArrayInputStream(baCCITTFaxData));
        } else {
            InputStream dataInput = this.getInputStreamForDecodedStreamBytes();
            if (dataInput == null) {
                return null;
            }
            in = new BitStream(dataInput);
        }
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (imageMask) {
                        int bit = in.getBits(bitsPerColour);
                        imageBits[x] = bit = bit == imageMaskValue ? fillRGB : 0;
                        continue;
                    }
                    int red = 255;
                    int blue = 255;
                    int green = 255;
                    int alpha = 255;
                    if (colorSpaceCompCount == 1) {
                        int bit = in.getBits(bitsPerColour);
                        if (decodeArray != null && decodeArray[0] > decodeArray[1]) {
                            int n = bit = bit == maxColourValue ? 0 : maxColourValue;
                        }
                        if (isDeviceGray) {
                            if (bitsPerColour == 1) {
                                bit = GRAY_1_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 2) {
                                bit = GRAY_2_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 4) {
                                bit = GRAY_4_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 8) {
                                bit = bit << 24 | bit << 16 | bit << 8 | bit;
                            }
                            imageBits[x] = bit;
                            continue;
                        }
                        f[0] = bit;
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 3) {
                        if (isDeviceRGB) {
                            red = in.getBits(bitsPerColour);
                            green = in.getBits(bitsPerColour);
                            blue = in.getBits(bitsPerColour);
                            imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                            continue;
                        }
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 4) {
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                }
                bim.setRGB(0, y, width, 1, imageBits, 0, 1);
                if (extraBitsPerRow <= 0 || this.isCCITTFaxDecodeWithoutEncodedByteAlign && this.CCITTFaxDecodeColumnWidthMismatch <= 0) continue;
                in.getBits(extraBitsPerRow);
            }
            in.close();
            in = null;
            if (smaskImage != null || maskImage != null || maskMinRGB != null || maskMaxRGB != null) {
                WritableRaster wr = bim.getRaster();
                Stream.alterRasterRGBA(wr, smaskImage, maskImage, maskMinRGB, maskMaxRGB);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error parsing image.", e);
        }
        return bim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage putIntoImageCache(BufferedImage bim, int width, int height, boolean allowScaling) {
        boolean canScale;
        if (this.image == null) {
            this.image = new ImageCache(this.library);
        }
        boolean setIsScaledOnImageCache = false;
        if (allowScaling && scaleImages && !this.image.isScaled() && (canScale = this.checkMemory(Math.max(width, bim.getWidth()) * Math.max(height, bim.getHeight()) * Math.max(4, bim.getColorModel().getPixelSize())))) {
            bim = ImageCache.scaleBufferedImage(bim, width, height);
            setIsScaledOnImageCache = true;
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image == null) {
                this.image = new ImageCache(this.library);
            }
            if (setIsScaledOnImageCache) {
                this.image.setIsScaled(true);
            }
            this.image.setImage(bim);
            bim = this.image.readImage();
        }
        return bim;
    }

    public boolean isImageMask() {
        Object o = this.library.getObject(this.entries, "ImageMask");
        return o != null ? o.toString().equals("true") : false;
    }

    public boolean getBlackIs1(Library library, Hashtable decodeParmsDictionary) {
        Boolean blackIs1 = this.getBlackIs1OrNull(library, decodeParmsDictionary);
        if (blackIs1 != null) {
            return blackIs1;
        }
        return false;
    }

    public Boolean getBlackIs1OrNull(Library library, Hashtable decodeParmsDictionary) {
        Object blackIs1Obj = library.getObject(decodeParmsDictionary, "BlackIs1");
        if (blackIs1Obj != null) {
            if (blackIs1Obj instanceof Boolean) {
                return (Boolean)blackIs1Obj;
            }
            if (blackIs1Obj instanceof String) {
                String blackIs1String = (String)blackIs1Obj;
                if (blackIs1String.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (blackIs1String.equalsIgnoreCase("t")) {
                    return Boolean.TRUE;
                }
                if (blackIs1String.equals("1")) {
                    return Boolean.TRUE;
                }
                if (blackIs1String.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                if (blackIs1String.equalsIgnoreCase("f")) {
                    return Boolean.FALSE;
                }
                if (blackIs1String.equals("0")) {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("STREAM= ");
        sb.append(this.entries);
        if (this.getPObjectReference() != null) {
            sb.append("  ");
            sb.append(this.getPObjectReference());
        }
        return sb.toString();
    }
}

