/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.io;

import java.io.IOException;
import java.io.Writer;
import org.gatein.common.io.UndeclaredIOException;
import org.gatein.common.text.CharWriter;
import org.gatein.common.util.ParameterValidation;

public class WriterCharWriter
implements CharWriter {
    private final Writer writer;

    public WriterCharWriter(Writer writer) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(writer, "Writer");
        this.writer = writer;
    }

    public CharWriter append(char c) throws UndeclaredIOException {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
        return this;
    }

    public CharWriter append(char[] chars, int off, int len) throws UndeclaredIOException {
        ParameterValidation.throwIllegalArgExceptionIfRangeInvalid(chars, off, len);
        try {
            this.writer.write(chars, off, len);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
        return this;
    }

    public CharWriter append(char[] chars) throws UndeclaredIOException {
        ParameterValidation.throwIllegalArgExceptionIfNull(chars, "char[]");
        try {
            this.writer.write(chars, 0, chars.length);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
        return this;
    }

    public CharWriter append(CharSequence s) throws UndeclaredIOException {
        ParameterValidation.throwIllegalArgExceptionIfNull(s, "CharSequence");
        try {
            if (s instanceof String) {
                this.writer.write((String)s);
            } else {
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    this.writer.write(c);
                }
            }
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
        return this;
    }

    public void flush() throws UndeclaredIOException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public void close() throws UndeclaredIOException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }
}

