/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.reflect;

import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflection {
    public static Method findMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("No class provided");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("No method name provided");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("No parameter types provided");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) continue;
            throw new IllegalArgumentException("Null parameter type at element=" + i);
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Reflection.findDeclaredMethod(clazz, methodName, parameterTypes);
        }
    }

    private static Method findDeclaredMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("No class provided");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("No method name provided");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("No parameter types provided");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) continue;
            throw new IllegalArgumentException("Null parameter type at element=" + i);
        }
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ignore) {
            Method method;
            Class<?> parentClass = clazz.getSuperclass();
            if (parentClass != null && (method = Reflection.findDeclaredMethod(parentClass, methodName, parameterTypes)) != null) {
                return method;
            }
            return null;
        }
    }

    public static <T> T safeCast(Object value, Class<T> type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        return null;
    }
}

