/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.jlr;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.reflext.jlr.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodContainer
implements Iterable<Method> {
    private final Map<MethodSignature, Method> map = new LinkedHashMap<MethodSignature, Method>();

    MethodContainer() {
    }

    public void addAll(Iterable<Method> methods) {
        for (Method method : methods) {
            this.add(method);
        }
    }

    public boolean add(Method method) {
        MethodSignature key = new MethodSignature(method);
        Method existing = this.map.get(key);
        if (existing != null) {
            if (existing.getReturnType().isAssignableFrom(method.getReturnType()) && existing.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) {
                this.map.put(key, method);
                return true;
            }
        } else {
            this.map.put(key, method);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Method> iterator() {
        return this.map.values().iterator();
    }
}

