/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiColumnQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHitsAdapter;
import org.exoplatform.services.jcr.impl.core.query.lucene.SortedLuceneQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.constraint.EvaluationContext;

public class JcrIndexSearcher
extends IndexSearcher
implements EvaluationContext {
    private final SessionImpl session;
    private final IndexReader reader;
    private final ItemDataConsumer ism;

    public JcrIndexSearcher(SessionImpl s, IndexReader r, ItemDataConsumer ism) {
        super(r);
        this.session = s;
        this.reader = r;
        this.ism = ism;
    }

    public MultiColumnQueryHits execute(Query query, Sort sort, long resultFetchHint, InternalQName selectorName) throws IOException {
        return new QueryHitsAdapter(this.evaluate(query, sort, resultFetchHint), selectorName);
    }

    public QueryHits evaluate(Query query, Sort sort, long resultFetchHint) throws IOException {
        query = query.rewrite(this.reader);
        QueryHits hits = null;
        if (query instanceof JcrQuery) {
            hits = ((JcrQuery)query).execute(this, this.session, sort);
        }
        if (hits == null) {
            hits = sort == null ? new LuceneQueryHits(this.reader, this, query) : new SortedLuceneQueryHits(this.reader, this, query, sort, resultFetchHint);
        }
        return hits;
    }

    public QueryHits evaluate(Query query) throws IOException {
        return this.evaluate(query, new Sort(), Integer.MAX_VALUE);
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public ItemDataConsumer getItemStateManager() {
        return this.ism;
    }
}

