/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSerializer {
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();

    public static void serialize(Element element, Writer writer) throws IOException, XMLStreamException {
        XMLStreamWriter xml = outputFactory.createXMLStreamWriter(writer);
        DOMSerializer.serialize(element, xml);
        xml.writeEndDocument();
        xml.flush();
    }

    private static void serialize(Element element, XMLStreamWriter writer) throws IOException, XMLStreamException {
        Node child;
        int i;
        int length;
        NodeList children;
        boolean empty;
        String tagName = element.getTagName();
        if (tagName.equalsIgnoreCase("script")) {
            empty = false;
        } else {
            empty = true;
            children = element.getChildNodes();
            length = children.getLength();
            for (i = 0; i < length && empty; ++i) {
                child = children.item(i);
                if (child instanceof CharacterData) {
                    empty = false;
                    continue;
                }
                if (!(child instanceof Element)) continue;
                empty = false;
            }
        }
        if (empty) {
            writer.writeEmptyElement(tagName);
        } else {
            writer.writeStartElement(tagName);
        }
        if (element.hasAttributes()) {
            NamedNodeMap attrs = element.getAttributes();
            length = attrs.getLength();
            for (i = 0; i < length; ++i) {
                Attr attr = (Attr)attrs.item(i);
                writer.writeAttribute(attr.getName(), attr.getValue());
            }
        }
        if (!empty) {
            children = element.getChildNodes();
            length = children.getLength();
            for (i = 0; i < length; ++i) {
                child = children.item(i);
                if (child instanceof CharacterData) {
                    writer.writeCData(((CharacterData)child).getData());
                    continue;
                }
                if (!(child instanceof Element)) continue;
                DOMSerializer.serialize((Element)child, writer);
            }
            writer.writeEndElement();
        }
    }
}

