/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.util;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.services.chars.CharsUtil;
import org.exoplatform.services.html.Group;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.refs.RefsDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentBuilder {
    private Name[] ignores = new Name[]{Name.HEAD};
    private Name[] styles = new Name[]{Name.FONT, Name.SUB, Name.SUP};
    private char[] end = new char[]{'.', ':', '?'};
    private String month;
    private String year;

    public ContentBuilder() {
        Calendar calendar = Calendar.getInstance();
        this.month = String.valueOf(calendar.get(2) + 1);
        this.year = String.valueOf(calendar.get(1));
    }

    public synchronized boolean build(HTMLNode node, List<char[]> values, RefsDecoder decoder) {
        if (!this.validate(node)) {
            return true;
        }
        List<HTMLNode> children = node.getChildren();
        if (children == null) {
            return true;
        }
        for (HTMLNode child : children) {
            if (child.isNode(Name.CONTENT)) {
                HTMLNode parent;
                char[] chars = child.getValue();
                if (decoder != null) {
                    chars = decoder.decode(chars);
                    if ((chars = CharsUtil.cutAndTrim(chars, 0, chars.length)).length < 1) continue;
                    child.setValue(chars);
                }
                if ((parent = this.getAncestor(child, Name.A)) != null) {
                    if (values.size() >= 1) continue;
                    return false;
                }
                this.add(node, values, child.getValue());
                continue;
            }
            if (child.isNode(Name.SCRIPT) || child.isNode(Name.STYLE) || this.build(child, values, decoder)) continue;
            return false;
        }
        return true;
    }

    private HTMLNode getAncestor(HTMLNode node, Name name) {
        for (HTMLNode current = node.getParent(); current != null; current = current.getParent()) {
            if (!current.isNode(name)) continue;
            return current;
        }
        return null;
    }

    private boolean validate(HTMLNode node) {
        for (Name name : this.ignores) {
            if (node.getName() != name) continue;
            return false;
        }
        return true;
    }

    private boolean isStyle(HTMLNode node) {
        if (node.getConfig().type() == Group.Fontstyle.class) {
            return true;
        }
        if (node.getConfig().type() == Group.Phrase.class) {
            return true;
        }
        for (Name name : this.styles) {
            if (node.getName() != name) continue;
            return false;
        }
        return false;
    }

    private void add(HTMLNode node, List<char[]> values, char[] chars) {
        int length = this.countWord(chars);
        if (values.size() > 0 && this.isEnd(values.get(values.size() - 1)) && length < 5) {
            return;
        }
        if (!this.isStyle(node) && !this.isEnd(chars)) {
            char[] nText = new char[chars.length + 1];
            System.arraycopy(chars, 0, nText, 0, nText.length - 1);
            nText[chars.length] = 46;
            chars = nText;
        }
        if (length < 11 && CharsUtil.indexOf(chars, this.month.toCharArray(), 0) > -1 && CharsUtil.indexOf(chars, this.year.toCharArray(), 0) > -1) {
            return;
        }
        values.add(chars);
    }

    private boolean isEnd(char[] text) {
        char c = text[text.length - 1];
        for (char ele : this.end) {
            if (c != ele) continue;
            return true;
        }
        return false;
    }

    private int countWord(char[] chars) {
        int count = 0;
        boolean preEmpty = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!preEmpty && Character.isSpaceChar(chars[i])) {
                ++count;
                preEmpty = true;
                continue;
            }
            preEmpty = false;
        }
        return count;
    }

    public void setIgnores(Name[] ignores) {
        this.ignores = ignores;
    }
}

