/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.bean.UIDataFeed;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/webui/core/UIVirtualList.gtmpl", events={@EventConfig(listeners={LoadNextActionListener.class})})
@Serialized
public class UIVirtualList
extends UIComponentDecorator {
    private int pageSize = 1;

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String event(String name, String beanId) throws Exception {
        UIComponent parent = this.getParent();
        return parent.event(name, beanId);
    }

    public void dataBind(PageList datasource) throws Exception {
        UIDataFeed dataFeed = this.getDataFeed();
        datasource.setPageSize(this.getPageSize());
        dataFeed.setDataSource(datasource);
    }

    public UIDataFeed getDataFeed() {
        try {
            return (UIDataFeed)this.uicomponent_;
        }
        catch (Exception e) {
            throw new NullPointerException("dataFeed doesn't attached");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoadNextActionListener
    extends EventListener<UIVirtualList> {
        public void execute(Event<UIVirtualList> event) throws Exception {
            UIVirtualList virtualList = (UIVirtualList)((Object)event.getSource());
            UIDataFeed dataFeed = virtualList.getDataFeed();
            WebuiRequestContext rContext = event.getRequestContext();
            try {
                dataFeed.feedNext();
            }
            catch (NoSuchDataException e) {
                event.getRequestContext().addUIComponentToUpdateByAjax(virtualList.getParent());
                return;
            }
            if (!dataFeed.hasNext()) {
                rContext.getJavascriptManager().addJavascript((CharSequence)("eXo.webui.UIVirtualList.loadFinished('" + virtualList.getId() + "');"));
            }
            rContext.getJavascriptManager().addJavascript((CharSequence)("eXo.webui.UIVirtualList.updateList('" + virtualList.getId() + "');"));
            rContext.addUIComponentToUpdateByAjax((UIComponent)dataFeed);
        }
    }
}

