/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.Utils;

public class CrossReference {
    private static final Logger logger = Logger.getLogger(CrossReference.class.toString());
    private Hashtable<Number, Entry> m_hObjectNumber2Entry = new Hashtable(4096);
    private PTrailer m_PTrailer;
    private CrossReference m_xrefPrevious;
    private CrossReference m_xrefPeer;
    private boolean m_bIsCrossReferenceTable;
    private boolean m_bHaveTriedLoadingPrevious;
    private boolean m_bHaveTriedLoadingPeer;

    public void setTrailer(PTrailer trailer) {
        this.m_PTrailer = trailer;
    }

    public void addXRefTableEntries(Parser parser) {
        this.m_bIsCrossReferenceTable = true;
        try {
            block2: while (true) {
                Object startingObjectNumberOrTrailer;
                if (!((startingObjectNumberOrTrailer = parser.getNumberOrStringWithMark(16)) instanceof Number)) {
                    parser.ungetNumberOrStringWithReset();
                    break;
                }
                int startingObjectNumber = ((Number)startingObjectNumberOrTrailer).intValue();
                int numEntries = ((Number)parser.getToken()).intValue();
                int currNumber = startingObjectNumber;
                int i = 0;
                while (true) {
                    if (i >= numEntries) continue block2;
                    long tenDigitNum = parser.getIntSurroundedByWhitespace();
                    int generationNum = parser.getIntSurroundedByWhitespace();
                    char usedOrFree = parser.getCharSurroundedByWhitespace();
                    if (usedOrFree == 'n') {
                        this.addUsedEntry(currNumber, tenDigitNum, generationNum);
                    } else if (usedOrFree == 'f') {
                        this.addFreeEntry(currNumber, (int)tenDigitNum, generationNum);
                    }
                    ++currNumber;
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error parsing xRef table entries.", e);
        }
    }

    public void addXRefStreamEntries(Library library, Hashtable xrefStreamHash, InputStream streamInput) {
        try {
            int size = library.getInt(xrefStreamHash, "Size");
            Vector<Integer> objNumAndEntriesCountPairs = (Vector<Integer>)library.getObject(xrefStreamHash, "Index");
            if (objNumAndEntriesCountPairs == null) {
                objNumAndEntriesCountPairs = new Vector<Integer>(2);
                objNumAndEntriesCountPairs.add(0);
                objNumAndEntriesCountPairs.add(size);
            }
            Vector fieldSizesVec = (Vector)library.getObject(xrefStreamHash, "W");
            int[] fieldSizes = null;
            if (fieldSizesVec != null) {
                fieldSizes = new int[fieldSizesVec.size()];
                for (int i = 0; i < fieldSizesVec.size(); ++i) {
                    fieldSizes[i] = ((Number)fieldSizesVec.get(i)).intValue();
                }
            }
            void fieldTypeSize = fieldSizes[0];
            int fieldTwoSize = fieldSizes[1];
            int fieldThreeSize = fieldSizes[2];
            for (int xrefSubsection = 0; xrefSubsection < objNumAndEntriesCountPairs.size(); xrefSubsection += 2) {
                int startingObjectNumber = ((Number)objNumAndEntriesCountPairs.get(xrefSubsection)).intValue();
                int entriesCount = ((Number)objNumAndEntriesCountPairs.get(xrefSubsection + 1)).intValue();
                int afterObjectNumber = startingObjectNumber + entriesCount;
                for (int objectNumber = startingObjectNumber; objectNumber < afterObjectNumber; ++objectNumber) {
                    int entryType = 1;
                    if (fieldTypeSize > 0) {
                        entryType = Utils.readIntWithVaryingBytesBE(streamInput, (int)fieldTypeSize);
                    }
                    if (entryType == 0) {
                        int nextFreeObjectNumber = Utils.readIntWithVaryingBytesBE(streamInput, fieldTwoSize);
                        int generationNumberIfReused = Utils.readIntWithVaryingBytesBE(streamInput, fieldThreeSize);
                        this.addFreeEntry(objectNumber, nextFreeObjectNumber, generationNumberIfReused);
                        continue;
                    }
                    if (entryType == 1) {
                        long filePositionOfObject = Utils.readLongWithVaryingBytesBE(streamInput, fieldTwoSize);
                        int generationNumber = 0;
                        if (fieldThreeSize > 0) {
                            generationNumber = Utils.readIntWithVaryingBytesBE(streamInput, fieldThreeSize);
                        }
                        this.addUsedEntry(objectNumber, filePositionOfObject, generationNumber);
                        continue;
                    }
                    if (entryType != 2) continue;
                    int objectNumberOfContainingObjectStream = Utils.readIntWithVaryingBytesBE(streamInput, fieldTwoSize);
                    int indexWithinObjectStream = Utils.readIntWithVaryingBytesBE(streamInput, fieldThreeSize);
                    this.addCompressedEntry(objectNumber, objectNumberOfContainingObjectStream, indexWithinObjectStream);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error parsing xRef stream entries.", e);
        }
    }

    public Entry getEntryForObject(Integer objectNumber) {
        Entry entry = this.m_hObjectNumber2Entry.get(objectNumber);
        if (entry != null) {
            return entry;
        }
        if (this.m_bIsCrossReferenceTable && !this.m_bHaveTriedLoadingPeer && this.m_xrefPeer == null && this.m_PTrailer != null) {
            this.m_PTrailer.loadXRefStmIfApplicable();
            this.m_xrefPeer = this.m_PTrailer.getCrossReferenceStream();
            this.m_bHaveTriedLoadingPeer = true;
        }
        if (this.m_xrefPeer != null && (entry = this.m_xrefPeer.getEntryForObject(objectNumber)) != null) {
            return entry;
        }
        if (!this.m_bHaveTriedLoadingPrevious && this.m_xrefPrevious == null && this.m_PTrailer != null) {
            this.m_PTrailer.onDemandLoadAndSetupPreviousTrailer();
            this.m_bHaveTriedLoadingPrevious = true;
        }
        if (this.m_xrefPrevious != null && (entry = this.m_xrefPrevious.getEntryForObject(objectNumber)) != null) {
            return entry;
        }
        return entry;
    }

    public void addToEndOfChainOfPreviousXRefs(CrossReference prev) {
        if (this.m_xrefPrevious == null) {
            this.m_xrefPrevious = prev;
        } else {
            this.m_xrefPrevious.addToEndOfChainOfPreviousXRefs(prev);
        }
    }

    protected void addFreeEntry(int objectNumber, int nextFreeObjectNumber, int generationNumberIfReused) {
        FreeEntry entry = new FreeEntry(objectNumber, nextFreeObjectNumber, generationNumberIfReused);
    }

    protected void addUsedEntry(int objectNumber, long filePositionOfObject, int generationNumber) {
        UsedEntry entry = new UsedEntry(objectNumber, filePositionOfObject, generationNumber);
        this.m_hObjectNumber2Entry.put(objectNumber, entry);
    }

    protected void addCompressedEntry(int objectNumber, int objectNumberOfContainingObjectStream, int indexWithinObjectStream) {
        CompressedEntry entry = new CompressedEntry(objectNumber, objectNumberOfContainingObjectStream, indexWithinObjectStream);
        this.m_hObjectNumber2Entry.put(objectNumber, entry);
    }

    public static class CompressedEntry
    extends Entry {
        private int m_iObjectNumberOfContainingObjectStream;
        private int m_iIndexWithinObjectStream;

        CompressedEntry(int objectNumber, int objectNumberOfContainingObjectStream, int indexWithinObjectStream) {
            super(2, objectNumber);
            this.m_iObjectNumberOfContainingObjectStream = objectNumberOfContainingObjectStream;
            this.m_iIndexWithinObjectStream = indexWithinObjectStream;
        }

        public int getObjectNumberOfContainingObjectStream() {
            return this.m_iObjectNumberOfContainingObjectStream;
        }

        public int getIndexWithinObjectStream() {
            return this.m_iIndexWithinObjectStream;
        }
    }

    public static class UsedEntry
    extends Entry {
        private long m_lFilePositionOfObject;
        private int m_iGenerationNumber;

        UsedEntry(int objectNumber, long filePositionOfObject, int generationNumber) {
            super(1, objectNumber);
            this.m_lFilePositionOfObject = filePositionOfObject;
            this.m_iGenerationNumber = generationNumber;
        }

        public long getFilePositionOfObject() {
            return this.m_lFilePositionOfObject;
        }

        public int getGenerationNumber() {
            return this.m_iGenerationNumber;
        }
    }

    public static class FreeEntry
    extends Entry {
        private int m_iNextFreeObjectNumber;
        private int m_iGenerationNumberIfReused;

        FreeEntry(int objectNumber, int nextFreeObjectNumber, int generationNumberIfReused) {
            super(0, objectNumber);
            this.m_iNextFreeObjectNumber = nextFreeObjectNumber;
            this.m_iGenerationNumberIfReused = generationNumberIfReused;
        }

        public int getNextFreeObjectNumber() {
            return this.m_iNextFreeObjectNumber;
        }

        public int getGenerationNumberIfReused() {
            return this.m_iGenerationNumberIfReused;
        }
    }

    public static class Entry {
        public static final int TYPE_FREE = 0;
        public static final int TYPE_USED = 1;
        public static final int TYPE_COMPRESSED = 2;
        private int m_iType;
        private int m_iObjectNumber;

        Entry(int type, int objectNumber) {
            this.m_iType = type;
            this.m_iObjectNumber = objectNumber;
        }

        int getType() {
            return this.m_iType;
        }

        int getObjectNumber() {
            return this.m_iObjectNumber;
        }
    }
}

