/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.CountingOutputStream;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalUpdater {
    private static final Logger logger = Logger.getLogger(IncrementalUpdater.class.getName());
    private static final boolean PRETTY = false;
    private static final byte[] SPACE = " ".getBytes();
    private static final byte[] NEWLINE = "\r\n".getBytes();
    private static final byte[] TRUE = "true".getBytes();
    private static final byte[] FALSE = "false".getBytes();
    private static final byte[] NAME = "/".getBytes();
    private static final byte[] REFERENCE = "R".getBytes();
    private static final byte[] LITERAL_STRING_ESCAPE = "\\".getBytes();
    private static final byte[] BEGIN_OBJECT = "obj\r\n".getBytes();
    private static final byte[] END_OBJECT = "\r\nendobj\r\n".getBytes();
    private static final byte[] BEGIN_DICTIONARY = "<<".getBytes();
    private static final byte[] END_DICTIONARY = ">>".getBytes();
    private static final byte[] BEGIN_ARRAY = "[".getBytes();
    private static final byte[] END_ARRAY = "]".getBytes();
    private static final byte[] BEGIN_LITERAL_STRING = "(".getBytes();
    private static final byte[] END_LITERAL_STRING = ")".getBytes();
    private static final byte[] BEGIN_HEX_STRING = "<".getBytes();
    private static final byte[] END_HEX_STRING = ">".getBytes();
    private static final byte[] XREF = "xref\r\n".getBytes();
    private static final byte[] TRAILER = "trailer\r\n".getBytes();
    private static final byte[] STARTXREF = "\r\n\r\nstartxref\r\n".getBytes();
    private static final byte[] COMMENT_EOF = "\r\n%%EOF\r\n".getBytes();
    private CountingOutputStream output;
    private long startingPosition;
    private long xrefPosition;
    private ArrayList<Entry> entries;

    public static long appendIncrementalUpdate(Document document, OutputStream out, long documentLength) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            if (document.getStateManager().isChanged()) {
                logger.fine("Have changes, will append incremental update");
            } else {
                logger.fine("No changes, will not append incremental update");
            }
        }
        if (!document.getStateManager().isChanged()) {
            return 0L;
        }
        IncrementalUpdater updater = new IncrementalUpdater(out, documentLength);
        updater.begin();
        Iterator<PObject> changes = document.getStateManager().iteratorSortedByObjectNumber();
        while (changes.hasNext()) {
            PObject pobject = changes.next();
            updater.writeObject(pobject.getReference(), pobject.getObject());
        }
        updater.writeXRefTable();
        updater.writeTrailer(document.getStateManager().getTrailer());
        return updater.getIncrementalUpdateLength();
    }

    private IncrementalUpdater(OutputStream out, long sp) {
        this.output = new CountingOutputStream(out);
        this.startingPosition = sp;
        this.entries = new ArrayList(32);
    }

    private void begin() throws IOException {
        this.output.write(NEWLINE);
    }

    private void writeObject(Reference ref, Object obj) throws IOException {
        if (obj instanceof Dictionary) {
            this.writeObjectDictionary((Dictionary)obj);
        } else {
            this.writeObjectValue(ref, obj);
        }
    }

    private void writeXRefTable() throws IOException {
        int nextDeletedObjectNumber = 0;
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            Entry entry = this.entries.get(i);
            if (!entry.isDeleted()) continue;
            entry.setNextDeletedObjectNumber(nextDeletedObjectNumber);
            nextDeletedObjectNumber = entry.getReference().getObjectNumber();
        }
        Entry zero = new Entry(new Reference(0, 65534));
        zero.setNextDeletedObjectNumber(nextDeletedObjectNumber);
        this.entries.add(0, zero);
        this.output.write(NEWLINE);
        this.xrefPosition = this.startingPosition + this.output.getCount();
        this.output.write(XREF);
        for (int i = 0; i < this.entries.size(); i += this.writeXrefSubSection(i)) {
        }
        this.output.write(NEWLINE);
    }

    private int writeXrefSubSection(int beginIndex) throws IOException {
        int beginObjNum = this.entries.get(beginIndex).getReference().getObjectNumber();
        int nextContiguous = beginObjNum + 1;
        for (int i = beginIndex + 1; i < this.entries.size() && this.entries.get(i).getReference().getObjectNumber() == nextContiguous; ++nextContiguous, ++i) {
        }
        int subSectionLength = nextContiguous - beginObjNum;
        this.writeInteger(beginObjNum);
        this.output.write(SPACE);
        this.writeInteger(subSectionLength);
        this.output.write(NEWLINE);
        for (int i = beginIndex; i < beginIndex + subSectionLength; ++i) {
            Entry entry = this.entries.get(i);
            if (entry.isDeleted()) {
                this.writeZeroPaddedLong(entry.getNextDeletedObjectNumber(), 10);
                this.output.write(32);
                this.writeZeroPaddedLong(entry.getReference().getGenerationNumber() + 1, 5);
                this.output.write(32);
                this.output.write(102);
                this.output.write(13);
                this.output.write(10);
                continue;
            }
            this.writeZeroPaddedLong(entry.getPosition(), 10);
            this.output.write(32);
            this.writeZeroPaddedLong(entry.getReference().getGenerationNumber(), 5);
            this.output.write(32);
            this.output.write(110);
            this.output.write(13);
            this.output.write(10);
        }
        return subSectionLength;
    }

    private void writeTrailer(PTrailer prevTrailer) throws IOException {
        Hashtable newTrailer = (Hashtable)prevTrailer.getDictionary().clone();
        int oldSize = prevTrailer.getNumberOfObjects();
        int greatestWritten = this.getGreatestObjectNumberWritten();
        int newSize = Math.max(oldSize, greatestWritten + 1);
        newTrailer.put(new Name("Size"), new Integer(newSize));
        long prevTrailerPos = prevTrailer.getPosition();
        newTrailer.put(new Name("Prev"), new Long(prevTrailerPos));
        long xrefPos = this.xrefPosition;
        if (prevTrailerPos == 0L) {
            xrefPos = -1L;
        }
        this.output.write(TRAILER);
        this.writeDictionary(newTrailer);
        this.output.write(STARTXREF);
        this.writeLong(xrefPos);
        this.output.write(NEWLINE);
        this.output.write(COMMENT_EOF);
    }

    private void flush() throws IOException {
        this.output.flush();
    }

    private long getIncrementalUpdateLength() {
        return this.output.getCount();
    }

    private void writeObjectDictionary(Dictionary obj) throws IOException {
        logger.log(Level.FINER, "writeObjectDictionary()  obj: {0}", obj);
        if (obj == null) {
            throw new IllegalArgumentException("Object must be non-null");
        }
        Reference ref = obj.getPObjectReference();
        logger.log(Level.FINER, "writeObjectDictionary()  ref: {0}", ref);
        if (ref == null) {
            throw new IllegalArgumentException("Reference must be non-null for object: " + obj);
        }
        if (obj.isDeleted()) {
            this.addEntry(new Entry(ref));
            return;
        }
        this.addEntry(new Entry(ref, this.startingPosition + this.output.getCount()));
        this.writeInteger(ref.getObjectNumber());
        this.output.write(SPACE);
        this.writeInteger(ref.getGenerationNumber());
        this.output.write(SPACE);
        this.output.write(BEGIN_OBJECT);
        this.writeDictionary(obj);
        this.output.write(END_OBJECT);
    }

    private void writeObjectValue(Reference ref, Object obj) throws IOException {
        logger.log(Level.FINER, "writeObjectValue()  obj: {0}", obj);
        if (ref == null) {
            throw new IllegalArgumentException("Reference must be non-null for object: " + obj);
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object must be non-null");
        }
        this.addEntry(new Entry(ref, this.startingPosition + this.output.getCount()));
        this.writeInteger(ref.getObjectNumber());
        this.output.write(SPACE);
        this.writeInteger(ref.getGenerationNumber());
        this.output.write(SPACE);
        this.output.write(BEGIN_OBJECT);
        this.writeValue(obj);
        this.output.write(END_OBJECT);
    }

    private void writeDictionary(Dictionary dict) throws IOException {
        logger.log(Level.FINER, "writeDictionary()  dict: {0}", dict);
        try {
            this.writeDictionary(dict.getEntries());
        }
        catch (IllegalArgumentException e) {
            String dictString = dict.getPObjectReference() != null ? dict.getPObjectReference().toString() : dict.toString();
            throw new IllegalArgumentException(e.getMessage() + " in dictionary: " + dictString, e);
        }
    }

    private void writeDictionary(Hashtable<Object, Object> dictEntries) throws IOException {
        logger.log(Level.FINER, "writeDictionary()  dictEntries: {0}", dictEntries);
        this.output.write(BEGIN_DICTIONARY);
        Enumeration<Object> keys = dictEntries.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = dictEntries.get(key);
            this.writeName(key.toString());
            this.output.write(SPACE);
            try {
                this.writeValue(val);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(e.getMessage() + " for key: " + key, e);
            }
            this.output.write(SPACE);
        }
        this.output.write(END_DICTIONARY);
    }

    private void writeValue(Object val) throws IOException {
        if (val == null) {
            this.writeByteString("null");
        } else if (val instanceof Name) {
            this.writeName((Name)val);
        } else if (val instanceof Reference) {
            this.writeReference((Reference)val);
        } else if (val instanceof Boolean) {
            this.writeBoolean((Boolean)val);
        } else if (val instanceof Integer) {
            this.writeInteger((Integer)val);
        } else if (val instanceof Long) {
            this.writeLong((Long)val);
        } else if (val instanceof Number) {
            this.writeReal((Number)val);
        } else {
            if (val instanceof String) {
                logger.severe("Found invalid java.lang.String being written out: " + val.toString());
                throw new IllegalArgumentException("invalid type of java.lang.String. Should use LiteralStringObject or HexStringObject");
            }
            if (val instanceof LiteralStringObject) {
                this.writeLiteralString((LiteralStringObject)val);
            } else if (val instanceof HexStringObject) {
                this.writeHexString((HexStringObject)val);
            } else if (val instanceof Vector) {
                this.writeArray((Vector)val);
            } else if (val instanceof Dictionary) {
                this.writeDictionary((Dictionary)val);
            } else if (val instanceof Hashtable) {
                this.writeDictionary((Hashtable)val);
            } else {
                throw new IllegalArgumentException("unknown value type of: " + val.getClass().getName());
            }
        }
    }

    private void writeName(Name name) throws IOException {
        this.writeName(name.getName());
    }

    private void writeName(String name) throws IOException {
        byte[] bytes;
        this.output.write(NAME);
        int pound = 35;
        for (int n : bytes = name.getBytes("UTF-8")) {
            if ((n &= 0xFF) == 35 || n < 33 || n > 126) {
                this.output.write(35);
                int hexVal = n >> 4 & 0xF;
                int hexDigit = hexVal + (hexVal >= 10 ? 65 : 48);
                this.output.write(hexDigit);
                hexVal = n & 0xF;
                hexDigit = hexVal + (hexVal >= 10 ? 65 : 48);
                this.output.write(hexDigit);
                continue;
            }
            this.output.write(n);
        }
    }

    private void writeReference(Reference ref) throws IOException {
        this.writeInteger(ref.getObjectNumber());
        this.output.write(SPACE);
        this.writeInteger(ref.getGenerationNumber());
        this.output.write(SPACE);
        this.output.write(REFERENCE);
    }

    private void writeArray(Vector array) throws IOException {
        this.output.write(BEGIN_ARRAY);
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            this.writeValue(array.get(i));
            if (i >= size - 1) continue;
            this.output.write(SPACE);
        }
        this.output.write(END_ARRAY);
    }

    private void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.output.write(TRUE);
        } else {
            this.output.write(FALSE);
        }
    }

    private void writeInteger(int i) throws IOException {
        String str = Integer.toString(i);
        this.writeByteString(str);
    }

    private void writeLong(long i) throws IOException {
        String str = Long.toString(i);
        this.writeByteString(str);
    }

    private void writeReal(float r) throws IOException {
        String str = Float.toString(r);
        this.writeByteString(str);
    }

    private void writeReal(Number r) throws IOException {
        String str = r.toString();
        this.writeByteString(str);
    }

    private void writeLiteralString(LiteralStringObject lso) throws IOException {
        this.output.write(BEGIN_LITERAL_STRING);
        this.writeByteString(lso.getLiteralString());
        this.output.write(END_LITERAL_STRING);
    }

    private void writeHexString(HexStringObject hso) throws IOException {
        this.output.write(BEGIN_HEX_STRING);
        this.writeByteString(hso.getHexString());
        this.output.write(END_HEX_STRING);
    }

    private void writeByteString(String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int val = str.charAt(i) & 0xFF;
            this.output.write(val);
        }
    }

    private void writeZeroPaddedLong(long val, int len) throws IOException {
        String str = Long.toString(val);
        if (str.length() > len) {
            str = str.substring(str.length() - len);
        }
        int padding = len - str.length();
        for (int i = 0; i < padding; ++i) {
            this.output.write(48);
        }
        this.writeByteString(str);
    }

    private void addEntry(Entry entry) {
        int index;
        int entryObjNum = entry.getReference().getObjectNumber();
        for (index = this.entries.size(); index > 0; --index) {
            Entry prev = this.entries.get(index - 1);
            int prevObjNum = prev.getReference().getObjectNumber();
            if (prevObjNum == entryObjNum) {
                throw new IllegalArgumentException("Multiple entries with same object number: " + entryObjNum);
            }
            if (prevObjNum < entryObjNum) break;
        }
        this.entries.add(index, entry);
    }

    private int getGreatestObjectNumberWritten() {
        return this.entries.isEmpty() ? 0 : this.entries.get(this.entries.size() - 1).getReference().getObjectNumber();
    }

    private static class Entry {
        private static final long POSITION_DELETED = -1L;
        private Reference reference;
        private long position;
        private int nextDeletedObjectNumber;

        Entry(Reference ref, long pos) {
            this.reference = ref;
            this.position = pos;
        }

        Entry(Reference ref) {
            this.reference = ref;
            this.position = -1L;
        }

        Reference getReference() {
            return this.reference;
        }

        boolean isDeleted() {
            return this.position == -1L;
        }

        long getPosition() {
            return this.position;
        }

        void setNextDeletedObjectNumber(int nextDelObjNum) {
            this.nextDeletedObjectNumber = nextDelObjNum;
        }

        int getNextDeletedObjectNumber() {
            return this.nextDeletedObjectNumber;
        }
    }
}

