/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIViewMetadataManager;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIViewMetadataForm
extends UIDialogForm {
    private String nodeType_;
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIViewMetadataForm");

    public UIViewMetadataForm() throws Exception {
        this.setActions(ACTIONS);
    }

    public void setNodeType(String nodeType) {
        this.nodeType_ = nodeType;
    }

    public String getNodeType() {
        return this.nodeType_;
    }

    public String getDialogTemplatePath() {
        this.repositoryName = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        try {
            return metadataService.getMetadataPath(this.nodeType_, true, this.repositoryName);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    public String getTemplate() {
        return this.getDialogTemplatePath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIViewMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIViewMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            UIViewMetadataForm uiForm = (UIViewMetadataForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIViewMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            UIViewMetadataForm uiForm = (UIViewMetadataForm)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UIViewMetadataManager uiViewManager = (UIViewMetadataManager)uiForm.getAncestorOfType(UIViewMetadataManager.class);
            Node node = uiViewManager.getViewNode(uiForm.getNodeType());
            NodeTypeManager ntManager = uiJCRExplorer.getSession().getWorkspace().getNodeTypeManager();
            PropertyDefinition[] props = ntManager.getNodeType(uiForm.getNodeType()).getPropertyDefinitions();
            ArrayList<Value> valueList = new ArrayList<Value>();
            for (PropertyDefinition prop : props) {
                UIFormInput uiInput;
                String name = prop.getName();
                String inputName = name.substring(name.indexOf(":") + 1);
                if (prop.isProtected()) continue;
                int requiredType = prop.getRequiredType();
                if (prop.isMultiple()) {
                    if (requiredType == 5) {
                        UIFormDateTimeInput uiFormDateTime = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                        valueList.add(uiJCRExplorer.getSession().getValueFactory().createValue(uiFormDateTime.getCalendar()));
                        node.setProperty(name, valueList.toArray(new Value[0]));
                        continue;
                    }
                    uiInput = uiForm.getUIInput(inputName);
                    if (uiInput instanceof UIFormSelectBox) {
                        String[] valuesReal = ((UIFormSelectBox)uiInput).getSelectedValues();
                        node.setProperty(name, valuesReal);
                        continue;
                    }
                    List values = ((UIFormMultiValueInputSet)uiInput).getValue();
                    node.setProperty(name, values.toArray(new String[values.size()]));
                    continue;
                }
                if (requiredType == 6) {
                    uiInput = uiForm.getUIInput(inputName);
                    String value = "false";
                    if (uiInput instanceof UIFormSelectBox) {
                        value = (String)((UIFormSelectBox)uiInput).getValue();
                    }
                    node.setProperty(name, Boolean.parseBoolean(value));
                    continue;
                }
                if (requiredType == 5) {
                    UIFormDateTimeInput cal = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                    node.setProperty(name, cal.getCalendar());
                    continue;
                }
                if (requiredType != 1) continue;
                String value = "";
                if (uiForm.getUIInput(inputName) != null && (value = (String)((UIFormStringInput)uiForm.getUIInput(inputName)).getValue()) == null) {
                    value = "";
                }
                node.setProperty(name, value);
            }
            node.getSession().save();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewManager);
            UIPopupWindow uiPopup = (UIPopupWindow)uiViewManager.getChildById("metadataForm");
            uiPopup.setShow(false);
        }
    }
}

