/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIConfirmMessage;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanDeleteNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={DeleteActionListener.class})})
public class DeleteManageComponent
extends UIAbstractManagerComponent {
    private static final Log LOG = ExoLogger.getLogger(DeleteManageComponent.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotLockedFilter(), new CanDeleteNodeFilter(), new IsNotTrashHomeNodeFilter(), new IsNotEditingDocumentFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private void processRemoveMultiple(String[] nodePaths, Event<?> event) throws Exception {
        Node node = null;
        String wsName = null;
        String nodePath = null;
        Session session = null;
        HashMap<String, Node> mapNode = new HashMap<String, Node>();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        for (int i = 0; i < nodePaths.length; ++i) {
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePaths[i]);
            if (matcher.find()) {
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                try {
                    session = uiExplorer.getSessionByWorkspace(wsName);
                    node = uiExplorer.getNodeByPath(nodePath, session, false);
                    session = node.getSession();
                    wsName = session.getWorkspace().getName();
                    mapNode.put(nodePath, node);
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                }
                continue;
            }
            throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
        }
        String path2 = null;
        for (String path2 : mapNode.keySet()) {
            this.processRemoveOrMoveToTrash(path2, (Node)mapNode.get(path2), event, true, true);
        }
    }

    private void removeMixins(Node node) throws Exception {
        NodeType[] mixins;
        for (NodeType nodeType : mixins = node.getMixinNodeTypes()) {
            node.removeMixin(nodeType.getName());
        }
    }

    private void processRemoveOrMoveToTrash(String nodePath, Node node, Event<?> event, boolean isMultiSelect, boolean checkToMoveToTrash) throws Exception {
        if (node.isNodeType("exo:restoreLocation") || !checkToMoveToTrash) {
            this.processRemoveNode(nodePath, node, event, isMultiSelect);
        } else {
            WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
            List categories = ((TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class)).getAllCategories(node);
            String parentPath = node.getParent().getPath();
            String parentRepo = node.getSession().getRepository().toString();
            String parentWSpace = node.getSession().getWorkspace().getName();
            wcmComposer.updateContent(parentRepo, parentWSpace, node.getPath(), new HashMap());
            boolean moveOK = this.moveToTrash(nodePath, node, event, isMultiSelect);
            if (moveOK) {
                for (Node categoryNode : categories) {
                    wcmComposer.updateContents(categoryNode.getSession().getRepository().toString(), categoryNode.getSession().getWorkspace().getName(), categoryNode.getPath(), new HashMap());
                }
                if (Utils.isReferenceable((Node)node)) {
                    wcmComposer.updateContent(parentRepo, parentWSpace, node.getUUID(), new HashMap());
                }
                wcmComposer.updateContents(parentRepo, parentWSpace, parentPath, new HashMap());
            }
        }
    }

    private boolean moveToTrash(String srcPath, Node node, Event<?> event, boolean isMultiSelect) throws Exception {
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        TrashService trashService = (TrashService)myContainer.getComponentInstanceOfType(TrashService.class);
        boolean ret = true;
        String virtualNodePath = srcPath;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return false;
        }
        try {
            if (node.isLocked()) {
                LockUtil.removeLock((Node)node);
                node.unlock();
            }
            if (node.getReferences().getSize() > 0L) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                uiExplorer.updateAjax(event);
                return false;
            }
            if (!node.isCheckedOut()) {
                throw new VersionException("node is locked, can't move to trash node :" + node.getPath());
            }
            if (!PermissionUtil.canRemoveNode((Node)node)) {
                throw new AccessDeniedException("access denied, can't move to trash node:" + node.getPath());
            }
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            String trashHomeNodePath = portletPref.getValue(Utils.TRASH_HOME_NODE_PATH, "");
            String trashWorkspace = portletPref.getValue(Utils.TRASH_WORKSPACE, "");
            String trashRepository = portletPref.getValue(Utils.TRASH_REPOSITORY, "");
            SessionProvider sessionProvider = uiExplorer.getSessionProvider();
            Node currentNode = uiExplorer.getCurrentNode();
            try {
                trashService.moveToTrash(node, trashHomeNodePath, trashWorkspace, trashRepository, sessionProvider);
            }
            catch (PathNotFoundException ex) {
                ret = false;
            }
            String currentPath = LinkUtils.getExistPath((Node)currentNode, (String)uiExplorer.getCurrentPath());
            uiExplorer.setCurrentPath(currentPath);
            uiExplorer.updateAjax(event);
        }
        catch (LockException e) {
            LOG.error((Object)("node is locked, can't move to trash node :" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (VersionException e) {
            LOG.error((Object)("node is checked in, can't move to trash node:" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (AccessDeniedException e) {
            LOG.error((Object)("access denied, can't add move to trash to node:" + node.getPath()));
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (Exception e) {
            LOG.error((Object)"an unexpected error occurs", (Throwable)e);
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            ret = false;
        }
        if (!isMultiSelect) {
            if (uiExplorer.getCurrentPath().equals(virtualNodePath)) {
                uiExplorer.setSelectNode(LinkUtils.getParentPath((String)virtualNodePath));
            } else {
                uiExplorer.setSelectNode(uiExplorer.getCurrentPath());
            }
        }
        return ret;
    }

    private void processRemoveNode(String nodePath, Node node, Event<?> event, boolean isMultiSelect) throws Exception {
        String virtualNodePath = nodePath;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node currentNode = uiExplorer.getCurrentNode();
        Session session = node.getSession();
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        TrashService trashService = (TrashService)this.getApplicationComponent(TrashService.class);
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        Node parentNode = node.getParent();
        uiExplorer.addLockToken(parentNode);
        try {
            TaxonomyService taxonomyService = (TaxonomyService)uiExplorer.getApplicationComponent(TaxonomyService.class);
            List listTaxonomyTrees = taxonomyService.getAllTaxonomyTrees(uiExplorer.getRepositoryName());
            List listExistedTaxonomy = taxonomyService.getAllCategories(node);
            block8: for (Node existedTaxonomy : listExistedTaxonomy) {
                for (Node taxonomyTrees : listTaxonomyTrees) {
                    if (!existedTaxonomy.getPath().contains(taxonomyTrees.getPath())) continue;
                    taxonomyService.removeCategory(node, taxonomyTrees.getName(), existedTaxonomy.getPath().substring(taxonomyTrees.getPath().length()));
                    continue block8;
                }
            }
            if (node.isNodeType("rma:record")) {
                this.removeMixins(node);
            }
            ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
            actionService.removeAction(node, uiExplorer.getRepositoryName());
            ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
            thumbnailService.processRemoveThumbnail(node);
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
            newFolksonomyService.removeTagsOfNodeRecursively(node, uiExplorer.getRepositoryName(), uiExplorer.getRepository().getConfiguration().getDefaultWorkspaceName(), node.getSession().getUserID(), this.getGroups());
            node.remove();
            parentNode.save();
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-verion-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ReferentialIntegrityException ref) {
            session.refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ConstraintViolationException cons) {
            session.refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LockException lockException) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked-other-person", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        if (!isMultiSelect) {
            if (currentNode.getPath().equals(virtualNodePath)) {
                uiExplorer.setSelectNode(LinkUtils.getParentPath((String)virtualNodePath));
            } else {
                uiExplorer.setSelectNode(currentNode.getPath());
            }
        }
    }

    private void processRemoveMultiple(String[] nodePaths, String[] wsNames, Event<?> event) throws Exception {
        for (int i = 0; i < nodePaths.length; ++i) {
            this.processRemove(nodePaths[i], wsNames[i], event, true);
        }
    }

    private void processRemove(String nodePath, String wsName, Event<?> event, boolean isMultiSelect) throws Exception {
        if (wsName == null) {
            wsName = this.getDefaultWorkspace();
        }
        this.doDelete(wsName.concat(":").concat(nodePath), event);
    }

    private String getDefaultWorkspace() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getCurrentDriveWorkspace();
    }

    public void doDelete(String nodePath, String wsName, Event<?> event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (nodePath.indexOf(";") > -1) {
            this.processRemoveMultiple(nodePath.split(";"), wsName.split(";"), event);
        } else {
            this.processRemove(nodePath, wsName, event, false);
        }
        uiExplorer.updateAjax(event);
        if (!uiExplorer.getPreference().isJcrEnable()) {
            uiExplorer.getSession().save();
        }
    }

    public void doDeleteWithoutTrash(String nodePath, Event<?> event) throws Exception {
        this.doDelete(nodePath, event, false);
    }

    public void doDelete(String nodePath, Event<?> event) throws Exception {
        this.doDelete(nodePath, event, true);
    }

    public void doDelete(String nodePath, Event<?> event, boolean checkToMoveToTrash) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (nodePath.indexOf(";") > -1) {
            this.processRemoveMultiple(nodePath.split(";"), event);
        } else {
            String wsName = null;
            Session session = null;
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
            UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
            if (matcher.find()) {
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                try {
                    session = uiExplorer.getSessionByWorkspace(wsName);
                    Node node = uiExplorer.getNodeByPath(nodePath, session, false);
                    session = node.getSession();
                    wsName = session.getWorkspace().getName();
                    node = uiExplorer.getNodeByPath(nodePath, session, false);
                    this.processRemoveOrMoveToTrash(nodePath, node, event, false, checkToMoveToTrash);
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    return;
                }
            }
        }
        uiExplorer.updateAjax(event);
        if (!uiExplorer.getPreference().isJcrEnable()) {
            uiExplorer.getSession().save();
        }
    }

    public static void deleteManage(Event<? extends UIComponent> event) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
        UIConfirmMessage uiConfirmMessage = (UIConfirmMessage)uiWorkingArea.createUIComponent(UIConfirmMessage.class, null, null);
        if (nodePath.indexOf(";") > -1) {
            uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete-multi");
            uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length)});
        } else {
            uiConfirmMessage.setMessageKey("UIWorkingArea.msg.confirm-delete");
            uiConfirmMessage.setArguments(new String[]{nodePath});
        }
        uiConfirmMessage.setNodePath(nodePath);
        UIPopupContainer2.activate((UIComponent)uiConfirmMessage, 500, 180);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
    }

    private String getGroups() throws Exception {
        StringBuilder ret = new StringBuilder();
        for (String group : Utils.getGroups()) {
            ret.append(group).append(';');
        }
        ret.deleteCharAt(ret.length() - 1);
        return ret.toString();
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends UIWorkingAreaActionListener<DeleteManageComponent> {
        public void processEvent(Event<DeleteManageComponent> event) throws Exception {
            DeleteManageComponent.deleteManage(event);
        }
    }
}

