/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletURLGenerationListener;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.portlet.impl.jsr168.api.BaseURLImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;

public class ResourceURLImpl
extends BaseURLImpl
implements javax.portlet.ResourceURL {
    private static final Map<String, CacheLevel> jsr168ToType = new HashMap<String, CacheLevel>();
    private static final Map<CacheLevel, String> typetoJSR168 = new HashMap<CacheLevel, String>();
    private final InternalResourceURL url;

    public static String toJSR168(CacheLevel cacheLevel) {
        return typetoJSR168.get(cacheLevel);
    }

    private ResourceURLImpl(PortletInvocation invocation, PortletRequestImpl preq, InternalResourceURL url, boolean filterable) {
        super(invocation, preq, filterable);
        this.url = url;
        if (invocation instanceof ResourceInvocation) {
            url.parentCacheLevel = ((ResourceInvocation)invocation).getCacheLevel();
        }
    }

    private ResourceURLImpl(ResourceURLImpl original) {
        super(original);
        this.url = new InternalResourceURL(original.url);
    }

    public void setResourceID(String resourceID) {
        if (resourceID != null) {
            this.url.id = resourceID;
        }
    }

    public String getCacheability() {
        CacheLevel cacheLevel = this.url.getCacheability();
        return typetoJSR168.get(cacheLevel);
    }

    public void setCacheability(String s) {
        CacheLevel cacheLevel = jsr168ToType.get(s);
        if (cacheLevel != null) {
            if (this.url.parentCacheLevel == null) {
                this.url.cacheLevel = cacheLevel;
            } else {
                if (CacheLevel.FULL == this.url.parentCacheLevel && cacheLevel != CacheLevel.FULL) {
                    throw new IllegalStateException();
                }
                if (CacheLevel.PORTLET == this.url.parentCacheLevel && cacheLevel == CacheLevel.PAGE) {
                    throw new IllegalStateException();
                }
                this.url.cacheLevel = cacheLevel;
            }
        } else {
            throw new IllegalArgumentException("Unknown cache level: " + s);
        }
    }

    protected BaseURLImpl.InternalContainerURL getContainerURL() {
        return this.url;
    }

    protected BaseURLImpl createClone() {
        return new ResourceURLImpl(this);
    }

    protected void filter(PortletURLGenerationListener listener) {
        listener.filterResourceURL((javax.portlet.ResourceURL)this);
    }

    public static ResourceURLImpl createResourceURL(PortletInvocation invocation, PortletRequestImpl preq) {
        return new ResourceURLImpl(invocation, preq, new InternalResourceURL(invocation.getNavigationalState(), invocation.getMode(), invocation.getWindowState()), true);
    }

    static {
        jsr168ToType.put("cacheLevelFull", CacheLevel.FULL);
        jsr168ToType.put("cacheLevelPage", CacheLevel.PAGE);
        jsr168ToType.put("cacheLevelPortlet", CacheLevel.PORTLET);
        typetoJSR168.put(CacheLevel.FULL, "cacheLevelFull");
        typetoJSR168.put(CacheLevel.PAGE, "cacheLevelPage");
        typetoJSR168.put(CacheLevel.PORTLET, "cacheLevelPortlet");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalResourceURL
    extends BaseURLImpl.InternalContainerURL
    implements ResourceURL {
        private String id;
        private CacheLevel parentCacheLevel;
        private CacheLevel cacheLevel;
        private ParametersStateString parameters;
        private final StateString navigationalState;
        private final Mode mode;
        private final WindowState windowState;

        private InternalResourceURL(StateString navigationalState, Mode mode, WindowState windowState) {
            this.parameters = ParametersStateString.create();
            this.navigationalState = navigationalState;
            this.mode = mode;
            this.windowState = windowState;
        }

        private InternalResourceURL(InternalResourceURL original) {
            this.id = original.id;
            this.parentCacheLevel = original.parentCacheLevel;
            this.cacheLevel = original.cacheLevel;
            this.parameters = ParametersStateString.create((Map)ParameterMap.clone((Map)original.parameters.getParameters()));
            this.navigationalState = original.navigationalState;
            this.mode = original.mode;
            this.windowState = original.windowState;
        }

        @Override
        protected void setParameter(String name, String value) {
            this.parameters.setValue(name, value);
        }

        @Override
        protected void setParameter(String name, String[] values) {
            this.parameters.setValues(name, values);
        }

        @Override
        protected void setParameters(Map<String, String[]> parameterMap) {
            this.parameters.replace(parameterMap);
        }

        @Override
        protected Map<String, String[]> getParameters() {
            return this.parameters.getParameters();
        }

        public StateString getResourceState() {
            return this.parameters;
        }

        public String getResourceId() {
            return this.id;
        }

        public CacheLevel getCacheability() {
            if (this.cacheLevel != null) {
                return this.cacheLevel;
            }
            if (this.parentCacheLevel != null) {
                return this.parentCacheLevel;
            }
            return CacheLevel.PAGE;
        }

        public StateString getNavigationalState() {
            return this.navigationalState;
        }

        public Mode getMode() {
            return this.mode;
        }

        public WindowState getWindowState() {
            return this.windowState;
        }
    }
}

