/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.idm.IDMUserListAccess;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.impl.UserImpl;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.SimpleAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDAOImpl
implements UserHandler {
    private static Logger log = LoggerFactory.getLogger(UserDAOImpl.class);
    private final PicketLinkIDMService service_;
    private List<UserEventListener> listeners_ = new ArrayList<UserEventListener>(3);
    public static final String USER_PASSWORD = "password";
    public static final String USER_FIRST_NAME = "firstName";
    public static final String USER_LAST_NAME = "lastName";
    public static final String USER_EMAIL = "email";
    public static final String USER_CREATED_DATE = "createdDate";
    public static final String USER_LAST_LOGIN_TIME = "lastLoginTime";
    public static final String USER_ORGANIZATION_ID = "organizationId";
    public static final Set<String> USER_NON_PROFILE_KEYS;
    public static final DateFormat dateFormat;
    private PicketLinkIDMOrganizationServiceImpl orgService;

    public UserDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService idmService) throws Exception {
        this.service_ = idmService;
        this.orgService = orgService;
    }

    public final List getUserEventListeners() {
        return this.listeners_;
    }

    public void addUserEventListener(UserEventListener listener) {
        this.listeners_.add(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "createUser", new Object[]{"user", user, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, true);
        }
        try {
            session.getPersistenceManager().createUser(user.getUserName());
        }
        catch (IdentityException e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        this.persistUserInfo(user, session);
        if (broadcast) {
            this.postSave(user, true);
        }
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "saveUser", new Object[]{"user", user, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, false);
        }
        this.persistUserInfo(user, session);
        if (broadcast) {
            this.postSave(user, false);
        }
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "removeUser", new Object[]{"userName", userName, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        org.picketlink.idm.api.User foundUser = null;
        try {
            foundUser = session.getPersistenceManager().findUser(userName);
        }
        catch (IdentityException e) {
            log.info((Object)("Cannot obtain user: " + userName + "; "), (Throwable)e);
        }
        if (foundUser == null) {
            return null;
        }
        try {
            this.orgService.getMembershipHandler().removeMembershipByUser(userName, false);
            this.orgService.getUserProfileHandler().removeUserProfile(userName, false);
        }
        catch (Exception e) {
            log.info((Object)("Cannot cleanup user relationships: " + userName + "; "), (Throwable)e);
        }
        User exoUser = UserDAOImpl.getPopulatedUser(userName, session);
        if (broadcast) {
            this.preDelete(exoUser);
        }
        try {
            session.getPersistenceManager().removeUser(foundUser, true);
        }
        catch (IdentityException e) {
            log.info((Object)("Cannot remove user: " + userName + "; "), (Throwable)e);
        }
        if (broadcast) {
            this.postDelete(exoUser);
        }
        return exoUser;
    }

    public User findUserByName(String userName) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findUserByName", new Object[]{"userName", userName});
        }
        IdentitySession session = this.service_.getIdentitySession();
        User user = UserDAOImpl.getPopulatedUser(userName, session);
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findUserByName", user);
        }
        return user;
    }

    public LazyPageList getUserPageList(int pageSize) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getUserPagetList", new Object[]{"pageSize", pageSize});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        return new LazyPageList((ListAccess)new IDMUserListAccess(this, this.service_, qb, pageSize, true), pageSize);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(String username, String password) throws Exception {
        User user;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "authenticate", new Object[]{"userName", username, USER_PASSWORD, "****"});
        }
        if ((user = this.findUserByName(username)) == null) {
            if (log.isTraceEnabled()) {
                Tools.logMethodOut(log, LogLevel.TRACE, "authenticate", false);
            }
            return false;
        }
        boolean authenticated = false;
        if (this.orgService.getConfiguration().isPasswordAsAttribute()) {
            authenticated = user.getPassword().equals(password);
        } else {
            try {
                IdentitySession session = this.service_.getIdentitySession();
                org.picketlink.idm.api.User idmUser = session.getPersistenceManager().findUser(user.getUserName());
                authenticated = session.getAttributesManager().validatePassword(idmUser, password);
            }
            catch (Exception e) {
                log.info((Object)("Cannot authenticate user: " + username + "; "), (Throwable)e);
            }
        }
        if (authenticated) {
            UserImpl userImpl = (UserImpl)user;
            userImpl.setLastLoginTime(Calendar.getInstance().getTime());
            this.saveUser((User)userImpl, false);
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "authenticate", authenticated);
        }
        return authenticated;
    }

    public LazyPageList findUsers(Query q) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findUsers", new Object[]{"q", q});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        if (q.getUserName() != null) {
            qb.idFilter(q.getUserName());
        }
        if (q.getEmail() != null) {
            qb.attributeValuesFilter(USER_EMAIL, new String[]{q.getEmail()});
        }
        if (q.getFirstName() != null) {
            qb.attributeValuesFilter(USER_FIRST_NAME, new String[]{q.getFirstName()});
        }
        if (q.getLastName() != null) {
            qb.attributeValuesFilter(USER_LAST_NAME, new String[]{q.getLastName()});
        }
        return new LazyPageList((ListAccess)new IDMUserListAccess(this, this.service_, qb, 20, false), 20);
    }

    public ListAccess<User> findUsersByQuery(Query query) throws Exception {
        throw new UnsupportedOperationException();
    }

    public LazyPageList findUsersByGroup(String groupId) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findUsersByGroup", new Object[]{"groupId", groupId});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        Group jbidGroup = null;
        try {
            jbidGroup = this.orgService.getJBIDMGroup(groupId);
        }
        catch (Exception e) {
            log.info((Object)("Cannot obtain group: " + groupId + "; "), (Throwable)e);
        }
        qb.addRelatedGroup(jbidGroup);
        return new LazyPageList((ListAccess)new IDMUserListAccess(this, this.service_, qb, 20, false), 20);
    }

    public User findUserByEmail(String email) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findUserByEmail", new Object[]{"findUserByEmail", email});
        }
        IdentitySession session = this.service_.getIdentitySession();
        org.picketlink.idm.api.User plUser = null;
        try {
            plUser = session.getAttributesManager().findUserByUniqueAttribute(USER_EMAIL, (Object)email);
        }
        catch (IdentityException e) {
            log.info((Object)("Cannot find user by email: " + email + "; "), (Throwable)e);
        }
        UserImpl user = null;
        if (plUser != null) {
            user = new UserImpl(plUser.getId());
            UserDAOImpl.populateUser((User)user, session);
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findUserByEmail", user);
        }
        return user;
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        throw new UnsupportedOperationException();
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postDelete(user);
        }
    }

    public void persistUserInfo(User user, IdentitySession session) throws Exception {
        AttributesManager am = session.getAttributesManager();
        ArrayList<SimpleAttribute> attributes = new ArrayList<SimpleAttribute>();
        if (user.getCreatedDate() != null) {
            attributes.add(new SimpleAttribute(USER_CREATED_DATE, (Object)("" + user.getCreatedDate().getTime())));
        }
        if (user.getLastLoginTime() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_LOGIN_TIME, (Object)("" + user.getLastLoginTime().getTime())));
        }
        if (user.getEmail() != null) {
            attributes.add(new SimpleAttribute(USER_EMAIL, (Object)user.getEmail()));
        }
        if (user.getFirstName() != null) {
            attributes.add(new SimpleAttribute(USER_FIRST_NAME, (Object)user.getFirstName()));
        }
        if (user.getLastName() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_NAME, (Object)user.getLastName()));
        }
        if (user.getOrganizationId() != null) {
            attributes.add(new SimpleAttribute(USER_ORGANIZATION_ID, (Object)user.getOrganizationId()));
        }
        if (user.getPassword() != null) {
            if (this.orgService.getConfiguration().isPasswordAsAttribute()) {
                attributes.add(new SimpleAttribute(USER_PASSWORD, (Object)user.getPassword()));
            } else {
                try {
                    am.updatePassword(session.getPersistenceManager().findUser(user.getUserName()), user.getPassword());
                }
                catch (IdentityException e) {
                    log.info((Object)("Cannot update password: " + user.getUserName() + "; "), (Throwable)e);
                }
            }
        }
        Attribute[] attrs = new Attribute[attributes.size()];
        attrs = attributes.toArray(attrs);
        try {
            am.updateAttributes(user.getUserName(), attrs);
        }
        catch (IdentityException e) {
            log.info((Object)("Cannot update attributes for user: " + user.getUserName() + "; "), (Throwable)e);
        }
    }

    public static User getPopulatedUser(String userName, IdentitySession session) throws Exception {
        org.picketlink.idm.api.User u = null;
        try {
            u = session.getPersistenceManager().findUser(userName);
        }
        catch (IdentityException e) {
            log.info((Object)("Cannot obtain user: " + userName + "; "), (Throwable)e);
        }
        if (u == null) {
            return null;
        }
        UserImpl user = new UserImpl(userName);
        UserDAOImpl.populateUser((User)user, session);
        return user;
    }

    public static void populateUser(User user, IdentitySession session) throws Exception {
        AttributesManager am = session.getAttributesManager();
        Map attrs = null;
        try {
            attrs = am.getAttributes(user.getUserName());
        }
        catch (IdentityException e) {
            log.info((Object)("Cannot obtain attributes for user: " + user.getUserName() + "; "), (Throwable)e);
        }
        if (attrs == null) {
            return;
        }
        if (attrs.containsKey(USER_CREATED_DATE)) {
            try {
                long date = Long.parseLong(((Attribute)attrs.get(USER_CREATED_DATE)).getValue().toString());
                user.setCreatedDate(new Date(date));
            }
            catch (NumberFormatException e) {
                try {
                    user.setCreatedDate(dateFormat.parse(((Attribute)attrs.get(USER_CREATED_DATE)).getValue().toString()));
                }
                catch (ParseException e2) {
                    log.error((Object)("Cannot parse the creation date for: " + user.getUserName()));
                }
            }
        }
        if (attrs.containsKey(USER_EMAIL)) {
            user.setEmail(((Attribute)attrs.get(USER_EMAIL)).getValue().toString());
        }
        if (attrs.containsKey(USER_FIRST_NAME)) {
            user.setFirstName(((Attribute)attrs.get(USER_FIRST_NAME)).getValue().toString());
        }
        if (attrs.containsKey(USER_LAST_LOGIN_TIME)) {
            try {
                Object lastLoginValue;
                Long lastLoginMillis = null;
                Attribute lastLoginAttr = (Attribute)attrs.get(USER_LAST_LOGIN_TIME);
                if (lastLoginAttr != null && (lastLoginValue = lastLoginAttr.getValue()) != null) {
                    lastLoginMillis = Long.parseLong(lastLoginValue.toString());
                }
                if (lastLoginMillis != null) {
                    user.setLastLoginTime(new Date(lastLoginMillis));
                }
            }
            catch (NumberFormatException e) {
                try {
                    user.setLastLoginTime(dateFormat.parse(((Attribute)attrs.get(USER_LAST_LOGIN_TIME)).getValue().toString()));
                }
                catch (ParseException e2) {
                    log.error((Object)("Cannot parse the last login date for: " + user.getUserName()));
                }
            }
        }
        if (attrs.containsKey(USER_LAST_NAME)) {
            user.setLastName(((Attribute)attrs.get(USER_LAST_NAME)).getValue().toString());
        }
        if (attrs.containsKey(USER_ORGANIZATION_ID)) {
            user.setOrganizationId(((Attribute)attrs.get(USER_ORGANIZATION_ID)).getValue().toString());
        }
        if (attrs.containsKey(USER_PASSWORD)) {
            user.setPassword(((Attribute)attrs.get(USER_PASSWORD)).getValue().toString());
        }
    }

    static {
        dateFormat = DateFormat.getInstance();
        HashSet<String> keys = new HashSet<String>();
        keys.add(USER_PASSWORD);
        keys.add(USER_FIRST_NAME);
        keys.add(USER_LAST_NAME);
        keys.add(USER_EMAIL);
        keys.add(USER_CREATED_DATE);
        keys.add(USER_LAST_LOGIN_TIME);
        keys.add(USER_ORGANIZATION_ID);
        USER_NON_PROFILE_KEYS = Collections.unmodifiableSet(keys);
    }
}

