/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleType<E> {
    public static final Base<String> PATH = new Base<String>(String.class){

        @Override
        public String toExternal(String s) {
            return s;
        }

        @Override
        public String toString(String s) {
            return s;
        }
    };
    public static final Base<Integer> PRIMITIVE_INTEGER = new Base<Integer>(Integer.TYPE){

        @Override
        public Integer toExternal(String s) {
            return Integer.parseInt(s);
        }

        @Override
        public String toString(Integer integer) {
            return Long.toString(integer.intValue());
        }
    };
    public static final Base<Boolean> PRIMITIVE_BOOLEAN = new Base<Boolean>(Boolean.TYPE){

        @Override
        public Boolean toExternal(String s) {
            return Boolean.parseBoolean(s);
        }

        @Override
        public String toString(Boolean b) {
            return Boolean.toString(b);
        }
    };
    public static final Base<Long> PRIMITIVE_LONG = new Base<Long>(Long.TYPE){

        @Override
        public Long toExternal(String s) {
            return Long.parseLong(s);
        }

        @Override
        public String toString(Long l) {
            return Long.toString(l);
        }
    };
    public static final Base<Double> PRIMITIVE_DOUBLE = new Base<Double>(Double.TYPE){

        @Override
        public Double toExternal(String s) {
            return Double.parseDouble(s);
        }

        @Override
        public String toString(Double d) {
            return Double.toString(d);
        }
    };
    public static final Base<Float> PRIMITIVE_FLOAT = new Base<Float>(Float.TYPE){

        @Override
        public Float toExternal(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }

        @Override
        public String toString(Float f) {
            return Float.toString(f.floatValue());
        }
    };
    public static final Base<Integer> INTEGER = new Base<Integer>(Integer.class){

        @Override
        public Integer toExternal(String s) {
            return Integer.parseInt(s);
        }

        @Override
        public String toString(Integer i) {
            return Long.toString(i.intValue());
        }
    };
    public static final Base<Boolean> BOOLEAN = new Base<Boolean>(Boolean.class){

        @Override
        public Boolean toExternal(String s) {
            return Boolean.parseBoolean(s);
        }

        @Override
        public String toString(Boolean b) {
            return Boolean.toString(b);
        }
    };
    public static final Base<Long> LONG = new Base<Long>(Long.class){

        @Override
        public Long toExternal(String s) {
            return Long.parseLong(s);
        }

        @Override
        public String toString(Long l) {
            return Long.toString(l);
        }
    };
    public static final Base<Double> DOUBLE = new Base<Double>(Double.class){

        @Override
        public Double toExternal(String s) {
            return Double.parseDouble(s);
        }

        @Override
        public String toString(Double d) {
            return Double.toString(d);
        }
    };
    public static final Base<Float> FLOAT = new Base<Float>(Float.class){

        @Override
        public Float toExternal(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }

        @Override
        public String toString(Float f) {
            return Double.toString(f.floatValue());
        }
    };
    public static final Base<String> STRING = new Base<String>(String.class){

        @Override
        public String toExternal(String s) {
            return s;
        }

        @Override
        public String toString(String s) {
            return s;
        }
    };
    public static final Base<InputStream> STREAM = new Base<InputStream>(InputStream.class){

        @Override
        public InputStream toExternal(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString(InputStream inputStream) {
            throw new UnsupportedOperationException();
        }
    };
    public static final Base<Date> DATE = new Base<Date>(Date.class){

        @Override
        public Date toExternal(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString(Date date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return sdf.format(date);
        }
    };
    private static final Map<String, Base<?>> builtin = new HashMap();

    private static void add(Base<?> type) {
        builtin.put(type.getRealType().getName(), type);
    }

    public static SimpleType<?> create(ClassTypeInfo type) {
        if (type.getKind() == ClassKind.ENUM) {
            return new Enumerated(type);
        }
        return builtin.get(type.getName());
    }

    public abstract E toExternal(String var1);

    public abstract String toString(E var1);

    static {
        SimpleType.add(PATH);
        SimpleType.add(PRIMITIVE_INTEGER);
        SimpleType.add(PRIMITIVE_BOOLEAN);
        SimpleType.add(PRIMITIVE_LONG);
        SimpleType.add(PRIMITIVE_DOUBLE);
        SimpleType.add(PRIMITIVE_FLOAT);
        SimpleType.add(INTEGER);
        SimpleType.add(BOOLEAN);
        SimpleType.add(LONG);
        SimpleType.add(DOUBLE);
        SimpleType.add(FLOAT);
        SimpleType.add(STRING);
        SimpleType.add(STREAM);
        SimpleType.add(DATE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Enumerated
    extends SimpleType<String> {
        private final ClassTypeInfo typeInfo;

        public Enumerated(ClassTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
        }

        public ClassTypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        @Override
        public String toExternal(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString(String e) {
            return e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Base<E>
    extends SimpleType<E> {
        private final Class<E> objectType;
        private final Class<?> realType;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Base(Class<?> realType) {
            void var2_8;
            if (realType.isPrimitive()) {
                if (realType == Integer.TYPE) {
                    Class<Integer> clazz = Integer.class;
                } else if (realType == Boolean.TYPE) {
                    Class<Boolean> clazz = Boolean.class;
                } else if (realType == Long.TYPE) {
                    Class<Long> clazz = Long.class;
                } else if (realType == Float.TYPE) {
                    Class<Float> clazz = Float.class;
                } else {
                    if (realType != Double.TYPE) throw new UnsupportedOperationException();
                    Class<Double> clazz = Double.class;
                }
            } else {
                Class<?> clazz = realType;
            }
            this.objectType = var2_8;
            this.realType = realType;
        }

        public boolean isPrimitive() {
            return this.realType.isPrimitive();
        }

        public Class<E> getObjectType() {
            return this.objectType;
        }

        public Class<?> getRealType() {
            return this.realType;
        }

        public String toString() {
            return "SimpleType.Base[objectType=" + this.objectType.getName() + ",realType=" + this.realType.getName() + "]";
        }
    }
}

