/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.publication.MessageDigester;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="composer"), @Property(key="type", value="content")})
@ManagedDescription(value="WCM Composer service")
@RESTEndpoint(path="wcmcomposerservice")
public class WCMComposerImpl
implements WCMComposer,
Startable {
    public static final String EXO_RESTORELOCATION = "exo:restoreLocation";
    private RepositoryService repositoryService;
    private LinkManager linkManager;
    private PublicationService publicationService;
    private TaxonomyService taxonomyService;
    private TemplateService templateService;
    private WCMService wcmService;
    private MultiLanguageService multiLanguageService;
    private ExoCache<String, Object> cache;
    private boolean isCached = true;
    private boolean useDefaultLanguage = true;
    private static Log log = ExoLogger.getLogger(WCMComposerImpl.class);
    private String templatesFilter;
    private List<String> usedOrderBy;
    private List<String> usedLanguages;
    private List<String> usedPrimaryTypes;

    public WCMComposerImpl(InitParams params) throws Exception {
        if (params != null) {
            ValueParam useDefaultLanguage;
            ValueParam useCache = params.getValueParam("useCache");
            if (useCache != null) {
                this.isCached = Boolean.parseBoolean(useCache.getValue());
            }
            if ((useDefaultLanguage = params.getValueParam("useDefaultLanguage")) != null) {
                this.useDefaultLanguage = Boolean.parseBoolean(useDefaultLanguage.getValue());
            }
        }
        this.repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        this.linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        this.publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        this.templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        this.wcmService = (WCMService)WCMCoreUtils.getService(WCMService.class);
        this.multiLanguageService = (MultiLanguageService)WCMCoreUtils.getService(MultiLanguageService.class);
        this.cache = ((CacheService)WCMCoreUtils.getService(CacheService.class)).getCacheInstance("wcm.composer");
        this.usedLanguages = new ArrayList<String>();
        this.usedLanguages.add(null);
        this.usedOrderBy = new ArrayList<String>();
        this.usedOrderBy.add(null);
        this.usedPrimaryTypes = new ArrayList<String>();
        this.usedPrimaryTypes.add(null);
    }

    @Override
    public Node getContent(String repository, String workspace, String nodeIdentifier, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        String hash;
        Node cachedNode;
        String mode = filters.get("filter-mode");
        String version = filters.get("filter-version");
        String language = filters.get("filter-language");
        String remoteUser = null;
        try {
            remoteUser = Util.getPortalRequestContext().getRemoteUser();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (repository == null && workspace == null) {
            String[] params = nodeIdentifier.split("/");
            repository = params[0];
            workspace = params[1];
            try {
                this.repositoryService.getRepository(repository);
                nodeIdentifier = nodeIdentifier.substring(repository.length() + workspace.length() + 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (nodeIdentifier.lastIndexOf("/") == 0) {
                nodeIdentifier = nodeIdentifier.substring(1);
            }
        }
        if ("Live".equals(mode) && this.isCached && (cachedNode = (Node)this.cache.get((Serializable)((Object)(hash = this.getHash(nodeIdentifier, version, remoteUser, language, null, null, null, null))))) != null) {
            return cachedNode;
        }
        Node node = null;
        try {
            node = this.wcmService.getReferencedContent(sessionProvider, repository, workspace, nodeIdentifier);
        }
        catch (RepositoryException e) {
            node = this.getNodeByCategory(nodeIdentifier);
        }
        if (version == null || !"base".equals(version)) {
            node = this.getViewableContent(node, filters);
        }
        if ("Live".equals(mode) && this.isCached) {
            String hash2 = this.getHash(nodeIdentifier, version, remoteUser, language, null, null, null, null);
            this.cache.put((Serializable)((Object)hash2), (Object)node);
        }
        return node;
    }

    @Override
    public List<Node> getContents(String repository, String workspace, String path, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        String hash;
        List cachedNodes;
        String mode = filters.get("filter-mode");
        String version = filters.get("filter-version");
        String orderBy = filters.get("filter-order-by");
        String orderType = filters.get("filter-order-type");
        String language = filters.get("filter-language");
        String recursive = filters.get("filter-recursive");
        String primaryType = filters.get("filter-primary-type");
        String remoteUser = null;
        try {
            remoteUser = Util.getPortalRequestContext().getRemoteUser();
        }
        catch (Exception e) {
            // empty catch block
        }
        if ("Edit".equals(mode) && "publication:liveDate".equals(orderBy)) {
            orderBy = "exo:dateModified";
            filters.put("filter-order-by", orderBy);
        }
        if ("Live".equals(mode) && "exo:title".equals(orderBy)) {
            orderBy = "exo:titlePublished " + orderType + ", exo:title";
            filters.put("filter-order-by", orderBy);
        }
        if ("Live".equals(mode) && this.isCached && (cachedNodes = (List)this.cache.get((Serializable)((Object)(hash = this.getHash(path, version, remoteUser, language, recursive, orderBy, orderType, primaryType))))) != null) {
            return cachedNodes;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("##### " + path + ":" + version + ":" + remoteUser + ":" + orderBy + ":" + orderType));
        }
        NodeIterator nodeIterator = this.getViewableContents(repository, workspace, path, filters, sessionProvider);
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node node = null;
        Node viewNode = null;
        while (nodeIterator != null && nodeIterator.hasNext()) {
            node = nodeIterator.nextNode();
            viewNode = this.getViewableContent(node, filters);
            if (viewNode == null) continue;
            nodes.add(viewNode);
        }
        if ("Live".equals(mode) && this.isCached) {
            String hash2 = this.getHash(path, version, remoteUser, language, recursive, orderBy, orderType, primaryType);
            this.cache.put((Serializable)((Object)hash2), nodes);
        }
        return nodes;
    }

    private NodeIterator getViewableContents(String repository, String workspace, String path, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        QueryManager manager = session.getWorkspace().getQueryManager();
        String orderBy = filters.get("filter-order-by");
        String orderFilter = this.getOrderSQLFilter(filters);
        String recursive = filters.get("filter-recursive");
        String primaryType = filters.get("filter-primary-type");
        String queryFilter = filters.get("filter-query");
        String queryFilterFull = filters.get("filter-query-full");
        StringBuffer statement = new StringBuffer();
        boolean filterTemplates = true;
        if (queryFilterFull != null) {
            statement.append(queryFilterFull);
        } else {
            this.addUsedPrimaryTypes(primaryType);
            if (primaryType == null) {
                primaryType = "nt:base";
                Node currentFolder = null;
                if ("/".equals(path)) {
                    currentFolder = session.getRootNode();
                } else if (session.getRootNode().hasNode(path.substring(1))) {
                    currentFolder = session.getRootNode().getNode(path.substring(1));
                } else {
                    return null;
                }
                if (currentFolder != null && currentFolder.isNodeType("exo:taxonomy")) {
                    primaryType = "exo:taxonomyLink";
                }
            } else {
                filterTemplates = false;
            }
            this.addUsedOrderBy(orderBy);
            statement.append("SELECT * FROM " + primaryType + " WHERE (jcr:path LIKE '" + path + "/%'");
            if (recursive == null || "false".equals(recursive)) {
                statement.append(" AND NOT jcr:path LIKE '" + path + "/%/%')");
            } else {
                statement.append(")");
            }
            if (filterTemplates) {
                statement.append(" AND " + this.getTemplatesSQLFilter(repository));
            }
            if (queryFilter != null) {
                statement.append(queryFilter);
            }
            statement.append(orderFilter);
        }
        Query query = manager.createQuery(statement.toString(), "sql");
        return query.execute().getNodes();
    }

    private Node getViewableContent(Node node, HashMap<String, String> filters) throws Exception {
        Node viewNode = null;
        try {
            node = this.getTargetNode(node);
        }
        catch (AccessDeniedException ade) {
            return null;
        }
        if (node != null && node.isNodeType(EXO_RESTORELOCATION)) {
            return null;
        }
        String languageFilter = filters.get("filter-language");
        if (languageFilter != null) {
            Node lnode;
            block9: {
                this.addUsedLanguage(languageFilter);
                lnode = null;
                try {
                    lnode = this.multiLanguageService.getLanguage(node, languageFilter);
                }
                catch (AccessDeniedException e) {
                    if (!log.isTraceEnabled()) break block9;
                    log.trace((Object)("AccessDenied on " + languageFilter + " translation for " + node.getPath()));
                }
            }
            if (lnode != null) {
                viewNode = this.getPublishedContent(lnode, filters);
                if (viewNode != null) {
                    return viewNode;
                }
                if (!this.useDefaultLanguage) {
                    return null;
                }
            }
        }
        viewNode = this.getPublishedContent(node, filters);
        return viewNode;
    }

    private Node getPublishedContent(Node node, HashMap<String, String> filters) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String mode = filters.get("filter-mode");
        context.put("filter-mode", mode);
        context.put("portlet-mode", filters.get("portlet-mode"));
        String lifecyleName = null;
        try {
            lifecyleName = this.publicationService.getNodeLifecycleName(node);
        }
        catch (NotInPublicationLifecycleException e) {
            // empty catch block
        }
        if (lifecyleName == null) {
            return node;
        }
        PublicationPlugin publicationPlugin = this.publicationService.getPublicationPlugins().get(lifecyleName);
        Node viewNode = publicationPlugin.getNodeView(node, context);
        return viewNode;
    }

    private Node getTargetNode(Node showingNode) throws Exception {
        Node targetNode = null;
        if (this.linkManager.isLink((Item)showingNode)) {
            try {
                targetNode = this.linkManager.getTarget(showingNode);
            }
            catch (ItemNotFoundException e) {
                targetNode = showingNode;
            }
        } else {
            targetNode = showingNode;
        }
        return targetNode;
    }

    @Override
    public boolean updateContent(String repository, String workspace, String path, HashMap<String, String> filters) throws Exception {
        if (this.isCached) {
            SessionProvider sessionProvider;
            String oid;
            String remoteUser;
            String part;
            String[] orderTypes;
            block17: {
                orderTypes = new String[]{null, "ASC", "DESC"};
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updateContent : " + path));
                }
                part = path.lastIndexOf("/") >= 0 ? path.substring(0, path.lastIndexOf("/")) : path;
                remoteUser = null;
                try {
                    remoteUser = Util.getPortalRequestContext().getRemoteUser();
                }
                catch (Exception e) {
                    // empty catch block
                }
                oid = null;
                sessionProvider = SessionProvider.createSystemProvider();
                try {
                    repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
                    Node node = this.wcmService.getReferencedContent(sessionProvider, repository, workspace, path);
                    if (node != null) {
                        if (node.isNodeType("mix:referenceable")) {
                            oid = node.getUUID();
                        }
                        this.updateContents(repository, workspace, part, filters);
                        this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
                        for (Node catnode : this.taxonomyService.getAllCategories(node)) {
                            this.updateContents(repository, catnode.getSession().getWorkspace().getName(), catnode.getPath(), filters);
                        }
                    }
                }
                catch (RepositoryException e) {
                    if (!log.isErrorEnabled()) break block17;
                    log.error((Object)("Can't find UUID for path : " + workspace + ":" + path));
                }
            }
            for (String lang : this.usedLanguages) {
                for (String recursive : new String[]{"true", "false"}) {
                    for (String orderBy : this.usedOrderBy) {
                        for (String orderType : orderTypes) {
                            for (String primaryType : this.usedPrimaryTypes) {
                                String hash = this.getHash(path, null, null, lang, null, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                hash = this.getHash(path, "base", null, lang, null, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                Node node = this.wcmService.getReferencedContent(sessionProvider, repository, workspace, path);
                                List<Node> listCategory = this.getCategories(node, repository);
                                List<Node> lstTaxonomyTrees = this.getAllTaxonomyTrees(repository);
                                if (listCategory != null && listCategory.size() > 0) {
                                    for (Node categoryNode : listCategory) {
                                        String value = this.displayCategory(categoryNode, lstTaxonomyTrees);
                                        if (value == null || value.equals("")) continue;
                                        value = value + "/" + node.getName();
                                        hash = this.getHash(value, filters.get("filter-version"), remoteUser, lang, null, orderBy, orderType, primaryType);
                                        this.cache.remove((Serializable)((Object)hash));
                                    }
                                }
                                hash = this.getHash(part, null, null, lang, recursive, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                if (oid != null) {
                                    hash = this.getHash(oid, null, null, lang, null, orderBy, orderType, primaryType);
                                    this.cache.remove((Serializable)((Object)hash));
                                }
                                if (remoteUser == null) continue;
                                hash = this.getHash(path, null, remoteUser, lang, null, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                hash = this.getHash(path, "base", remoteUser, lang, null, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                hash = this.getHash(part, null, remoteUser, lang, null, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                if (oid == null) continue;
                                hash = this.getHash(oid, null, remoteUser, lang, null, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    public List<Node> getCategories(Node node, String repository) throws Exception {
        if (this.taxonomyService == null) {
            this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
        }
        ArrayList<Node> listCategories = new ArrayList<Node>();
        List<Node> listNode = this.getAllTaxonomyTrees(repository);
        for (Node itemNode : listNode) {
            listCategories.addAll(this.taxonomyService.getCategories(node, itemNode.getName()));
        }
        return listCategories;
    }

    List<Node> getAllTaxonomyTrees(String repository) throws RepositoryException {
        if (this.taxonomyService == null) {
            this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
        }
        return this.taxonomyService.getAllTaxonomyTrees(repository);
    }

    String displayCategory(Node node, List<Node> taxonomyTrees) {
        block3: {
            try {
                for (Node taxonomyTree : taxonomyTrees) {
                    if (!node.getPath().contains(taxonomyTree.getPath())) continue;
                    return node.getPath().replace(taxonomyTree.getPath(), taxonomyTree.getName());
                }
            }
            catch (RepositoryException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Unexpected error when getting node taxonomies");
            }
        }
        return "";
    }

    @Override
    public boolean updateContents(String repository, String workspace, String path, HashMap<String, String> filters) throws Exception {
        if (this.isCached) {
            String[] orderTypes = new String[]{null, "ASC", "DESC"};
            String remoteUser = null;
            try {
                remoteUser = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateContents : " + path));
            }
            for (String lang : this.usedLanguages) {
                for (String recursive : new String[]{"true", "false"}) {
                    for (String orderBy : this.usedOrderBy) {
                        for (String orderType : orderTypes) {
                            for (String primaryType : this.usedPrimaryTypes) {
                                String hash = this.getHash(path, null, null, lang, recursive, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                hash = this.getHash(path, "base", null, lang, recursive, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                if (remoteUser == null) continue;
                                hash = this.getHash(path, null, remoteUser, lang, recursive, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                                hash = this.getHash(path, "base", remoteUser, lang, recursive, orderBy, orderType, primaryType);
                                this.cache.remove((Serializable)((Object)hash));
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    @Override
    public List<String> getAllowedStates(String mode) {
        ArrayList<String> states = new ArrayList<String>();
        if ("Live".equals(mode)) {
            states.add("published");
        } else if ("Edit".equals(mode)) {
            states.add("published");
            states.add("draft");
            states.add("pending");
            states.add("staged");
            states.add("approved");
        }
        return states;
    }

    @Override
    @Managed
    @ManagedDescription(value="Clean all templates in Composer")
    public void cleanTemplates() throws Exception {
        this.templatesFilter = null;
        this.getTemplatesSQLFilter("repository");
        if (log.isDebugEnabled()) {
            log.debug((Object)"WCMComposer templates have been cleaned !");
        }
    }

    @Override
    @Managed
    @ManagedDescription(value="Is the cache used ?")
    public boolean isCached() {
        return this.isCached;
    }

    @Managed
    @ManagedDescription(value="Use the default language if translation is not published ?")
    public boolean useDefaultLanguage() {
        return this.useDefaultLanguage;
    }

    @Managed
    @ManagedDescription(value="How many nodes in the cache ?")
    public int getCachedEntries() {
        return this.cache.getCacheSize();
    }

    @Managed
    @ManagedDescription(value="Activate/deactivate the composer cache ?")
    public void setCached(@ManagedDescription(value="Enable/Disable the cache ?") @ManagedName(value="isCached") boolean isCached) {
        this.isCached = isCached;
    }

    public void setDefaultLanguagePolicy(boolean useDefaultLanguage) {
        this.useDefaultLanguage = useDefaultLanguage;
    }

    @Managed
    @ManagedDescription(value="Used Languages")
    public List<String> getUsedLanguages() {
        return this.usedLanguages;
    }

    @Managed
    @ManagedDescription(value="Used Primary Types")
    public List<String> getUsedPrimaryTypes() {
        return this.usedPrimaryTypes;
    }

    @Managed
    @ManagedDescription(value="Used Order By")
    public List<String> getUsedOrderBy() {
        return this.usedOrderBy;
    }

    public void start() {
    }

    public void stop() {
    }

    private String getOrderSQLFilter(HashMap<String, String> filters) {
        String orderQuery = " ORDER BY ";
        String orderBy = filters.get("filter-order-by");
        String orderType = filters.get("filter-order-type");
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        orderQuery = orderQuery + orderBy + " " + orderType;
        return orderQuery;
    }

    private String getTemplatesSQLFilter(String repository) {
        if (this.templatesFilter != null) {
            return this.templatesFilter;
        }
        try {
            List documentTypes = this.templateService.getDocumentTemplates(repository);
            StringBuffer documentTypeClause = new StringBuffer("(");
            for (int i = 0; i < documentTypes.size(); ++i) {
                String documentType = (String)documentTypes.get(i);
                documentTypeClause.append("jcr:primaryType = '" + documentType + "'");
                if (i == documentTypes.size() - 1) continue;
                documentTypeClause.append(" OR ");
            }
            this.templatesFilter = documentTypeClause.toString();
            this.templatesFilter = this.templatesFilter + " OR jcr:primaryType = 'exo:taxonomyLink' OR jcr:primaryType = 'exo:symlink')";
            return this.templatesFilter;
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getTemlatesSQLFilter: ", (Throwable)e);
            return null;
        }
    }

    private Node getNodeByCategory(String parameters) throws Exception {
        try {
            String repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            if (this.taxonomyService == null) {
                this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
            }
            Node taxonomyTree = this.taxonomyService.getTaxonomyTree(repository, parameters.split("/")[0]);
            Node symlink = taxonomyTree.getNode(parameters.substring(parameters.indexOf("/") + 1));
            return this.linkManager.getTarget(symlink);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getHash(String path, String version, String remoteUser, String language, String recursive, String orderBy, String orderType, String primaryType) throws Exception {
        String key = path;
        if (version != null) {
            key = key + "::" + version;
        }
        if (remoteUser != null) {
            key = key + ";;" + remoteUser;
        }
        if (language != null) {
            key = key + ",," + language;
        }
        if (orderBy != null) {
            key = key + "??" + orderBy;
        }
        if (orderType != null) {
            key = key + "!!" + orderType;
        }
        if (primaryType != null) {
            key = key + "))" + primaryType;
        }
        return MessageDigester.getHash(key);
    }

    private void addUsedLanguage(String lang) {
        if (!this.usedLanguages.contains(lang)) {
            this.usedLanguages.add(lang);
        }
    }

    private void addUsedOrderBy(String orderBy) {
        if (!this.usedOrderBy.contains(orderBy)) {
            this.usedOrderBy.add(orderBy);
        }
    }

    private void addUsedPrimaryTypes(String primaryType) {
        if (!this.usedPrimaryTypes.contains(primaryType)) {
            this.usedPrimaryTypes.add(primaryType);
        }
    }
}

