/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipEventListenerHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.CacheHandler;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipDAOImpl
extends BaseDAO
implements MembershipHandler,
MembershipEventListenerHandler {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.MembershipDAOImpl");
    protected List<MembershipEventListener> listeners = new ArrayList<MembershipEventListener>(3);

    public MembershipDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, CacheHandler cacheHandler) throws Exception {
        super(ldapAttrMapping, ldapService, cacheHandler);
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        this.listeners.add(listener);
    }

    public final Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    public void createMembership(Membership m, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                Attributes attrs;
                String membershipDN;
                String userDN;
                block17: {
                    try {
                        block16: {
                            userDN = this.getDNFromUsername(ctx, m.getUserName());
                            String groupDN = this.getGroupDNFromGroupId(m.getGroupId());
                            membershipDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + m.getMembershipType() + "," + groupDN;
                            attrs = null;
                            try {
                                attrs = ctx.getAttributes(membershipDN);
                            }
                            catch (NameNotFoundException e) {
                                if (!LOG.isDebugEnabled()) break block16;
                                e.printStackTrace();
                            }
                        }
                        if (attrs != null) break block17;
                        if (broadcast) {
                            this.preSave(m, true);
                        }
                        ctx.createSubcontext(membershipDN, this.ldapAttrMapping.membershipToAttributes(m, userDN));
                        if (broadcast) {
                            this.postSave(m, true);
                        }
                        this.cacheHandler.put((Serializable)((Object)this.cacheHandler.getMembershipKey(m)), m, CacheHandler.CacheType.MEMBERSHIP);
                        return;
                    }
                    catch (NamingException e) {
                        ctx = this.reloadCtx(ctx, err, e);
                        ++err;
                        continue;
                    }
                }
                List<Object> members = this.getAttributes(attrs, this.ldapAttrMapping.membershipTypeMemberValue);
                if (members.contains(userDN)) {
                    return;
                }
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(this.ldapAttrMapping.membershipTypeMemberValue, userDN))};
                if (broadcast) {
                    this.preSave(m, true);
                }
                ctx.modifyAttributes(membershipDN, mods);
                if (broadcast) {
                    this.postSave(m, true);
                }
                this.cacheHandler.put((Serializable)((Object)this.cacheHandler.getMembershipKey(m)), m, CacheHandler.CacheType.MEMBERSHIP);
                return;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public void linkMembership(User user, Group group, MembershipType mt, boolean broadcast) throws Exception {
        if (group == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because group is null");
        }
        if (mt == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because membership type is null");
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setMembershipType(mt.getName());
        membership.setUserName(user.getUserName());
        membership.setGroupId(group.getId());
        this.createMembership((Membership)membership, broadcast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        String[] membershipParts = id.split(",");
        if (membershipParts.length < 3) {
            return null;
        }
        String username = membershipParts[0];
        String membershipType = membershipParts[1];
        String groupId = membershipParts[2];
        MembershipImpl m = new MembershipImpl();
        m.setGroupId(groupId);
        m.setId(id);
        m.setMembershipType(membershipType);
        m.setUserName(username);
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                block19: {
                    String membershipDN;
                    block18: {
                        String userDN;
                        try {
                            userDN = this.getDNFromUsername(ctx, username).trim();
                            String groupDN = this.getGroupDNFromGroupId(groupId);
                            membershipDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + membershipType + ", " + groupDN;
                            Attributes attrs = ctx.getAttributes(membershipDN);
                            List<Object> members = this.getAttributes(attrs, this.ldapAttrMapping.membershipTypeMemberValue);
                            boolean remove = false;
                            for (int i = 0; i < members.size(); ++i) {
                                if (!String.valueOf(members.get(i)).trim().equalsIgnoreCase(userDN)) continue;
                                remove = true;
                                break;
                            }
                            if (!remove) {
                                MembershipImpl i = m;
                                return i;
                            }
                            if (members.size() <= 1) break block18;
                        }
                        catch (NamingException e1) {
                            try {
                                ctx = this.reloadCtx(ctx, err, e1);
                                ++err;
                                continue;
                            }
                            catch (NameNotFoundException e2) {
                                if (LOG.isDebugEnabled()) {
                                    e2.printStackTrace();
                                }
                                Membership membership = null;
                                return membership;
                            }
                        }
                        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(this.ldapAttrMapping.membershipTypeMemberValue, userDN))};
                        if (broadcast) {
                            this.preSave((Membership)m, true);
                        }
                        ctx.modifyAttributes(membershipDN, mods);
                        if (broadcast) {
                            this.postSave((Membership)m, true);
                        }
                        this.cacheHandler.put((Serializable)((Object)this.cacheHandler.getMembershipKey((Membership)m)), m, CacheHandler.CacheType.MEMBERSHIP);
                        break block19;
                    }
                    if (broadcast) {
                        this.preDelete((Membership)m);
                    }
                    ctx.destroySubcontext(membershipDN);
                    if (broadcast) {
                        this.postDelete((Membership)m);
                    }
                    this.cacheHandler.remove((Serializable)((Object)this.cacheHandler.getMembershipKey((Membership)m)), CacheHandler.CacheType.MEMBERSHIP);
                }
                MembershipImpl membershipImpl = m;
                return membershipImpl;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection removeMembershipByUser(String username, boolean broadcast) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                ArrayList<MembershipImpl> arrayList;
                block15: {
                    memberships.clear();
                    try {
                        String userDN = this.getDNFromUsername(ctx, username);
                        String filter = this.ldapAttrMapping.membershipTypeMemberValue + "=" + MembershipDAOImpl.escapeDN(userDN);
                        SearchControls constraints = new SearchControls();
                        constraints.setSearchScope(2);
                        results = ctx.search(this.ldapAttrMapping.groupsURL, filter, constraints);
                        while (results.hasMoreElements()) {
                            SearchResult sr = results.next();
                            try {
                                Attributes attrs = sr.getAttributes();
                                String membershipDN = sr.getNameInNamespace();
                                Group group = this.getGroupFromMembershipDN(ctx, membershipDN);
                                String type = this.explodeDN(membershipDN, true)[0];
                                MembershipImpl membership = this.createMembershipObject(username, group.getId(), type);
                                memberships.add(membership);
                                if (attrs.get(this.ldapAttrMapping.membershipTypeMemberValue).size() > 1) {
                                    ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(this.ldapAttrMapping.membershipTypeMemberValue, userDN))};
                                    ctx.modifyAttributes(membershipDN, mods);
                                    this.cacheHandler.put((Serializable)((Object)this.cacheHandler.getMembershipKey((Membership)membership)), membership, CacheHandler.CacheType.MEMBERSHIP);
                                    continue;
                                }
                                ctx.destroySubcontext(membershipDN);
                                this.cacheHandler.remove((Serializable)((Object)this.cacheHandler.getMembershipKey((Membership)membership)), CacheHandler.CacheType.MEMBERSHIP);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        arrayList = memberships;
                        if (results == null) break block15;
                    }
                    catch (NamingException e2) {
                        try {
                            ctx = this.reloadCtx(ctx, err, e2);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (results != null) {
                                results.close();
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public Membership findMembership(String id) throws Exception {
        String[] membershipParts = id.split(",");
        Membership membership = this.findMembershipByUserGroupAndType(membershipParts[0], membershipParts[2], membershipParts[1]);
        return membership;
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        MembershipImpl membership = (MembershipImpl)this.cacheHandler.get((Serializable)((Object)this.cacheHandler.getMembershipKey(userName, groupId, type)), CacheHandler.CacheType.MEMBERSHIP);
        if (membership != null) {
            return membership;
        }
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                String userDN;
                membership = null;
                try {
                    userDN = this.getDNFromUsername(ctx, userName);
                    if (userDN == null) {
                        Membership membership2 = null;
                        return membership2;
                    }
                    userDN = userDN.trim();
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                String mbfilter = this.membershipClassFilter();
                String filter = "(&" + mbfilter + "(" + this.ldapAttrMapping.membershipTypeNameAttr + "=" + type + ")(" + this.ldapAttrMapping.membershipTypeMemberValue + "=" + userDN + "))";
                NamingEnumeration<SearchResult> results = this.findMembershipsInGroup(ctx, groupId, filter);
                if (results.hasMoreElements()) {
                    membership = this.createMembershipObject(userName, groupId, type);
                }
                if (membership != null) {
                    this.cacheHandler.put((Serializable)((Object)this.cacheHandler.getMembershipKey((Membership)membership)), membership, CacheHandler.CacheType.MEMBERSHIP);
                }
                MembershipImpl membershipImpl = membership;
                return membershipImpl;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                ArrayList<MembershipImpl> arrayList;
                block17: {
                    String userDN;
                    block15: {
                        ArrayList<MembershipImpl> arrayList2;
                        block16: {
                            memberships.clear();
                            userDN = this.getDNFromUsername(ctx, userName);
                            if (userDN != null) break block15;
                            arrayList2 = memberships;
                            if (results == null) break block16;
                            results.close();
                        }
                        return arrayList2;
                    }
                    try {
                        userDN = userDN.trim();
                        String userFilter = "(" + this.ldapAttrMapping.membershipTypeMemberValue + "=" + userDN + ")";
                        String mbfilter = this.membershipClassFilter();
                        String filter = "(&" + userFilter + mbfilter + ")";
                        results = this.findMembershipsInGroup(ctx, groupId, filter);
                        while (results.hasMoreElements()) {
                            SearchResult sr = results.next();
                            String type = this.explodeDN(sr.getNameInNamespace(), true)[0];
                            MembershipImpl membership = this.createMembershipObject(userName, groupId, type);
                            memberships.add(membership);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Retrieved " + memberships.size() + " memberships from ldap for user " + userName + " in group " + groupId));
                        }
                        arrayList = memberships;
                        if (results == null) break block17;
                    }
                    catch (NamingException e) {
                        try {
                            ctx = this.reloadCtx(ctx, err, e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (results != null) {
                                results.close();
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    private NamingEnumeration<SearchResult> findMembershipsInGroup(LdapContext ctx, String groupId, String filter) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        String groupDN = this.getGroupDNFromGroupId(groupId);
        return ctx.search(groupDN, filter, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUser(String userName) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        String mbfilter = this.membershipClassFilter();
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                ArrayList<MembershipImpl> arrayList;
                block18: {
                    String userDN;
                    block16: {
                        ArrayList<MembershipImpl> arrayList2;
                        block17: {
                            memberships.clear();
                            userDN = this.getDNFromUsername(ctx, userName);
                            if (userDN != null) break block16;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("User " + userName + " not found. "));
                            }
                            arrayList2 = memberships;
                            if (results == null) break block17;
                            results.close();
                        }
                        return arrayList2;
                    }
                    try {
                        userDN = userDN.trim();
                        String userFilter = "(" + this.ldapAttrMapping.membershipTypeMemberValue + "=" + userDN + ")";
                        String filter = "(&" + userFilter + mbfilter + ")";
                        SearchControls constraints = new SearchControls();
                        constraints.setSearchScope(2);
                        results = ctx.search(this.ldapAttrMapping.groupsURL, filter, constraints);
                        while (results.hasMoreElements()) {
                            SearchResult sr = results.next();
                            String membershipDN = sr.getNameInNamespace();
                            String groupId = this.getGroupIdFromGroupDN(this.getGroupDNFromMembershipDN(membershipDN));
                            String type = this.explodeDN(membershipDN, true)[0];
                            MembershipImpl membership = this.createMembershipObject(userName, groupId, type);
                            memberships.add(membership);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Retrieved " + memberships.size() + " memberships from ldap for user " + userName));
                        }
                        arrayList = memberships;
                        if (results == null) break block18;
                    }
                    catch (NamingException e) {
                        try {
                            ctx = this.reloadCtx(ctx, err, e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (results != null) {
                                results.close();
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByGroup(Group group) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                ArrayList<MembershipImpl> arrayList;
                block15: {
                    memberships.clear();
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Searching memberships of group " + group.getId() + ": "));
                        }
                        String groupDN = this.getGroupDNFromGroupId(group.getId());
                        SearchControls constraints = new SearchControls();
                        constraints.setSearchScope(1);
                        results = ctx.search(groupDN, this.ldapAttrMapping.membershipObjectClassFilter, constraints);
                        while (results.hasMoreElements()) {
                            SearchResult sr = results.next();
                            String membershipType = this.explodeDN(sr.getNameInNamespace(), true)[0];
                            Attributes attrs = sr.getAttributes();
                            Attribute attr = attrs.get(this.ldapAttrMapping.membershipTypeMemberValue);
                            for (int i = 0; i < attr.size(); ++i) {
                                String userDN = String.valueOf(attr.get(i));
                                String userName = this.ldapAttrMapping.userDNKey.equals(this.ldapAttrMapping.userUsernameAttr) ? this.explodeDN(userDN, true)[0] : this.findUserByDN(ctx, userDN).getUserName();
                                MembershipImpl membership = this.createMembershipObject(userName, group.getId(), membershipType);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("  found " + membership.toString()));
                                }
                                memberships.add(membership);
                            }
                        }
                        arrayList = memberships;
                        if (results == null) break block15;
                    }
                    catch (NamingException e) {
                        try {
                            ctx = this.reloadCtx(ctx, err, e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (results != null) {
                                results.close();
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    private MembershipImpl createMembershipObject(String userName, String groupId, String type) {
        MembershipImpl membership = new MembershipImpl();
        membership.setGroupId(groupId);
        membership.setUserName(userName);
        membership.setMembershipType(type);
        membership.setId(userName + "," + type + "," + groupId);
        return membership;
    }

    private void postDelete(Membership membership) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.postDelete(membership);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.preDelete(membership);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.postSave(membership, isNew);
        }
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.preSave(membership, isNew);
        }
    }

    public List<MembershipEventListener> getMembershipListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

